/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.deepblue.entities;

import com.dragn0007.deepblue.deepblueitems.DeepBlueItems;
import com.dragn0007.deepblue.entities.AbstractShark;
import com.dragn0007.deepblue.entities.krill_swarm.KrillSwarm;
import com.dragn0007.deepblue.entities.shrimp_swarm.ShrimpSwarm;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public abstract class AbstractMarineMammal
extends AbstractShark
implements Bucketable {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DeepBlueItems.KRILL_ITEM.get(), (ItemLike)DeepBlueItems.SHRIMP_ITEM.get(), Items.f_42526_, Items.f_42527_});
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(AbstractMarineMammal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int TOTAL_AIR_SUPPLY = 4800;
    static final TargetingConditions SWIM_WITH_PLAYER_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();

    protected AbstractMarineMammal(EntityType<? extends AbstractMarineMammal> p_30341_, Level p_30342_) {
        super(p_30341_, p_30342_);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @Override
    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    @Override
    public boolean m_6785_(double p_27492_) {
        return !this.m_27487_() && !this.m_8077_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    @Override
    public void m_27497_(boolean p_27498_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_27498_);
    }

    @Override
    public void m_7380_(CompoundTag p_27485_) {
        super.m_7380_(p_27485_);
        p_27485_.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag p_27465_) {
        super.m_7378_(p_27465_);
        this.m_27497_(p_27465_.m_128471_("FromBucket"));
    }

    @Override
    public void m_6872_(ItemStack p_27494_) {
        Bucketable.m_148822_((Mob)this, (ItemStack)p_27494_);
    }

    @Override
    public void m_142278_(CompoundTag p_148708_) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)p_148708_);
    }

    @Override
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    @Override
    protected InteractionResult m_6071_(Player p_27477_, InteractionHand p_27478_) {
        return Bucketable.m_148828_((Player)p_27477_, (InteractionHand)p_27478_, (LivingEntity)this).orElse(super.m_6071_(p_27477_, p_27478_));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new WhaleSwimWithPlayerGoal(this, 4.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DeepBlueItems.KRILL_ITEM.get(), (ItemLike)DeepBlueItems.SHRIMP_ITEM.get(), Items.f_42526_, Items.f_42527_}), false));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, KrillSwarm.class, false));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, ShrimpSwarm.class, false));
        this.f_21345_.m_25352_(9, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractShark.class, 8.0f, 1.0, 1.0));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_28332_, DifficultyInstance p_28333_, MobSpawnType p_28334_, @Nullable SpawnGroupData p_28335_, @Nullable CompoundTag p_28336_) {
        this.m_20301_(this.m_6062_());
        this.m_146926_(0.0f);
        return super.m_6518_(p_28332_, p_28333_, p_28334_, p_28335_, p_28336_);
    }

    public static boolean checkWhaleSpawnRules(EntityType<? extends WaterAnimal> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, Random random) {
        return levelAccessor.m_46801_(pos) && levelAccessor.m_46801_(pos.m_122012_()) && levelAccessor.m_46801_(pos.m_122029_()) && levelAccessor.m_46801_(pos.m_122019_()) && levelAccessor.m_46801_(pos.m_122024_());
    }

    @Override
    public boolean m_6040_() {
        return true;
    }

    protected void m_6229_(int p_28326_) {
    }

    public int m_6062_() {
        return 4800;
    }

    protected int m_7305_(int p_28389_) {
        return this.m_6062_();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_28374_) {
        return SoundEvents.f_11804_;
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11802_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_20069_() ? SoundEvents.f_11800_ : SoundEvents.f_11799_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_11807_;
    }

    @Override
    protected SoundEvent m_5501_() {
        return SoundEvents.f_11808_;
    }

    @Override
    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11883_;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader p_30348_) {
        return p_30348_.m_45784_((Entity)this);
    }

    public int m_8100_() {
        return 120;
    }

    protected int getExperienceReward(Player p_30353_) {
        return 1 + this.m_9236_().f_46441_.m_188503_(3);
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.m_6229_(i);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6573_(Player p_30346_) {
        return false;
    }

    @Override
    protected boolean canRandomSwim() {
        return true;
    }

    static class WhaleSwimWithPlayerGoal
    extends Goal {
        private final AbstractMarineMammal marineMammal;
        private final double speedModifier;
        @Nullable
        private Player player;

        WhaleSwimWithPlayerGoal(AbstractMarineMammal marineMammal, double p_28414_) {
            this.marineMammal = marineMammal;
            this.speedModifier = p_28414_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.player = this.marineMammal.m_9236_().m_45946_(SWIM_WITH_PLAYER_TARGETING, (LivingEntity)this.marineMammal);
            if (this.player == null) {
                return false;
            }
            return this.player.m_6069_() && this.marineMammal.m_5448_() != this.player;
        }

        public boolean m_8045_() {
            return this.player != null && this.player.m_6069_() && this.marineMammal.m_20280_((Entity)this.player) < 256.0;
        }

        public void m_8056_() {
            this.player.m_147207_(new MobEffectInstance(MobEffects.f_19593_, 100), (Entity)this.marineMammal);
        }

        public void m_8041_() {
            this.player = null;
            this.marineMammal.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.marineMammal.m_21563_().m_24960_((Entity)this.player, (float)(this.marineMammal.m_8085_() + 20), (float)this.marineMammal.m_8132_());
            if (this.marineMammal.m_20280_((Entity)this.player) < 6.25) {
                this.marineMammal.m_21573_().m_26573_();
            } else {
                this.marineMammal.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
            }
            if (this.player.m_6069_() && this.player.m_9236_().f_46441_.m_188503_(6) == 0) {
                this.player.m_147207_(new MobEffectInstance(MobEffects.f_19593_, 100), (Entity)this.marineMammal);
            }
        }
    }
}

