/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.mixin;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.stereowalker.tiered.Reforged;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public abstract class ItemStackClientMixin {
    private boolean isTiered = false;

    @Shadow
    public abstract CompoundTag m_41698_(String var1);

    @Shadow
    public abstract boolean m_41782_();

    @Shadow
    public abstract CompoundTag m_41737_(String var1);

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;getAmount()D")}, method={"getTooltipLines"}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void storeAttributeModifier(Player player, TooltipFlag context, CallbackInfoReturnable<List> cir, List list, MutableComponent component, int i, EquipmentSlot[] var6, int var7, int var8, EquipmentSlot equipmentSlot, Multimap multimap, Iterator var11, Map.Entry entry, AttributeModifier entityAttributeModifier) {
        this.isTiered = entityAttributeModifier.m_22214_().contains("tiered_");
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/network/chat/MutableComponent;withStyle(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/MutableComponent;", ordinal=5), method={"getTooltipLines"})
    private MutableComponent getTextFormatting(MutableComponent translatableText, ChatFormatting formatting) {
        if (Reforged.hasModifier((ItemStack)this) && this.isTiered) {
            ResourceLocation tier = VersionHelper.toLoc((String)this.m_41698_("Reforged").m_128461_("Tier"));
            PotentialAttribute attribute = Reforged.TIER_DATA.getTiers().get(tier);
            return translatableText.m_6270_(attribute.getStyle());
        }
        return translatableText.m_130940_(formatting);
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/Multimap;isEmpty()Z"), index=10)
    private Multimap<Attribute, AttributeModifier> sort(Multimap<Attribute, AttributeModifier> map) {
        LinkedListMultimap vanillaFirst = LinkedListMultimap.create();
        LinkedListMultimap remaining = LinkedListMultimap.create();
        map.forEach((arg_0, arg_1) -> ItemStackClientMixin.lambda$sort$0((Multimap)vanillaFirst, (Multimap)remaining, arg_0, arg_1));
        vanillaFirst.putAll((Multimap)remaining);
        return vanillaFirst;
    }

    @Inject(method={"getHoverName"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyName(CallbackInfoReturnable<Component> cir) {
        if (this.m_41782_() && this.m_41737_("display") == null && this.m_41737_("Reforged") != null) {
            ResourceLocation tier = new ResourceLocation(this.m_41698_("Reforged").m_128461_("Tier"));
            PotentialAttribute potentialAttribute = Reforged.TIER_DATA.getTiers().get(tier);
            if (potentialAttribute != null) {
                MutableComponent title = potentialAttribute.getLiteralName() != null ? Component.m_237113_((String)potentialAttribute.getLiteralName()) : Component.m_237115_((String)Util.m_137492_((String)"tier", (ResourceLocation)Reforged.getKey(potentialAttribute)));
                cir.setReturnValue((Object)title.m_130946_(" ").m_7220_((Component)cir.getReturnValue()).m_6270_(potentialAttribute.getStyle()));
            }
        }
    }

    private static /* synthetic */ void lambda$sort$0(Multimap vanillaFirst, Multimap remaining, Attribute entityAttribute, AttributeModifier entityAttributeModifier) {
        if (!entityAttributeModifier.m_22214_().contains("tiered")) {
            vanillaFirst.put((Object)entityAttribute, (Object)entityAttributeModifier);
        } else {
            remaining.put((Object)entityAttribute, (Object)entityAttributeModifier);
        }
    }
}

