/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.tiered.api;

import com.stereowalker.tiered.Reforged;
import com.stereowalker.tiered.api.PotentialAttribute;
import com.stereowalker.tiered.api.TierPool;
import com.stereowalker.unionlib.util.GeneralUtilities;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ModifierUtils {
    public static ResourceLocation getRandomAttributeIDFor(Item item) {
        PotentialAttribute chosen_tier;
        ResourceLocation itemKey = RegistryHelper.getItemKey((Item)item);
        TierPool pool = (TierPool)GeneralUtilities.getRandomFrom(Reforged.POOL_DATA.getPools().values(), p -> p.isValid(itemKey));
        if (pool == null) {
            chosen_tier = (PotentialAttribute)GeneralUtilities.getRandomFrom(Reforged.TIER_DATA.getTiers().values(), a -> a.isValid(itemKey));
        } else {
            ArrayList<PotentialAttribute> attris = new ArrayList<PotentialAttribute>();
            pool.getTiers().forEach(t -> attris.add(Reforged.TIER_DATA.getTiers().get(VersionHelper.toLoc((String)t))));
            attris.removeIf(attr -> attr == null);
            chosen_tier = (PotentialAttribute)GeneralUtilities.getRandomFrom(attris, null);
        }
        if (chosen_tier != null) {
            if (chosen_tier.isOld) {
                return VersionHelper.toLoc((String)chosen_tier.getID());
            }
            for (Map.Entry entry : Reforged.TIER_DATA.getTiers().entrySet()) {
                if (entry.getValue() != chosen_tier) continue;
                return (ResourceLocation)entry.getKey();
            }
        }
        ArrayList potentialAttributes = new ArrayList();
        Reforged.TIER_DATA.getTiers().forEach((id, attribute) -> {
            if (attribute.isValid(itemKey)) {
                potentialAttributes.add(id);
            }
        });
        if (potentialAttributes.size() > 0) {
            return (ResourceLocation)potentialAttributes.get(new Random().nextInt(potentialAttributes.size()));
        }
        return null;
    }

    public static ResourceLocation getBlankAttributeIDFor(Item item) {
        ResourceLocation itemKey = RegistryHelper.getItemKey((Item)item);
        PotentialAttribute chosen_tier = null;
        for (TierPool tierPool : Reforged.POOL_DATA.getPools().values()) {
            if (tierPool == null) {
                chosen_tier = (PotentialAttribute)GeneralUtilities.getRandomFrom(Reforged.TIER_DATA.getTiers().values(), a -> a.isValid(itemKey) && a.getAttributes().size() == 0);
            } else {
                ArrayList<PotentialAttribute> attris = new ArrayList<PotentialAttribute>();
                tierPool.getTiers().forEach(t -> attris.add(Reforged.TIER_DATA.getTiers().get(VersionHelper.toLoc((String)t))));
                attris.removeIf(attr -> attr == null || attr.getAttributes().size() > 0);
                chosen_tier = (PotentialAttribute)GeneralUtilities.getRandomFrom(attris, null);
            }
            if (chosen_tier == null) continue;
            break;
        }
        if (chosen_tier != null) {
            if (chosen_tier.isOld) {
                return VersionHelper.toLoc((String)chosen_tier.getID());
            }
            for (Map.Entry entry : Reforged.TIER_DATA.getTiers().entrySet()) {
                if (entry.getValue() != chosen_tier) continue;
                return (ResourceLocation)entry.getKey();
            }
        }
        ArrayList potentialAttributes = new ArrayList();
        Reforged.TIER_DATA.getTiers().forEach((id, attribute) -> {
            if (attribute.isValid(itemKey)) {
                potentialAttributes.add(id);
            }
        });
        if (potentialAttributes.size() > 0) {
            return (ResourceLocation)potentialAttributes.get(new Random().nextInt(potentialAttributes.size()));
        }
        return null;
    }

    private ModifierUtils() {
    }
}

