/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

public class WandUtil {
    @Nullable
    public static Portal getPortalByUUID(Level world, UUID portalId) {
        if (portalId == null) {
            return null;
        }
        Entity entity = McHelper.getEntityByUUID((Level)world, (UUID)portalId);
        if (entity instanceof Portal) {
            Portal portal = (Portal)entity;
            return portal;
        }
        return null;
    }

    public static Vec3 alignOnBlocks(Level world, Vec3 vec3, int gridCount) {
        if (gridCount == 0) {
            return vec3;
        }
        BlockPos blockPos = BlockPos.m_274446_((Position)vec3);
        return new IntBox(blockPos.m_7918_(-1, -1, -1), blockPos.m_7918_(1, 1, 1)).stream().flatMap(pos -> {
            BlockState blockState = world.m_8055_(pos);
            VoxelShape collisionShape = blockState.m_60812_((BlockGetter)world, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            List aabbs = collisionShape.m_83299_();
            if (aabbs.size() != 1) {
                aabbs.add(new AABB(pos));
            }
            return aabbs.stream();
        }).map(box -> Helper.alignToBoxSurface((AABB)box, (Vec3)vec3, (int)gridCount)).min(Comparator.comparingDouble(p -> p.m_82557_(vec3))).orElse(null);
    }
}

