/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import java.util.ArrayList;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalCopy;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalCreation;
import qouteall.imm_ptl.peripheral.wand.ClientPortalWandPortalDrag;
import qouteall.imm_ptl.peripheral.wand.PortalWandInteraction;

public class PortalWandItem
extends Item {
    public static final PortalWandItem instance = new PortalWandItem(new Item.Properties());
    private static boolean instructionInformed = false;

    public static void init() {
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.f_256869_).register(groupEntries -> {
            ItemStack s1 = new ItemStack((ItemLike)instance);
            s1.m_41751_(Mode.CREATE_PORTAL.toTag());
            groupEntries.m_246342_(s1);
            ItemStack s2 = new ItemStack((ItemLike)instance);
            s2.m_41751_(Mode.DRAG_PORTAL.toTag());
            groupEntries.m_246342_(s2);
            ItemStack s3 = new ItemStack((ItemLike)instance);
            s3.m_41751_(Mode.COPY_PORTAL.toTag());
            groupEntries.m_246342_(s3);
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (player.m_21205_().m_41720_() == instance) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        });
        BlockManipulationServer.canDoCrossPortalInteractionEvent.register(p -> p.m_21205_().m_41720_() != instance);
    }

    public static void initClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.f_91074_ != null) {
                ItemStack itemStack = client.f_91074_.m_21205_();
                if (itemStack.m_41720_() == instance) {
                    PortalWandItem.updateDisplay((ItemStack)itemStack);
                } else {
                    ClientPortalWandPortalCreation.clearCursorPointing();
                }
            }
            ClientPortalWandPortalDrag.tick();
        });
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalCreation::reset);
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalDrag::reset);
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalCopy::reset);
    }

    public PortalWandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Mode mode = Mode.fromTag(itemStack.m_41784_());
        if (player.m_6144_() && !world.m_5776_() && !PortalWandInteraction.isDragging((ServerPlayer)player)) {
            Mode nextMode = mode.next();
            itemStack.m_41751_(nextMode.toTag());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        if (!player.m_6144_() && world.m_5776_()) {
            this.onUseClient(mode);
        }
        return super.m_7203_(world, player, hand);
    }

    public Component m_7626_(ItemStack stack) {
        Mode mode = Mode.fromTag(stack.m_41784_());
        MutableComponent baseText = Component.m_237115_((String)"item.immersive_portals.portal_wand");
        return baseText.m_7220_((Component)Component.m_237113_((String)" : ")).m_7220_((Component)mode.getText().m_130940_(ChatFormatting.GOLD));
    }

    public static void showSettings(Player player) {
        player.m_213846_((Component)Component.m_237115_((String)"imm_ptl.wand.settings_1"));
        player.m_213846_((Component)Component.m_237115_((String)"imm_ptl.wand.settings_alignment"));
        int[] alignments = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 16, 32, 64};
        ArrayList<MutableComponent> alignmentSettingTexts = new ArrayList<MutableComponent>();
        for (int alignment : alignments) {
            MutableComponent textWithCommand = IPMcHelper.getTextWithCommand((MutableComponent)Component.m_237113_((String)("1/" + alignment)), (String)("/imm_ptl_client_debug wand set_cursor_alignment " + alignment));
            alignmentSettingTexts.add(textWithCommand);
        }
        alignmentSettingTexts.add(IPMcHelper.getTextWithCommand((MutableComponent)Component.m_237115_((String)"imm_ptl.wand.no_alignment"), (String)"/imm_ptl_client_debug wand set_cursor_alignment 0"));
        player.m_213846_((Component)alignmentSettingTexts.stream().reduce(Component.m_237113_((String)""), (a, b) -> a.m_130946_(" ").m_7220_((Component)b)));
        player.m_213846_((Component)Component.m_237110_((String)"imm_ptl.wand.settings_2", (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92098_.m_90863_()}));
    }

    public static enum Mode {
        CREATE_PORTAL,
        DRAG_PORTAL,
        COPY_PORTAL;


        public static Mode fromTag(CompoundTag tag) {
            String mode;
            return switch (mode = tag.m_128461_("mode")) {
                case "create_portal" -> CREATE_PORTAL;
                case "drag_portal" -> DRAG_PORTAL;
                case "copy_portal" -> COPY_PORTAL;
                default -> CREATE_PORTAL;
            };
        }

        public Mode next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CREATE_PORTAL -> DRAG_PORTAL;
                case DRAG_PORTAL -> COPY_PORTAL;
                case COPY_PORTAL -> CREATE_PORTAL;
            };
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            String modeString = switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CREATE_PORTAL -> "create_portal";
                case DRAG_PORTAL -> "drag_portal";
                case COPY_PORTAL -> "copy_portal";
            };
            tag.m_128359_("mode", modeString);
            return tag;
        }

        public MutableComponent getText() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case CREATE_PORTAL -> Component.m_237115_((String)"imm_ptl.wand.mode.create_portal");
                case DRAG_PORTAL -> Component.m_237115_((String)"imm_ptl.wand.mode.drag_portal");
                case COPY_PORTAL -> Component.m_237115_((String)"imm_ptl.wand.mode.copy_portal");
            };
        }
    }
}

