/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.ClientPortalAnimationManagement;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.util.PortalLocalXYNormalized;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.ImmPtlCustomOverlay;
import qouteall.imm_ptl.peripheral.wand.PortalCorner;
import qouteall.imm_ptl.peripheral.wand.PortalWandInteraction;
import qouteall.imm_ptl.peripheral.wand.PortalWandItem;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Sphere;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPlane;
import qouteall.q_misc_util.my_util.animation.RenderedPoint;

@Environment(value=EnvType.CLIENT)
public class ClientPortalWandPortalDrag {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static UUID selectedPortalId;
    @Nullable
    private static PortalLocalXYNormalized lockedAnchor;
    private static boolean lockWidth;
    private static boolean lockHeight;
    @Nullable
    private static SelectionStatus selectionStatus;
    public static Animated<RenderedPoint> cursor;
    public static Animated<UnilateralPortalState> renderedRect;
    public static Animated<RenderedPlane> renderedPlane;
    private static Animated<RenderedPoint> renderedLockedAnchor;
    private static Animated<Double> renderedWidthLineSegment;
    private static Animated<Double> renderedHeightLineSegment;
    private static Animated<Double> renderedWidthLock;
    private static Animated<Double> renderedHeightLock;
    @Nullable
    public static DraggingContext draggingContext;
    private static boolean isUndoing;
    private static final int colorOfCursor = -16515844;
    private static final int colorOfRect1 = -1309700;
    private static final int colorOfRect2 = -218877;
    private static final int colorOfPlane = -1;
    private static final int colorOfLock = -1;
    private static final int colorOfWidthLine = -16516018;
    private static final int colorOfHeightLine = -198653;
    private static final int colorOfCursorInLock = -384160;
    private static final int colorOfSphere = -1;

    public static void init() {
        ClientPortalAnimationManagement.clientAnimationUpdateSignal.connect(ClientPortalWandPortalDrag::updateDraggedPortalAnimation);
    }

    public static void reset() {
        selectedPortalId = null;
        ClientPortalWandPortalDrag.clearLock();
        selectionStatus = null;
        cursor.clearTarget();
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        draggingContext = null;
        isUndoing = false;
    }

    public static void onLeftClick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            ClientPortalWandPortalDrag.undoDragging();
        } else if (selectionStatus != null) {
            if (ClientPortalWandPortalDrag.selectionStatus.selectsHorizontalEdge) {
                lockWidth = !lockWidth;
                ImmPtlCustomOverlay.putText((Component)Component.m_237115_((String)(lockWidth ? "imm_ptl.wand.width_locked" : "imm_ptl.wand.width_unlocked")).m_130940_(ChatFormatting.GOLD), 3.0, "0_alert");
            } else if (ClientPortalWandPortalDrag.selectionStatus.selectsVerticalEdge) {
                lockHeight = !lockHeight;
                ImmPtlCustomOverlay.putText((Component)Component.m_237115_((String)(lockHeight ? "imm_ptl.wand.height_locked" : "imm_ptl.wand.height_unlocked")).m_130940_(ChatFormatting.GOLD), 3.0, "0_alert");
            } else {
                PortalLocalXYNormalized selectedAnchor = ClientPortalWandPortalDrag.selectionStatus.selectedAnchor;
                if (lockedAnchor != null && lockedAnchor.isCloseTo(selectedAnchor, 0.01)) {
                    lockedAnchor = null;
                    ImmPtlCustomOverlay.putText((Component)Component.m_237115_((String)"imm_ptl.wand.anchor_unlocked").m_130940_(ChatFormatting.GOLD), 3.0, "0_alert");
                } else {
                    ImmPtlCustomOverlay.putText((Component)Component.m_237115_((String)(lockedAnchor != null ? "imm_ptl.wand.anchor_lock_moved" : "imm_ptl.wand.anchor_locked")).m_130940_(ChatFormatting.GOLD), 3.0, "0_alert");
                    lockedAnchor = selectedAnchor;
                }
            }
        }
    }

    public static void onRightClick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            return;
        }
        if (isUndoing) {
            return;
        }
        ClientPortalWandPortalDrag.startDragging();
    }

    public static void tick() {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging() && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() != PortalWandItem.instance && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() != PortalWandItem.instance) {
            LOGGER.info("Undo dragging because the player is not holding the wand");
            ClientPortalWandPortalDrag.undoDragging();
        }
    }

    public static boolean isDragging() {
        return draggingContext != null;
    }

    public static void updateDisplay() {
        Pair rectTurning;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (!minecraft.f_91066_.f_92095_.m_90857_()) {
            isUndoing = false;
        }
        if (isUndoing) {
            return;
        }
        if (draggingContext != null) {
            ClientPortalWandPortalDrag.handleDragging(player, draggingContext);
            return;
        }
        Portal originalSelectedPortal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (originalSelectedPortal == null) {
            ClientPortalWandPortalDrag.reset();
        }
        Vec3 eyePos = player.m_20299_(RenderStates.getPartialTick());
        Vec3 viewVec = player.m_20154_();
        Pair rayTraceResult = PortalUtils.lenientRayTracePortals((Level)player.m_9236_(), (Vec3)eyePos, (Vec3)eyePos.m_82549_(viewVec.m_82490_(64.0)), (boolean)false, p -> true, (double)1.0).orElse(null);
        if (rayTraceResult == null) {
            selectionStatus = null;
            cursor.clearTarget();
            renderedPlane.clearTarget();
            ImmPtlCustomOverlay.putText((Component)Component.m_237115_((String)"imm_ptl.wand.select_portal"));
            if (originalSelectedPortal == null) {
                renderedRect.clearTarget();
            } else {
                renderedRect.setTarget((Object)originalSelectedPortal.getThisSideState(), Helper.secondToNano((double)1.0));
            }
            return;
        }
        Portal portal = (Portal)rayTraceResult.getFirst();
        Vec3 hitPos = (Vec3)rayTraceResult.getSecond();
        if (selectedPortalId == null) {
            selectedPortalId = portal.m_20148_();
        } else if (!Objects.equals(selectedPortalId, portal.m_20148_())) {
            if (originalSelectedPortal != null && Portal.isFlippedPortal((Portal)originalSelectedPortal, (Portal)portal)) {
                Vec3 lockedAnchorPos;
                if (lockedAnchor != null && !(lockedAnchor = PortalLocalXYNormalized.fromPos((Portal)portal, (Vec3)(lockedAnchorPos = lockedAnchor.getPos(originalSelectedPortal)))).isValid()) {
                    lockedAnchor = null;
                }
            } else {
                selectionStatus = null;
                if (ClientPortalWandPortalDrag.hasLock()) {
                    ImmPtlCustomOverlay.putText((Component)Component.m_237115_((String)"imm_ptl.wand.lock_cleared").m_130940_(ChatFormatting.GOLD), 5.0, "1_alert");
                    ClientPortalWandPortalDrag.clearLock();
                }
            }
            selectedPortalId = portal.m_20148_();
        }
        PortalLocalXYNormalized rawSelection = PortalLocalXYNormalized.fromPos((Portal)portal, (Vec3)hitPos);
        int cursorAlignment = IPConfig.getConfig().portalWandCursorAlignment;
        PortalLocalXYNormalized selection = cursorAlignment == 0 ? rawSelection.clamp() : rawSelection.clamp().snapToGrid(cursorAlignment);
        boolean selectsHorizontalEdge = rawSelection.ny() < 0.0 || rawSelection.ny() > 1.0;
        boolean selectsVerticalEdge = rawSelection.nx() < 0.0 || rawSelection.nx() > 1.0;
        selectionStatus = new SelectionStatus(selection, selectsHorizontalEdge, selectsVerticalEdge);
        Vec3 cursorPos = selection.getPos(portal);
        cursor.setTarget((Object)new RenderedPoint(new WithDim(player.m_9236_().m_46472_(), (Object)cursorPos), 1.0), Helper.secondToNano((double)0.5));
        UnilateralPortalState lastRenderedRect = (UnilateralPortalState)renderedRect.getCurrent();
        UnilateralPortalState newRenderedRect = portal.getThisSideState();
        if (lastRenderedRect != null && ((UnilateralPortalState.RectInvariant)(rectTurning = lastRenderedRect.turnToClosestTo(newRenderedRect.orientation())).getFirst()).switchesWidthAndHeight()) {
            Animated<Double> temp = renderedWidthLineSegment;
            renderedWidthLineSegment = renderedHeightLineSegment;
            renderedHeightLineSegment = temp;
        }
        renderedRect.setTarget((Object)newRenderedRect, Helper.secondToNano((double)1.0));
        Pair<Plane, MutableComponent> planeInfo = ClientPortalWandPortalDrag.getPlayerFacingPlaneAligned((Player)player, cursorPos, portal);
        if (selectsHorizontalEdge) {
            ImmPtlCustomOverlay.putText((Component)Component.m_237110_((String)"imm_ptl.wand.lock_width", (Object[])new Object[]{minecraft.f_91066_.f_92096_.m_90863_()}));
        } else if (selectsVerticalEdge) {
            ImmPtlCustomOverlay.putText((Component)Component.m_237110_((String)"imm_ptl.wand.lock_height", (Object[])new Object[]{minecraft.f_91066_.f_92096_.m_90863_()}));
        } else {
            MutableComponent planeText = Component.m_237110_((String)"imm_ptl.wand.on_plane", (Object[])new Object[]{((MutableComponent)planeInfo.getSecond()).m_130940_(ChatFormatting.GOLD)});
            ImmPtlCustomOverlay.putText((Component)Component.m_237110_((String)"imm_ptl.wand.pre_drag", (Object[])new Object[]{minecraft.f_91066_.f_92096_.m_90863_(), minecraft.f_91066_.f_92095_.m_90863_(), planeText}));
        }
    }

    private static boolean hasLock() {
        return lockedAnchor != null || lockWidth || lockHeight;
    }

    private static void clearLock() {
        lockedAnchor = null;
        lockWidth = false;
        lockHeight = false;
        renderedLockedAnchor.clearTarget();
        renderedWidthLineSegment.clearTarget();
        renderedHeightLineSegment.clearTarget();
        renderedWidthLock.clearTarget();
        renderedHeightLock.clearTarget();
    }

    private static void handleDragging(LocalPlayer player, DraggingContext draggingContext) {
        Vec3 eyePos = player.m_20299_(RenderStates.getPartialTick());
        Vec3 viewVec = player.m_20154_();
        ResourceKey currDim = player.m_9236_().m_46472_();
        if (draggingContext.dimension != currDim) {
            ClientPortalWandPortalDrag.stopDragging();
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (!minecraft.f_91066_.f_92095_.m_90857_()) {
            ClientPortalWandPortalDrag.stopDragging();
            return;
        }
        Vec3 cursorPos = null;
        Plane plane = draggingContext.limitingPlane();
        Sphere sphere = draggingContext.limitingSphere;
        int alignment = IPConfig.getConfig().portalWandCursorAlignment;
        if (plane != null) {
            cursorPos = plane.rayTrace(eyePos, viewVec);
            if (cursorPos != null) {
                cursorPos = ClientPortalWandPortalDrag.align(cursorPos, alignment);
                cursorPos = plane.getProjection(cursorPos);
            }
        } else if (sphere != null && (cursorPos = sphere.rayTrace(eyePos, viewVec)) != null) {
            cursorPos = ClientPortalWandPortalDrag.align(cursorPos, alignment);
            cursorPos = sphere.projectToSphere(cursorPos);
        }
        if (cursorPos != null) {
            Vec3 originalCursorTarget = (Vec3)((RenderedPoint)cursor.getTarget()).pos().value();
            if (originalCursorTarget == null) {
                return;
            }
            if (originalCursorTarget.m_82554_(cursorPos) > 1.0E-6) {
                cursor.setTarget((Object)new RenderedPoint(new WithDim(currDim, (Object)cursorPos), 1.0), Helper.secondToNano((double)0.2));
                ClientPortalWandPortalDrag.onDrag(cursorPos, draggingContext);
            }
        }
        MutableComponent draggingText = Component.m_237115_((String)"imm_ptl.wand.dragging");
        MutableComponent planeText = draggingContext.planeText() == null ? Component.m_237113_((String)"") : Component.m_237110_((String)"imm_ptl.wand.on_plane", (Object[])new Object[]{draggingContext.planeText()});
        MutableComponent undoPrompt = Component.m_237113_((String)"\n").m_7220_((Component)Component.m_237110_((String)"imm_ptl.wand.left_click_to_undo", (Object[])new Object[]{minecraft.f_91066_.f_92096_.m_90863_()}));
        MutableComponent cursorPosText = cursorPos == null ? Component.m_237113_((String)"") : Component.m_237113_((String)"\n").m_7220_((Component)Component.m_237110_((String)"imm_ptl.wand.cursor_pos", (Object[])new Object[]{"%.3f".formatted(cursorPos.f_82479_), "%.3f".formatted(cursorPos.f_82480_), "%.3f".formatted(cursorPos.f_82481_)}));
        Portal portal = WandUtil.getClientPortalByUUID((UUID)draggingContext.portalId());
        boolean shouldDisplaySize = lockedAnchor != null;
        PortalState animationEndingState = ClientPortalWandPortalDrag.getAnimationEndingState();
        MutableComponent portalSizeText = portal != null && shouldDisplaySize && animationEndingState != null ? Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)"imm_ptl.wand.portal_size", (Object[])new Object[]{"%.3f".formatted(animationEndingState.width), "%.3f".formatted(animationEndingState.height), "%.3f".formatted(animationEndingState.scaling)})) : Component.m_237113_((String)"");
        ImmPtlCustomOverlay.putText((Component)draggingText.m_7220_((Component)planeText).m_7220_((Component)undoPrompt).m_7220_((Component)cursorPosText).m_7220_((Component)portalSizeText));
    }

    private static Vec3 align(Vec3 pos, int alignment) {
        if (alignment == 0) {
            return pos;
        }
        return new Vec3((double)Math.round(pos.m_7096_() * (double)alignment) / (double)alignment, (double)Math.round(pos.m_7098_() * (double)alignment) / (double)alignment, (double)Math.round(pos.m_7094_() * (double)alignment) / (double)alignment);
    }

    private static void startDragging() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (ClientPortalWandPortalDrag.isDragging()) {
            LOGGER.error("start dragging when already dragging");
            return;
        }
        if (!Minecraft.m_91087_().f_91066_.f_92095_.m_90857_()) {
            LOGGER.error("start dragging when not right clicking");
            return;
        }
        Portal portal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (portal == null) {
            return;
        }
        RenderedPoint cursorTarget = (RenderedPoint)cursor.getTarget();
        if (cursorTarget == null) {
            return;
        }
        WithDim cursorTargetPos = cursorTarget.pos();
        if (cursorTargetPos == null) {
            return;
        }
        Vec3 cursorPos = (Vec3)cursorTargetPos.value();
        if (cursorPos == null) {
            return;
        }
        if (selectionStatus == null) {
            return;
        }
        PortalLocalXYNormalized selectedAnchor = ClientPortalWandPortalDrag.selectionStatus.selectedAnchor;
        if (lockedAnchor != null && lockedAnchor.isCloseTo(selectedAnchor, 0.01)) {
            return;
        }
        PortalWandInteraction.DraggingInfo draggingInfo = new PortalWandInteraction.DraggingInfo(lockedAnchor, selectedAnchor, null, lockWidth, lockHeight);
        ResourceKey currDim = player.m_9236_().m_46472_();
        Pair<Plane, MutableComponent> info = ClientPortalWandPortalDrag.getPlayerFacingPlaneAligned((Player)player, cursorPos, portal);
        Plane plane = (Plane)info.getFirst();
        renderedPlane.setTarget((Object)new RenderedPlane(new WithDim(currDim, (Object)plane), 1.0), Helper.secondToNano((double)0.5));
        draggingContext = new DraggingContext((ResourceKey<Level>)currDim, portal.m_20148_(), plane, null, draggingInfo, ((MutableComponent)info.getSecond()).m_130940_(ChatFormatting.GOLD), portal.getPortalState());
    }

    private static void stopDragging() {
        draggingContext = null;
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.finishDragging", (Object[])new Object[0]);
    }

    private static void undoDragging() {
        McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.undoDrag", (Object[])new Object[0]);
        renderedPlane.clearTarget();
        renderedRect.clearTarget();
        draggingContext = null;
        isUndoing = true;
    }

    private static void onDrag(Vec3 cursorPos, DraggingContext draggingContext) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Portal portal = WandUtil.getClientPortalByUUID((UUID)draggingContext.portalId());
        if (portal == null) {
            LOGGER.error("cannot find portal to drag {}", (Object)selectedPortalId);
            ClientPortalWandPortalDrag.reset();
            return;
        }
        PortalWandInteraction.DraggingInfo draggingInfo = draggingContext.draggingInfo();
        UnilateralPortalState newThisSideState = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), cursorPos, draggingInfo, true);
        boolean isValid = PortalWandInteraction.validateDraggedPortalState(draggingContext.originalPortalState(), newThisSideState, (Player)player);
        if (isValid) {
            McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.requestApplyDrag", (Object[])new Object[]{selectedPortalId, cursorPos, draggingInfo});
            ImmPtlCustomOverlay.remove("1_invalid_dragging");
        } else {
            ImmPtlCustomOverlay.putText((Component)Component.m_237115_((String)"imm_ptl.wand.invalid_dragging").m_130940_(ChatFormatting.RED), 3.0, "1_invalid_dragging");
        }
    }

    @Nullable
    private static Portal getSelectedPortal() {
        return WandUtil.getClientPortalByUUID((UUID)selectedPortalId);
    }

    private static Pair<Plane, MutableComponent> getPlayerFacingPlaneAligned(Player player, Vec3 cursorPos, Portal portal) {
        ArrayList<Pair> candidates = new ArrayList<Pair>();
        Vec3 X = new Vec3(1.0, 0.0, 0.0);
        Vec3 Y = new Vec3(0.0, 1.0, 0.0);
        Vec3 Z = new Vec3(0.0, 0.0, 1.0);
        candidates.add(Pair.of((Object)new Plane(cursorPos, X), (Object)Component.m_237115_((String)"imm_ptl.wand.plane.x")));
        candidates.add(Pair.of((Object)new Plane(cursorPos, Y), (Object)Component.m_237115_((String)"imm_ptl.wand.plane.y")));
        candidates.add(Pair.of((Object)new Plane(cursorPos, Z), (Object)Component.m_237115_((String)"imm_ptl.wand.plane.z")));
        Predicate<Vec3> isOrthodox = p -> Math.abs(p.m_82526_(X)) > 0.9999 || Math.abs(p.m_82526_(Y)) > 0.9999 || Math.abs(p.m_82526_(Z)) > 0.9999;
        if (!isOrthodox.test(portal.axisW)) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.axisW), (Object)Component.m_237115_((String)"imm_ptl.wand.plane.portal_x")));
        }
        if (!isOrthodox.test(portal.axisH)) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.axisH), (Object)Component.m_237115_((String)"imm_ptl.wand.plane.portal_y")));
        }
        if (!isOrthodox.test(portal.getNormal())) {
            candidates.add(Pair.of((Object)new Plane(cursorPos, portal.getNormal()), (Object)Component.m_237115_((String)"imm_ptl.wand.plane.portal_z")));
        }
        Vec3 viewVec = player.m_20154_();
        return Stream.concat(candidates.stream(), candidates.stream().map(p -> Pair.of((Object)((Plane)p.getFirst()).getOpposite(), (Object)((MutableComponent)p.getSecond())))).min(Comparator.comparingDouble(p -> ((Plane)p.getFirst()).normal().m_82526_(viewVec))).orElseThrow();
    }

    public static void render(PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (PortalRendering.isRendering()) {
            return;
        }
        renderedWidthLock.setTarget((Object)(lockWidth ? 1.0 : 0.0), Helper.secondToNano((double)0.5));
        renderedHeightLock.setTarget((Object)(lockHeight ? 1.0 : 0.0), Helper.secondToNano((double)0.5));
        renderedWidthLineSegment.setTarget((Object)(lockWidth || selectionStatus != null && ClientPortalWandPortalDrag.selectionStatus.selectsHorizontalEdge && draggingContext == null ? 1.0 : 0.0), Helper.secondToNano((double)0.5));
        renderedHeightLineSegment.setTarget((Object)(lockHeight || selectionStatus != null && ClientPortalWandPortalDrag.selectionStatus.selectsVerticalEdge && draggingContext == null ? 1.0 : 0.0), Helper.secondToNano((double)0.5));
        ResourceKey currDim = player.m_9236_().m_46472_();
        Vec3 cameraPos = new Vec3(camX, camY, camZ);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        Vec3 renderedCursor = ClientPortalWandPortalDrag.getCursorToRender();
        if (renderedCursor != null) {
            WireRenderingHelper.renderSmallCubeFrame((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)renderedCursor, (int)-16515844, (double)((RenderedPoint)cursor.getCurrent()).scale(), (PoseStack)matrixStack);
        }
        Portal portal = null;
        if (draggingContext != null) {
            portal = WandUtil.getClientPortalByUUID((UUID)ClientPortalWandPortalDrag.draggingContext.portalId);
        }
        if (portal == null && selectedPortalId != null) {
            portal = ClientPortalWandPortalDrag.getSelectedPortal();
        }
        UnilateralPortalState rect = null;
        if (draggingContext != null) {
            if (portal != null) {
                rect = portal.getThisSideState();
                ClientPortalWandPortalDrag.renderRect(matrixStack, cameraPos, vertexConsumer, rect);
                renderedRect.setTarget((Object)rect, 0L);
            }
        } else {
            rect = (UnilateralPortalState)renderedRect.getCurrent();
            if (rect != null && rect.dimension() == currDim) {
                ClientPortalWandPortalDrag.renderRect(matrixStack, cameraPos, vertexConsumer, rect);
            }
        }
        if (lockedAnchor != null && portal != null) {
            renderedLockedAnchor.setTarget((Object)new RenderedPoint(new WithDim(portal.getOriginDim(), (Object)lockedAnchor.getPos(portal)), 1.0), Helper.secondToNano((double)0.5));
        } else {
            renderedLockedAnchor.clearTarget();
        }
        if (portal != null) {
            RenderedPoint current = (RenderedPoint)renderedLockedAnchor.getCurrent();
            if (current != null && current.pos() != null && current.pos().dimension() == currDim) {
                Vec3 lockPos = (Vec3)current.pos().value();
                if (draggingContext != null && lockedAnchor != null) {
                    lockPos = lockedAnchor.getPos(portal);
                }
                double lockExtraScale = ClientPortalWandPortalDrag.getLockExtraScale(portal.getThisSideState());
                matrixStack.m_85836_();
                matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                WireRenderingHelper.renderLockShape((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)lockPos, (double)(current.scale() * lockExtraScale), (int)-1, (PoseStack)matrixStack);
                matrixStack.m_85849_();
                WireRenderingHelper.renderSmallCubeFrame((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)lockPos, (int)-384160, (double)(current.scale() * lockExtraScale), (PoseStack)matrixStack);
            }
            ClientPortalWandPortalDrag.renderWidthHeightLock(matrixStack, cameraPos, vertexConsumer, portal.getThisSideState());
        }
        if (rect != null) {
            ClientPortalWandPortalDrag.renderWidthHeightLineSegment(matrixStack, cameraPos, vertexConsumer, rect);
        }
        VertexConsumer debugLineStripConsumer = bufferSource.m_6299_(RenderType.m_269399_((double)1.0));
        RenderedPlane plane = (RenderedPlane)renderedPlane.getCurrent();
        if (plane != null && plane.plane() != null && plane.plane().dimension() == currDim) {
            Plane planeValue = (Plane)plane.plane().value();
            if (renderedCursor != null) {
                planeValue = planeValue.getParallelPlane(renderedCursor);
            }
            WireRenderingHelper.renderPlane((VertexConsumer)debugLineStripConsumer, (Vec3)cameraPos, (Plane)planeValue, (double)plane.scale(), (int)-1, (PoseStack)matrixStack);
        }
    }

    @Nullable
    private static Vec3 getCursorToRender() {
        if (draggingContext != null) {
            Portal portal = WandUtil.getClientPortalByUUID((UUID)ClientPortalWandPortalDrag.draggingContext.portalId);
            if (portal != null) {
                return ClientPortalWandPortalDrag.draggingContext.draggingInfo().draggingAnchor.getPos(portal);
            }
            return null;
        }
        RenderedPoint renderedPoint = (RenderedPoint)cursor.getCurrent();
        assert (renderedPoint != null);
        WithDim pos = renderedPoint.pos();
        if (pos == null) {
            return null;
        }
        return (Vec3)pos.value();
    }

    public static void renderRect(PoseStack matrixStack, Vec3 cameraPos, VertexConsumer vertexConsumer, UnilateralPortalState rect) {
        WireRenderingHelper.renderRectFrameFlow((PoseStack)matrixStack, (Vec3)cameraPos, (VertexConsumer)vertexConsumer, (UnilateralPortalState)rect, (int)-1309700, (int)-218877);
    }

    private static double getLockExtraScale(UnilateralPortalState rect) {
        return Math.sqrt(rect.width() * rect.height()) * 0.2;
    }

    private static void renderWidthHeightLock(PoseStack matrixStack, Vec3 cameraPos, VertexConsumer vertexConsumer, UnilateralPortalState rect) {
        Double heightLockAnim;
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        double lockPadding = 0.1;
        double lockExtraScale = ClientPortalWandPortalDrag.getLockExtraScale(rect);
        Double widthLockAnim = (Double)renderedWidthLock.getCurrent();
        if (widthLockAnim != null && widthLockAnim > 0.001) {
            WireRenderingHelper.renderLockShape((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)new PortalLocalXYNormalized(0.5, -lockPadding).getPos(rect), (double)(widthLockAnim * lockExtraScale), (int)-16516018, (PoseStack)matrixStack);
            WireRenderingHelper.renderLockShape((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)new PortalLocalXYNormalized(0.5, 1.0 + lockPadding).getPos(rect), (double)(widthLockAnim * lockExtraScale), (int)-16516018, (PoseStack)matrixStack);
        }
        if ((heightLockAnim = (Double)renderedHeightLock.getCurrent()) != null && heightLockAnim > 0.001) {
            WireRenderingHelper.renderLockShape((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)new PortalLocalXYNormalized(-lockPadding, 0.5).getPos(rect), (double)(heightLockAnim * lockExtraScale), (int)-198653, (PoseStack)matrixStack);
            WireRenderingHelper.renderLockShape((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)new PortalLocalXYNormalized(1.0 + lockPadding, 0.5).getPos(rect), (double)(heightLockAnim * lockExtraScale), (int)-198653, (PoseStack)matrixStack);
        }
        matrixStack.m_85849_();
    }

    private static void renderWidthHeightLineSegment(PoseStack matrixStack, Vec3 cameraPos, VertexConsumer vertexConsumer, UnilateralPortalState rect) {
        Double heightLineAnim;
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        double padding1 = 0.04;
        double padding2 = padding1 + 0.02;
        double padding3 = padding2 + 0.03;
        Double widthLineAnim = (Double)renderedWidthLineSegment.getCurrent();
        if (widthLineAnim != null && widthLineAnim > 0.001) {
            double rangeStart = 0.5 - widthLineAnim / 2.0;
            double rangeEnd = 0.5 + widthLineAnim / 2.0;
            WireRenderingHelper.renderLines((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)rect.position(), (Vec3[])new Vec3[]{new PortalLocalXYNormalized(rangeStart, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, -padding1).getOffset(rect), new PortalLocalXYNormalized(rangeStart, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding1).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, -padding2).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding1).getOffset(rect), new PortalLocalXYNormalized(rangeStart, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding1).getOffset(rect), new PortalLocalXYNormalized(rangeEnd, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, -padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, -padding3).getOffset(rect), new PortalLocalXYNormalized(0.5, 1.0 + padding2).getOffset(rect), new PortalLocalXYNormalized(0.5, 1.0 + padding3).getOffset(rect)}, (double)1.0, (DQuaternion)DQuaternion.identity, (int)-16516018, (PoseStack)matrixStack);
        }
        if ((heightLineAnim = (Double)renderedHeightLineSegment.getCurrent()) != null && heightLineAnim > 0.001) {
            double rangeStart = 0.5 - heightLineAnim / 2.0;
            double rangeEnd = 0.5 + heightLineAnim / 2.0;
            WireRenderingHelper.renderLines((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)rect.position(), (Vec3[])new Vec3[]{new PortalLocalXYNormalized(-padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding1, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(-padding1, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding1, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeStart).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding1, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, rangeEnd).getOffset(rect), new PortalLocalXYNormalized(-padding2, 0.5).getOffset(rect), new PortalLocalXYNormalized(-padding3, 0.5).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding2, 0.5).getOffset(rect), new PortalLocalXYNormalized(1.0 + padding3, 0.5).getOffset(rect)}, (double)1.0, (DQuaternion)DQuaternion.identity, (int)-198653, (PoseStack)matrixStack);
        }
        matrixStack.m_85849_();
    }

    private static PortalCorner getClosestCorner(Portal portal, Vec3 hitPos) {
        return Arrays.stream(PortalCorner.values()).min(Comparator.comparingDouble(corner -> corner.getPos(portal).m_82554_(hitPos))).orElseThrow();
    }

    private static void updateDraggedPortalAnimation() {
        Vec3 currentCursor;
        if (draggingContext == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        RenderedPoint renderedCursor = (RenderedPoint)cursor.getCurrent();
        assert (renderedCursor != null);
        Vec3 vec3 = currentCursor = renderedCursor.pos() == null ? null : (Vec3)renderedCursor.pos().value();
        if (currentCursor == null) {
            return;
        }
        Portal selectedPortal = ClientPortalWandPortalDrag.getSelectedPortal();
        if (selectedPortal == null) {
            return;
        }
        UnilateralPortalState newState = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), currentCursor, ClientPortalWandPortalDrag.draggingContext.draggingInfo, false);
        if (PortalWandInteraction.validateDraggedPortalState(draggingContext.originalPortalState(), newState, (Player)player)) {
            PortalState newFullState = draggingContext.originalPortalState().withThisSideUpdated(newState, ClientPortalWandPortalDrag.draggingContext.draggingInfo.shouldLockScale());
            selectedPortal.setPortalState(newFullState);
            selectedPortal.rectifyClusterPortals(false);
        }
    }

    @Nullable
    private static PortalState getAnimationEndingState() {
        Vec3 cursorTarget;
        if (draggingContext == null) {
            return null;
        }
        Portal portal = WandUtil.getClientPortalByUUID((UUID)draggingContext.portalId());
        if (portal == null) {
            return null;
        }
        RenderedPoint renderedCursorTarget = (RenderedPoint)cursor.getTarget();
        assert (renderedCursorTarget != null);
        Vec3 vec3 = cursorTarget = renderedCursorTarget.pos() == null ? null : (Vec3)renderedCursorTarget.pos().value();
        if (cursorTarget == null) {
            return null;
        }
        UnilateralPortalState newThisSide = PortalWandInteraction.applyDrag(draggingContext.originalPortalState().getThisSideState(), cursorTarget, draggingContext.draggingInfo(), false);
        if (newThisSide == null) {
            return null;
        }
        return draggingContext.originalPortalState().withThisSideUpdated(newThisSide, draggingContext.draggingInfo().shouldLockScale());
    }

    static {
        lockWidth = false;
        lockHeight = false;
        cursor = new Animated(Animated.RENDERED_POINT_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)RenderedPoint.EMPTY);
        renderedRect = new Animated(UnilateralPortalState.ANIMATION_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), null);
        renderedPlane = new Animated(Animated.RENDERED_PLANE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)RenderedPlane.NONE);
        renderedLockedAnchor = new Animated(Animated.RENDERED_POINT_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.circle).mapProgress(arg_0), (Object)RenderedPoint.EMPTY);
        renderedWidthLineSegment = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
        renderedHeightLineSegment = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
        renderedWidthLock = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
        renderedHeightLock = new Animated(Animated.DOUBLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)0.0);
        isUndoing = false;
    }

    private record SelectionStatus(PortalLocalXYNormalized selectedAnchor, boolean selectsHorizontalEdge, boolean selectsVerticalEdge) {
    }

    private record DraggingContext(ResourceKey<Level> dimension, @NotNull UUID portalId, @Nullable Plane limitingPlane, @Nullable Sphere limitingSphere, PortalWandInteraction.DraggingInfo draggingInfo, @Nullable MutableComponent planeText, PortalState originalPortalState) {
    }
}

