/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.ImmPtlCustomOverlay;
import qouteall.imm_ptl.peripheral.wand.ProtoPortal;
import qouteall.imm_ptl.peripheral.wand.ProtoPortalSide;
import qouteall.imm_ptl.peripheral.wand.WandUtil;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPlane;

@Environment(value=EnvType.CLIENT)
public class ClientPortalWandPortalCreation {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Animated<Vec3> cursor = new Animated(Animated.VEC3_NULLABLE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.circle).mapProgress(arg_0), null);
    public static final Animated<RenderedPlane> renderedPlane = new Animated(Animated.RENDERED_PLANE_TYPE_INFO, () -> RenderStates.renderStartNanoTime, arg_0 -> ((TimingFunction)TimingFunction.sine).mapProgress(arg_0), (Object)RenderedPlane.NONE);
    @NotNull
    public static ProtoPortal protoPortal = new ProtoPortal();
    private static final int colorOfFirstSideLeftBottom = -327425;
    private static final int colorOfFirstSideRightBottom = -1691038;
    private static final int colorOfFirstSideLeftUp = -200864;
    private static final int colorOfSecondSideLeftBottom = -5308585;
    private static final int colorOfSecondSideRightBottom = -11010094;
    private static final int colorOfSecondSideLeftUp = -4344833;
    private static final int colorOfPlane = -5254150;
    private static final int colorOfCircle = -16515869;
    private static final int colorOfFirstPortalArea = -225277;
    private static final int colorOfFirstPortalArea2 = -33384;
    private static final int colorOfSecondPortalArea = -10423556;
    private static final int colorOfSecondPortalArea2 = -10423556;

    public static void reset() {
        protoPortal.reset();
        renderedPlane.clearTarget();
    }

    public static void onLeftClick() {
        ClientPortalWandPortalCreation.undo();
    }

    private static void undo() {
        protoPortal.undo();
    }

    public static void onRightClick() {
        Vec3 cursorTarget = (Vec3)cursor.getTarget();
        if (cursorTarget == null) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        protoPortal.tryPlaceCursor((ResourceKey<Level>)world.m_46472_(), cursorTarget);
        if (protoPortal.isComplete()) {
            ClientPortalWandPortalCreation.finish();
        }
    }

    public static void clearCursorPointing() {
        cursor.clearTarget();
    }

    public static void updateDisplay() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ResourceKey<Level> cursorLimitingDim = protoPortal.getCursorConstraintDim();
        if (cursorLimitingDim != null && player.m_9236_().m_46472_() != cursorLimitingDim) {
            cursor.clearTarget();
            renderedPlane.clearTarget();
            return;
        }
        WithDim<Plane> limitingPlane = protoPortal.getCursorConstraintPlane();
        WithDim<Circle> limitingCircle = protoPortal.getCursorConstraintCircle();
        Vec3 eyePos = player.m_20299_(RenderStates.getPartialTick());
        Vec3 viewVec = player.m_20252_(RenderStates.getPartialTick());
        Vec3 cursorPointing = null;
        int alignment = IPConfig.getConfig().portalWandCursorAlignment;
        if (limitingPlane != null) {
            cursorPointing = ((Plane)limitingPlane.value()).rayTrace(eyePos, viewVec);
            if (cursorPointing != null) {
                cursorPointing = WandUtil.alignOnBlocks(player.m_9236_(), cursorPointing, alignment);
                cursorPointing = ((Plane)limitingPlane.value()).getProjection(cursorPointing);
                if (limitingCircle != null) {
                    cursorPointing = ((Circle)limitingCircle.value()).projectToCircle(cursorPointing);
                }
            }
        } else {
            HitResult hitResult = player.m_19907_(64.0, RenderStates.getPartialTick(), false);
            if (hitResult.m_6662_() == HitResult.Type.BLOCK && hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                cursorPointing = WandUtil.alignOnBlocks(player.m_9236_(), blockHitResult.m_82450_(), alignment);
            }
        }
        if (limitingPlane != null && limitingCircle == null) {
            renderedPlane.setTarget((Object)new RenderedPlane(limitingPlane, 1.0), Helper.secondToNano((double)3.0));
        } else {
            renderedPlane.setTarget((Object)RenderedPlane.NONE, Helper.secondToNano((double)0.5));
        }
        if (cursorPointing != null) {
            MutableComponent promptMessage;
            ProtoPortal pendingState = protoPortal.copy();
            boolean canPlace = pendingState.tryPlaceCursor((ResourceKey<Level>)player.m_9236_().m_46472_(), cursorPointing);
            if (!canPlace || !pendingState.isValidPlacement()) {
                cursorPointing = null;
                pendingState = null;
            }
            if ((promptMessage = protoPortal.getPromptMessage(pendingState)) != null) {
                ImmPtlCustomOverlay.putText((Component)promptMessage);
            }
        }
        if (cursorPointing != null) {
            cursor.setTarget((Object)cursorPointing, Helper.secondToNano((double)0.5));
        } else {
            cursor.clearTarget();
        }
    }

    public static void finish() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        McRemoteProcedureCall.tellServerToInvoke((String)"qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.finishPortalCreation", (Object[])new Object[]{protoPortal});
        ClientPortalWandPortalCreation.reset();
    }

    public static void render(PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource, double camX, double camY, double camZ) {
        double scale;
        RenderedPlane currRenderedPlane;
        WithDim<Circle> renderedCircle;
        ProtoPortal pending;
        boolean canPlace;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ResourceKey currDim = player.m_9236_().m_46472_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        Vec3 cameraPos = new Vec3(camX, camY, camZ);
        WithDim<Circle> circle = protoPortal.getCursorConstraintCircle();
        Vec3 renderedCursor = (Vec3)cursor.getCurrent();
        if (circle != null && renderedCursor != null) {
            renderedCursor = ((Circle)circle.value()).projectToCircle(renderedCursor);
        }
        ProtoPortal renderedProtoPortal = protoPortal;
        if (renderedCursor != null && (canPlace = (pending = protoPortal.copy()).tryPlaceCursor((ResourceKey<Level>)currDim, renderedCursor))) {
            renderedProtoPortal = pending;
        }
        if (circle == null) {
            circle = protoPortal.getCursorConstraintCircle();
        }
        if (renderedProtoPortal.firstSide != null && currDim == renderedProtoPortal.firstSide.dimension) {
            WireRenderingHelper.renderSmallCubeFrame((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)renderedProtoPortal.firstSide.leftBottom, (int)-327425, (double)1.0, (PoseStack)matrixStack);
            if (renderedProtoPortal.firstSide.rightBottom != null) {
                WireRenderingHelper.renderSmallCubeFrame((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)renderedProtoPortal.firstSide.rightBottom, (int)-1691038, (double)1.0, (PoseStack)matrixStack);
            }
            if (renderedProtoPortal.firstSide.leftTop != null) {
                WireRenderingHelper.renderSmallCubeFrame((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)renderedProtoPortal.firstSide.leftTop, (int)-200864, (double)1.0, (PoseStack)matrixStack);
                WandUtil.renderPortalAreaGrid((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (ProtoPortalSide)renderedProtoPortal.firstSide, (int)-225277, (PoseStack)matrixStack);
            }
        }
        if (renderedProtoPortal.secondSide != null && currDim == renderedProtoPortal.secondSide.dimension) {
            WireRenderingHelper.renderSmallCubeFrame((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)renderedProtoPortal.secondSide.leftBottom, (int)-5308585, (double)1.0, (PoseStack)matrixStack);
            if (renderedProtoPortal.secondSide.rightBottom != null) {
                WireRenderingHelper.renderSmallCubeFrame((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)renderedProtoPortal.secondSide.rightBottom, (int)-11010094, (double)1.0, (PoseStack)matrixStack);
            }
            if (renderedProtoPortal.secondSide.leftTop != null) {
                WireRenderingHelper.renderSmallCubeFrame((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (Vec3)renderedProtoPortal.secondSide.leftTop, (int)-4344833, (double)1.0, (PoseStack)matrixStack);
                WandUtil.renderPortalAreaGrid((VertexConsumer)vertexConsumer, (Vec3)cameraPos, (ProtoPortalSide)renderedProtoPortal.secondSide, (int)-10423556, (PoseStack)matrixStack);
            }
        }
        VertexConsumer debugLineStripConsumer = bufferSource.m_6299_(RenderType.m_269399_((double)1.0));
        WithDim<Circle> withDim = renderedCircle = circle != null ? circle : renderedProtoPortal.getCursorConstraintCircle();
        if (renderedCircle != null && renderedCircle.dimension() == currDim) {
            WireRenderingHelper.renderCircle((VertexConsumer)debugLineStripConsumer, (Vec3)cameraPos, (Circle)((Circle)renderedCircle.value()), (int)-16515869, (PoseStack)matrixStack);
        }
        if ((currRenderedPlane = (RenderedPlane)renderedPlane.getCurrent()) != null && currRenderedPlane.plane() != null && currRenderedPlane.plane().dimension() == currDim && (scale = currRenderedPlane.scale()) > 0.01) {
            WireRenderingHelper.renderPlane((VertexConsumer)debugLineStripConsumer, (Vec3)cameraPos, (Plane)((Plane)currRenderedPlane.plane().value()), (double)scale, (int)-5254150, (PoseStack)matrixStack);
        }
    }
}

