/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.portal_generation;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.NetherPortalLikeForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalEntity;

public class IntrinsicNetherPortalForm
extends NetherPortalLikeForm {
    private static volatile boolean encounteredVanillaPortalBlock = false;

    public IntrinsicNetherPortalForm() {
        super(true);
    }

    public void generateNewFrame(ServerLevel fromWorld, BlockPortalShape fromShape, ServerLevel toWorld, BlockPortalShape toShape) {
        for (BlockPos blockPos : toShape.frameAreaWithCorner) {
            toWorld.m_46597_(blockPos, Blocks.f_50080_.m_49966_());
        }
    }

    public PortalGenInfo getNewPortalPlacement(ServerLevel toWorld, BlockPos toPos, ServerLevel fromWorld, BlockPortalShape fromShape, @Nullable Entity triggeringEntity) {
        if (encounteredVanillaPortalBlock) {
            encounteredVanillaPortalBlock = false;
            if (IPGlobal.enableWarning && triggeringEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)triggeringEntity;
                player.m_5661_((Component)Component.m_237115_((String)"imm_ptl.cannot_connect_to_vanilla_portal"), false);
            }
        }
        return super.getNewPortalPlacement(toWorld, toPos, fromWorld, fromShape, triggeringEntity);
    }

    public BreakablePortalEntity[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        info.generatePlaceholderBlocks();
        BreakablePortalEntity[] portals = info.generateBiWayBiFacedPortal(NetherPortalEntity.entityType);
        return portals;
    }

    public Predicate<BlockState> getOtherSideFramePredicate() {
        return blockState -> {
            if (O_O.isObsidian((BlockState)blockState)) {
                return true;
            }
            Block block = blockState.m_60734_();
            if (block == Blocks.f_50142_) {
                encounteredVanillaPortalBlock = true;
            }
            return false;
        };
    }

    public Predicate<BlockState> getThisSideFramePredicate() {
        return O_O::isObsidian;
    }

    public Predicate<BlockState> getAreaPredicate() {
        return BlockBehaviour.BlockStateBase::m_60795_;
    }

    public Codec<? extends PortalGenForm> getCodec() {
        throw new RuntimeException();
    }

    public PortalGenForm getReverse() {
        return this;
    }
}

