/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.peripheral.dim_stack.DimListWidget;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.q_misc_util.my_util.DQuaternion;

public class DimEntryWidget
extends ContainerObjectSelectionList.Entry<DimEntryWidget> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final ResourceKey<Level> dimension;
    public final DimListWidget parent;
    private final Consumer<DimEntryWidget> selectCallback;
    @Nullable
    private final ResourceLocation dimIconPath;
    private final Component dimensionName;
    @Nullable
    public final DimStackEntry entry;
    public int entryIndex;
    ArrowType arrowToPrevious = ArrowType.none;
    ArrowType arrowToNext = ArrowType.none;
    public static final int widgetHeight = 50;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();

    public List<? extends NarratableEntry> m_142437_() {
        return List.of();
    }

    public DimEntryWidget(ResourceKey<Level> dimension, DimListWidget parent, Consumer<DimEntryWidget> selectCallback, @Nullable DimStackEntry entry) {
        this.dimension = dimension;
        this.parent = parent;
        this.selectCallback = selectCallback;
        this.dimIconPath = CHelper.getDimensionIconPath(this.dimension);
        this.dimensionName = McHelper.getDimensionName(dimension);
        this.entry = entry;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean bl, float delta) {
        Minecraft client = Minecraft.m_91087_();
        guiGraphics.m_280488_(client.f_91062_, this.dimensionName.getString(), x + 50 + 3, y, -1);
        guiGraphics.m_280488_(client.f_91062_, this.dimension.m_135782_().toString(), x + 50 + 3, y + 10, -6710887);
        if (this.dimIconPath != null) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
            int iconLen = 46;
            if (this.entry != null && this.entry.flipped) {
                guiGraphics.m_280168_().m_272245_(DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, 0.0, 1.0), (double)180.0).toMcQuaternion(), (float)iconLen / 2.0f, (float)iconLen / 2.0f, 0.0f);
            }
            guiGraphics.m_280163_(this.dimIconPath, 0, 0, 0.0f, 0.0f, iconLen, iconLen, iconLen, iconLen);
            guiGraphics.m_280168_().m_85849_();
        }
        if (this.entry != null) {
            guiGraphics.m_280430_(client.f_91062_, this.getText1(), x + 50 + 3, y + 20, -6710887);
            guiGraphics.m_280430_(client.f_91062_, this.getText2(), x + 50 + 3, y + 30, -6710887);
            if (this.arrowToPrevious != ArrowType.none) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)(x + rowWidth - 13), (float)y, 0.0f);
                guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
                guiGraphics.m_280430_(client.f_91062_, (Component)Component.m_237113_((String)"\u2191"), 0, 0, this.arrowToPrevious == ArrowType.enabled ? -6710887 : -65536);
                guiGraphics.m_280168_().m_85849_();
            }
            if (this.arrowToNext != ArrowType.none) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)(x + rowWidth - 13), (float)(y + 50) - 14.5f, 0.0f);
                guiGraphics.m_280168_().m_85841_(1.5f, 1.5f, 1.5f);
                guiGraphics.m_280430_(client.f_91062_, (Component)Component.m_237113_((String)"\u2193"), 0, 0, this.arrowToNext == ArrowType.enabled ? -6710887 : -65536);
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }

    private Component getText1() {
        MutableComponent scaleText = this.entry.scale != 1.0 ? Component.m_237115_((String)"imm_ptl.scale").m_7220_((Component)Component.m_237113_((String)(":" + Double.toString(this.entry.scale)))) : Component.m_237113_((String)"");
        return scaleText;
    }

    private Component getText2() {
        MutableComponent horizontalRotationText = this.entry.horizontalRotation != 0.0 ? Component.m_237115_((String)"imm_ptl.horizontal_rotation").m_7220_((Component)Component.m_237113_((String)(":" + Double.toString(this.entry.horizontalRotation)))).m_7220_((Component)Component.m_237113_((String)" ")) : Component.m_237113_((String)"");
        return horizontalRotationText;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.selectCallback.accept(this);
        super.m_6375_(mouseX, mouseY, button);
        return true;
    }

    public static enum ArrowType {
        none,
        enabled,
        conflicting;

    }
}

