/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;

public class ChaosBiomeSource
extends BiomeSource {
    public static final String[] vanillaBiomes = new String[]{"minecraft:savanna_plateau", "minecraft:taiga", "minecraft:savanna", "minecraft:dripstone_caves", "minecraft:swamp", "minecraft:basalt_deltas", "minecraft:ice_spikes", "minecraft:crimson_forest", "minecraft:frozen_peaks", "minecraft:dark_forest", "minecraft:lush_caves", "minecraft:old_growth_spruce_taiga", "minecraft:deep_dark", "minecraft:frozen_river", "minecraft:lukewarm_ocean", "minecraft:mushroom_fields", "minecraft:warm_ocean", "minecraft:forest", "minecraft:end_midlands", "minecraft:windswept_forest", "minecraft:deep_ocean", "minecraft:sunflower_plains", "minecraft:stony_peaks", "minecraft:stony_shore", "minecraft:nether_wastes", "minecraft:deep_lukewarm_ocean", "minecraft:flower_forest", "minecraft:old_growth_birch_forest", "minecraft:desert", "minecraft:snowy_taiga", "minecraft:beach", "minecraft:grove", "minecraft:deep_frozen_ocean", "minecraft:river", "minecraft:old_growth_pine_taiga", "minecraft:the_void", "minecraft:deep_cold_ocean", "minecraft:windswept_gravelly_hills", "minecraft:snowy_plains", "minecraft:end_highlands", "minecraft:jagged_peaks", "minecraft:eroded_badlands", "minecraft:bamboo_jungle", "minecraft:end_barrens", "minecraft:plains", "minecraft:small_end_islands", "minecraft:meadow", "minecraft:the_end", "minecraft:snowy_beach", "minecraft:sparse_jungle", "minecraft:jungle", "minecraft:snowy_slopes", "minecraft:birch_forest", "minecraft:mangrove_swamp", "minecraft:ocean", "minecraft:cold_ocean", "minecraft:soul_sand_valley", "minecraft:warped_forest", "minecraft:badlands", "minecraft:windswept_hills", "minecraft:windswept_savanna", "minecraft:wooded_badlands"};
    public static final Codec<ChaosBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(checkerboardColumnBiomeSource -> checkerboardColumnBiomeSource.allowedBiomes)).apply((Applicative)instance, ChaosBiomeSource::new));
    private final HolderSet<Biome> allowedBiomes;

    public ChaosBiomeSource(HolderSet<Biome> holderSet) {
        this.allowedBiomes = holderSet;
    }

    @NotNull
    static ChaosBiomeSource createChaosBiomeSource(HolderGetter<Biome> biomeHolderGetter) {
        ArrayList holders = new ArrayList();
        for (String vanillaBiomeId : vanillaBiomes) {
            biomeHolderGetter.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(vanillaBiomeId))).ifPresent(holders::add);
        }
        ChaosBiomeSource chaosBiomeSource = new ChaosBiomeSource((HolderSet<Biome>)HolderSet.m_205800_(holders));
        return chaosBiomeSource;
    }

    private Holder<Biome> getRandomBiome(int x, int z) {
        int biomeNum = this.allowedBiomes.m_203632_();
        int index = Math.abs((int)LinearCongruentialGenerator.m_13972_((long)(x / 5), (long)(z / 5))) % biomeNum;
        return this.allowedBiomes.m_203662_(index);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    protected Stream<Holder<Biome>> m_274359_() {
        return this.allowedBiomes.m_203614_();
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return this.getRandomBiome(x, z);
    }
}

