/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import java.util.TreeMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;

@Environment(value=EnvType.CLIENT)
public class ImmPtlCustomOverlay {
    private static final TreeMap<String, Entry> ENTRIES = new TreeMap();
    @Nullable
    private static MultiLineLabel multiLineLabelCache;

    public static void putText(Component component, double durationSeconds, String key) {
        ENTRIES.put(key, new Entry(component, System.nanoTime() + Helper.secondToNano((double)durationSeconds)));
        multiLineLabelCache = null;
    }

    public static void putText(Component component, double durationSeconds) {
        ImmPtlCustomOverlay.putText(component, durationSeconds, "5_defaultKey");
    }

    public static void putText(Component component, String key) {
        ImmPtlCustomOverlay.putText(component, 0.2, key);
    }

    public static void putText(Component component) {
        ImmPtlCustomOverlay.putText(component, 0.2, "5_defaultKey");
    }

    public static boolean remove(String key) {
        return ENTRIES.remove(key) != null;
    }

    public static void render(GuiGraphics guiGraphics, float partialTick) {
        long currTime = System.nanoTime();
        boolean removes = ENTRIES.entrySet().removeIf(e -> ((Entry)e.getValue()).clearingTime < currTime);
        if (removes) {
            multiLineLabelCache = null;
        }
        if (ENTRIES.isEmpty()) {
            return;
        }
        if (multiLineLabelCache == null) {
            MutableComponent component = Component.m_237119_();
            boolean isBeginning = true;
            for (Entry entry : ENTRIES.values()) {
                if (isBeginning) {
                    isBeginning = false;
                } else {
                    component.m_130946_("\n");
                }
                component.m_7220_(entry.component());
            }
            multiLineLabelCache = MultiLineLabel.m_94341_((Font)Minecraft.m_91087_().f_91062_, (FormattedText)component, (int)(Minecraft.m_91087_().m_91268_().m_85445_() - 20));
            assert (multiLineLabelCache != null);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        guiGraphics.m_280168_().m_85836_();
        int guiScaledWidth = minecraft.m_91268_().m_85445_();
        int guiScaledHeight = minecraft.m_91268_().m_85446_();
        Font font = minecraft.f_91065_.m_93082_();
        minecraft.m_91307_().m_6180_("imm_ptl_custom_overlay");
        multiLineLabelCache.m_6276_(guiGraphics, guiScaledWidth / 2, (int)((double)guiScaledHeight * 0.75));
        guiGraphics.m_280168_().m_85849_();
        minecraft.m_91307_().m_7238_();
    }

    public record Entry(Component component, long clearingTime) {
    }
}

