/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.network.IPNetworkingClient;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;

@Environment(value=EnvType.CLIENT)
public class IPOuterClientMisc {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static OuterConfig outerConfig = new OuterConfig();

    private static OuterConfig readFromFile() {
        File storageFile = IPOuterClientMisc.getStorageFile();
        if (storageFile.exists()) {
            OuterConfig result = null;
            try (FileReader fileReader = new FileReader(storageFile);){
                result = (OuterConfig)IPGlobal.gson.fromJson((Reader)fileReader, OuterConfig.class);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return new OuterConfig();
            }
            if (result == null) {
                return new OuterConfig();
            }
            return result;
        }
        return new OuterConfig();
    }

    private static File getStorageFile() {
        return new File(Minecraft.m_91087_().f_91069_, "imm_ptl_state.json");
    }

    private static void writeToFile(OuterConfig outerConfig) {
        try (FileWriter fileWriter = new FileWriter(IPOuterClientMisc.getStorageFile());){
            IPGlobal.gson.toJson((Object)outerConfig, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initClient() {
        outerConfig = IPOuterClientMisc.readFromFile();
        DimStackInfo dimStackPreset = IPOuterClientMisc.outerConfig.dimensionStackDefault;
        if (dimStackPreset != null) {
            try {
                IPConfig config = IPConfig.getConfig();
                config.dimStackPreset = (JsonObject)IPGlobal.gson.toJsonTree((Object)dimStackPreset);
                config.saveConfigFile();
                IPOuterClientMisc.outerConfig.dimensionStackDefault = null;
                IPOuterClientMisc.writeToFile(outerConfig);
                LOGGER.info("Successfully upgraded dimension stack preset");
            }
            catch (Exception e) {
                LOGGER.info("Failed to upgrade dimension stack preset", (Throwable)e);
            }
        }
        IPNetworkingClient.clientPortalSpawnSignal.connect(p -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (!IPOuterClientMisc.outerConfig.wikiInformed && player != null && player.m_7500_()) {
                IPOuterClientMisc.outerConfig.wikiInformed = true;
                IPOuterClientMisc.writeToFile(outerConfig);
                IPOuterClientMisc.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization", Component.m_237115_((String)"imm_ptl.inform_wiki"));
            }
        });
    }

    public static void onClientPlacePortalHelper() {
        if (!IPOuterClientMisc.outerConfig.portalHelperInformed) {
            IPOuterClientMisc.outerConfig.portalHelperInformed = true;
            IPOuterClientMisc.writeToFile(outerConfig);
            IPOuterClientMisc.informWithURL("https://qouteall.fun/immptl/wiki/Portal-Customization#portal-helper-block", Component.m_237115_((String)"imm_ptl.inform_portal_helper"));
        }
    }

    private static void informWithURL(String link, MutableComponent text) {
        CHelper.printChat((Component)text.m_7220_((Component)McHelper.getLinkText((String)link)));
    }

    public static class OuterConfig {
        public boolean wikiInformed = false;
        public boolean portalHelperInformed = false;
        public boolean lagInformed = false;
        @Nullable
        public DimStackInfo dimensionStackDefault = null;
    }
}

