/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.q_misc_util.MiscHelper;

public class CommandStickItem
extends Item {
    public static final LinkedHashMap<String, Data> BUILT_IN_COMMAND_STICK_TYPES = new LinkedHashMap();
    public static final CommandStickItem instance = new CommandStickItem(new Item.Properties());

    public static void registerBuiltInCommandStick(Data data) {
        BUILT_IN_COMMAND_STICK_TYPES.put(data.command, data);
    }

    public CommandStickItem(Item.Properties settings) {
        super(settings);
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        this.doUse(player, player.m_21120_(hand));
        return super.m_7203_(world, player, hand);
    }

    private void doUse(Player player, ItemStack stack) {
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (CommandStickItem.canUseCommand(player)) {
            Data data = Data.deserialize(stack.m_41784_());
            CommandSourceStack commandSource = player.m_20203_().m_81325_(2);
            Commands commandManager = MiscHelper.getServer().m_129892_();
            String command = data.command;
            if (command.startsWith("/")) {
                command = command.substring(1);
            }
            commandManager.m_230957_(commandSource, command);
        } else {
            CommandStickItem.sendMessage(player, (Component)Component.m_237113_((String)"No Permission"));
        }
    }

    private static boolean canUseCommand(Player player) {
        if (IPGlobal.easeCommandStickPermission) {
            return true;
        }
        return player.m_20310_(2) || player.m_7500_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.m_7373_(stack, world, tooltip, context);
        Data data = Data.deserialize(stack.m_41784_());
        Iterable splitCommand = Splitter.fixedLength((int)40).split((CharSequence)data.command);
        for (String commandPortion : splitCommand) {
            tooltip.add((Component)Component.m_237113_((String)commandPortion).m_130940_(ChatFormatting.GOLD));
        }
        for (String descriptionTranslationKey : data.descriptionTranslationKeys) {
            tooltip.add((Component)Component.m_237115_((String)descriptionTranslationKey).m_130940_(ChatFormatting.AQUA));
        }
        tooltip.add((Component)Component.m_237115_((String)"imm_ptl.command_stick").m_130940_(ChatFormatting.GRAY));
    }

    public String m_5671_(ItemStack stack) {
        Data data = Data.deserialize(stack.m_41784_());
        return data.nameTranslationKey;
    }

    public static void sendMessage(Player player, Component message) {
        ((ServerPlayer)player).m_213846_(message);
    }

    public static void init() {
        PortalCommand.createCommandStickCommandSignal.connect((player, command) -> {
            ItemStack itemStack = new ItemStack((ItemLike)instance, 1);
            Data data = new Data((String)command, (String)command, (List<String>)new ArrayList<String>());
            data.serialize(itemStack.m_41784_());
            player.m_150109_().m_36054_(itemStack);
            player.f_36095_.m_38946_();
        });
        ItemGroupEvents.modifyEntriesEvent((ResourceKey)CreativeModeTabs.f_256869_).register(groupEntries -> {
            for (Data data : BUILT_IN_COMMAND_STICK_TYPES.values()) {
                ItemStack stack = new ItemStack((ItemLike)instance);
                data.serialize(stack.m_41784_());
                groupEntries.m_246342_(stack);
            }
        });
    }

    public static void registerCommandStickTypes() {
        CommandStickItem.registerPortalSubCommandStick("delete_portal");
        CommandStickItem.registerPortalSubCommandStick("remove_connected_portals");
        CommandStickItem.registerPortalSubCommandStick("eradicate_portal_cluster");
        CommandStickItem.registerPortalSubCommandStick("complete_bi_way_bi_faced_portal");
        CommandStickItem.registerPortalSubCommandStick("complete_bi_way_portal");
        CommandStickItem.registerPortalSubCommandStick("move_portal_front", "move_portal 0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_back", "move_portal -0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_destination_front", "move_portal_destination 0.5");
        CommandStickItem.registerPortalSubCommandStick("move_portal_destination_back", "move_portal_destination -0.5");
        CommandStickItem.registerPortalSubCommandStick("rotate_x", "rotate_portal_rotation_along x 15");
        CommandStickItem.registerPortalSubCommandStick("rotate_y", "rotate_portal_rotation_along y 15");
        CommandStickItem.registerPortalSubCommandStick("rotate_z", "rotate_portal_rotation_along z 15");
        CommandStickItem.registerPortalSubCommandStick("make_unbreakable", "nbt {unbreakable:true}");
        CommandStickItem.registerPortalSubCommandStick("make_fuse_view", "nbt {fuseView:true}");
        CommandStickItem.registerPortalSubCommandStick("enable_pos_adjust", "nbt {adjustPositionAfterTeleport:true}");
        CommandStickItem.registerPortalSubCommandStick("disable_rendering_yourself", "nbt {doRenderPlayer:false}");
        CommandStickItem.registerPortalSubCommandStick("enable_isometric", "debug isometric_enable 50");
        CommandStickItem.registerPortalSubCommandStick("disable_isometric", "debug isometric_disable");
        CommandStickItem.registerPortalSubCommandStick("create_5_connected_rooms", "create_connected_rooms roomSize 6 4 6 roomNumber 5");
        CommandStickItem.registerPortalSubCommandStick("accelerate50", "debug accelerate 50");
        CommandStickItem.registerPortalSubCommandStick("accelerate200", "debug accelerate 200");
        CommandStickItem.registerPortalSubCommandStick("reverse_accelerate50", "debug accelerate -50");
        CommandStickItem.registerPortalSubCommandStick("enable_gravity_change", "nbt {teleportChangesGravity:true}");
        CommandStickItem.registerPortalSubCommandStick("make_invisible", "nbt {isVisible:false}");
        CommandStickItem.registerPortalSubCommandStick("make_visible", "nbt {isVisible:true}");
        CommandStickItem.registerPortalSubCommandStick("disable_default_animation", "nbt {defaultAnimation:{durationTicks:0}}");
        CommandStickItem.registerPortalSubCommandStick("pause_animation", "animation pause");
        CommandStickItem.registerPortalSubCommandStick("resume_animation", "animation resume");
        CommandStickItem.registerPortalSubCommandStick("rotate_around_y", "animation rotate_infinitely @s 0 1 0 1.0");
        CommandStickItem.registerPortalSubCommandStick("rotate_randomly", "animation rotate_infinitely_random");
        CommandStickItem.registerBuiltInCommandStick(new Data("execute positioned 0.0 0.0 0.0 run portal animation rotate_infinitely @p ^0.0 ^0.0 ^1.0 1.7", "imm_ptl.command.rotate_around_view", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_dest.rotate_around_view"})));
        CommandStickItem.registerPortalSubCommandStick("expand_from_center", "animation expand_from_center 20");
        CommandStickItem.registerPortalSubCommandStick("clear_animation", "animation clear");
        CommandStickItem.registerPortalSubCommandStick("sculpt", "shape sculpt");
        CommandStickItem.registerPortalSubCommandStick("reset_shape", "shape reset");
        CommandStickItem.registerBuiltInCommandStick(new Data("/scale set pehkui:base 1", "imm_ptl.command.reset_scale", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.reset_scale"})));
        CommandStickItem.registerBuiltInCommandStick(new Data("/scale set pehkui:reach 5", "imm_ptl.command.long_reach", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.long_reach"})));
        CommandStickItem.registerBuiltInCommandStick(new Data("/effect give @s minecraft:night_vision 9999 1 true", "imm_ptl.command.night_vision", List.of()));
        CommandStickItem.registerPortalSubCommandStick("goback");
        CommandStickItem.registerPortalSubCommandStick("show_wiki", "wiki");
    }

    private static Data registerPortalSubCommandStick(String name) {
        return CommandStickItem.registerPortalSubCommandStick(name, name);
    }

    private static Data registerPortalSubCommandStick(String name, String subCommand) {
        Data data = new Data("/portal " + subCommand, "imm_ptl.command." + name, Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc." + name}));
        CommandStickItem.registerBuiltInCommandStick(data);
        return data;
    }

    public record Data(String command, String nameTranslationKey, List<String> descriptionTranslationKeys) {
        public void serialize(CompoundTag tag) {
            tag.m_128359_("command", this.command);
            tag.m_128359_("nameTranslationKey", this.nameTranslationKey);
            ListTag listTag = new ListTag();
            for (String descriptionTK : this.descriptionTranslationKeys) {
                listTag.add((Object)StringTag.m_129297_((String)descriptionTK));
            }
            tag.m_128365_("descriptionTranslationKeys", (Tag)listTag);
        }

        public CompoundTag toTag() {
            CompoundTag tag = new CompoundTag();
            this.serialize(tag);
            return tag;
        }

        public static Data deserialize(CompoundTag tag) {
            return new Data(tag.m_128461_("command"), tag.m_128461_("nameTranslationKey"), tag.m_128437_("descriptionTranslationKeys", (int)StringTag.m_129297_((String)"").m_7060_()).stream().map(tag1 -> ((StringTag)tag1).m_7916_()).collect(Collectors.toList()));
        }
    }
}

