/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    public static final Supplier<Codec<AddItemModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.item), (App)Codec.INT.fieldOf("count").forGetter(m -> m.count), (App)Codec.INT.fieldOf("chance").forGetter(m -> m.chance))).apply((Applicative)inst, AddItemModifier::new)));
    private final Item item;
    private final int count;
    private final int chance;

    protected AddItemModifier(LootItemCondition[] conditionsIn, Item item, int count, int chance) {
        super(conditionsIn);
        this.item = item;
        this.count = count;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (context.m_230907_().m_216339_(1, 101) <= this.chance) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item, this.count));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

