/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.event;

import com.teamdurt.netherdungeons.init.NDEffects;
import com.teamdurt.netherdungeons.init.NDParticles;
import com.teamdurt.netherdungeons.init.NDSounds;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="netherdungeons")
public class NDEventsHandler {
    @SubscribeEvent
    public static void applyVampirismEffect(LivingDeathEvent event) {
        Entity entity;
        if (event.getEntity().m_9236_().m_5776_() || event.getSource().m_7639_() == null || !((entity = event.getSource().m_7639_()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity killer = (LivingEntity)entity;
        if (killer.m_21023_((MobEffect)NDEffects.VAMPIRISM.get())) {
            int effectAmplifier = Objects.requireNonNull(killer.m_21124_((MobEffect)NDEffects.VAMPIRISM.get())).m_19564_();
            int healPercentage = (effectAmplifier + 1) * 5 + 5;
            float healthToHeal = event.getEntity().m_21233_() * (float)healPercentage / 100.0f;
            killer.m_5634_(healthToHeal);
            killer.m_9236_().m_5594_((Player)null, killer.m_20183_(), (SoundEvent)NDSounds.VAMPIRISM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void applyGoldRushEffect(AttackEntityEvent event) {
        Entity entity;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.getEntity().m_21023_((MobEffect)NDEffects.GOLD_RUSH.get()) && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (target instanceof ArmorStand) {
                return;
            }
            if (target.m_9236_().f_46441_.m_188503_(4) > 0) {
                return;
            }
            int count = target.m_9236_().f_46441_.m_216339_(1, 3);
            ItemStack itemStack = new ItemStack((ItemLike)Items.f_42587_, count);
            target.m_19983_(itemStack);
            Level level = target.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                double particleY = target.m_20186_() + (double)target.m_20192_() / 1.5;
                level2.m_8767_((ParticleOptions)((SimpleParticleType)NDParticles.GOLD_RUSH_BUBBLE.get()), target.m_20185_(), particleY, target.m_20189_(), level2.f_46441_.m_216339_(1, 4), 0.3, 0.5, 0.3, 0.04);
                level2.m_8767_((ParticleOptions)((SimpleParticleType)NDParticles.GOLD_RUSH_LINE.get()), target.m_20185_(), particleY, target.m_20189_(), level2.f_46441_.m_216339_(1, 4), 0.3, 0.5, 0.3, 0.04);
                level2.m_8767_((ParticleOptions)((SimpleParticleType)NDParticles.GOLD_RUSH_SPARK.get()), target.m_20185_(), particleY, target.m_20189_(), level2.f_46441_.m_216339_(1, 4), 0.3, 0.5, 0.3, 0.04);
            }
        }
    }

    @SubscribeEvent
    public static void applyDurabilityEffect(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)NDEffects.DURABILITY.get()) && entity.m_9236_().f_46441_.m_216339_(0, 4) == 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void applyVulnerabilityEffect(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof AbstractPiglin) && entity.m_21023_((MobEffect)NDEffects.VULNERABILITY.get())) {
            event.setAmount(event.getAmount() * 1.4f);
        }
    }
}

