/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.move_control;

import com.teamdurt.netherdungeons.entity.custom.Truncus;
import com.teamdurt.netherdungeons.init.NDBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;

public class TruncusMoveControl
extends MoveControl {
    private static final int MAX_LANDING_RADIUS = 4;
    private final Truncus mob;
    private final int maxTurn;
    private WalkTarget landTarget;
    private State state = State.WALKING;
    private boolean isLocked = false;

    public TruncusMoveControl(Truncus pMob, int pMaxTurn) {
        super((Mob)pMob);
        this.mob = pMob;
        this.maxTurn = pMaxTurn;
    }

    public void m_8126_() {
        if (this.mob.m_9236_().m_5776_()) {
            return;
        }
        if (this.isLocked()) {
            return;
        }
        switch (this.state) {
            case WALKING: {
                if (this.mob.isFlying()) {
                    this.state = State.FLYING;
                    break;
                }
                if (this.mob.f_19789_ >= 2.0f) {
                    this.landTarget = null;
                    this.state = State.LANDING;
                    break;
                }
                this.mob.setAnimationGroup(Truncus.AnimationGroup.WALKING);
                this.mob.setFlyNavigating(false);
                this.mob.m_20242_(false);
                super.m_8126_();
                break;
            }
            case FLYING: {
                if (!this.mob.isFlying()) {
                    this.landTarget = null;
                    this.state = State.LANDING;
                    break;
                }
                this.mob.setFlyNavigating(true);
                this.mob.m_20242_(true);
                this.flyTick();
                break;
            }
            case LANDING: {
                if (this.mob.isFlying()) {
                    this.state = State.FLYING;
                    break;
                }
                if (this.landTarget == null) {
                    this.setLandTarget();
                }
                this.mob.setFlyNavigating(true);
                this.flyTick();
                if (this.landTarget == null) break;
                this.mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)this.landTarget);
                if (!(this.mob.m_20238_(this.landTarget.m_26420_().m_7024_()) < 1.0)) break;
                this.mob.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                this.mob.setAnimationGroup(Truncus.AnimationGroup.STOP_LANDING);
                this.mob.m_183634_();
                this.state = State.WALKING;
                this.landTarget = null;
            }
        }
    }

    private void flyTick() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.mob.setAnimationGroup(Truncus.AnimationGroup.FLYING_MOVE_TO);
            this.f_24981_ = MoveControl.Operation.WAIT;
            double d0 = this.f_24975_ - this.mob.m_20185_();
            double d1 = this.f_24976_ - this.mob.m_20186_();
            double d2 = this.f_24977_ - this.mob.m_20189_();
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            if (d3 < 2.500000277905201E-7) {
                this.mob.m_21567_(0.0f);
                this.mob.m_21564_(0.0f);
                return;
            }
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            this.mob.m_146922_(this.m_24991_(this.mob.m_146908_(), f, 90.0f));
            float f1 = this.mob.m_20096_() ? (float)(this.f_24978_ * this.mob.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.mob.m_21133_(Attributes.f_22280_));
            this.mob.m_7910_(f1);
            double d4 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d1) > (double)1.0E-5f || Math.abs(d4) > (double)1.0E-5f) {
                float f2 = (float)(-(Mth.m_14136_((double)d1, (double)d4) * 57.2957763671875));
                this.mob.m_146926_(this.m_24991_(this.mob.m_146909_(), f2, this.maxTurn));
                this.mob.m_21567_(d1 > 0.0 ? f1 : -f1);
            }
        } else {
            this.mob.setAnimationGroup(Truncus.AnimationGroup.FLYING_WAIT);
            this.mob.m_21567_(0.0f);
            this.mob.m_21564_(0.0f);
        }
    }

    private void setLandTarget() {
        BlockPos closestPos = null;
        BlockPos closestPreferPos = null;
        int x = (int)this.mob.m_20185_() - 4;
        while ((double)x < this.mob.m_20185_() + 4.0) {
            int z = (int)this.mob.m_20189_() - 4;
            while ((double)z < this.mob.m_20189_() + 4.0) {
                int y = this.getSurfaceHeight(x, (int)this.mob.m_20186_(), z);
                BlockPos pos = new BlockPos(x, y, z);
                if (y != this.mob.m_9236_().m_141937_() - 1 && this.canReach(pos)) {
                    if (closestPos == null || this.mob.m_20275_(x, y, z) < this.mob.m_20238_(closestPos.m_252807_())) {
                        closestPos = pos;
                    }
                    if (this.mob.m_9236_().m_8055_(pos.m_7495_()).m_204336_(NDBlockTags.TRUNCUS_PREFERS_LAND) && (closestPreferPos == null || this.mob.m_20275_(x, y, z) < this.mob.m_20238_(closestPreferPos.m_252807_()))) {
                        closestPreferPos = pos;
                    }
                }
                ++z;
            }
            ++x;
        }
        if (closestPreferPos != null) {
            this.landTarget = new WalkTarget(closestPreferPos, 1.0f, 1);
            this.mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)this.landTarget);
        } else if (closestPos != null) {
            this.landTarget = new WalkTarget(closestPos, 1.0f, 1);
            this.mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)this.landTarget);
        } else {
            this.mob.setFlying(true);
            WalkTarget tempTarget = new WalkTarget(this.mob.m_20182_().m_231075_(this.mob.m_6350_(), 1.0), 1.0f, 1);
            this.mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)tempTarget);
        }
    }

    public boolean canReach(BlockPos blockPos) {
        Path path = this.mob.m_21573_().m_7864_(blockPos, 1);
        return path != null && path.m_77403_();
    }

    public int getSurfaceHeight(int x, int y, int z) {
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState blockState = this.mob.m_9236_().m_8055_((BlockPos)blockPos);
        while ((blockState.m_60795_() || !this.mob.m_9236_().m_8055_(blockPos.m_7494_()).m_60795_()) && blockPos.m_123342_() > this.mob.m_9236_().m_141937_() - 1) {
            blockPos.m_122184_(0, -1, 0);
            blockState = this.mob.m_9236_().m_8055_((BlockPos)blockPos);
        }
        if (!blockState.m_60804_((BlockGetter)this.mob.m_9236_(), (BlockPos)blockPos)) {
            return -1;
        }
        if (blockState.m_60795_()) {
            return -1;
        }
        return blockPos.m_123342_() + 1;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public static enum State {
        WALKING,
        FLYING,
        LANDING;

    }
}

