/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.model;

import com.teamdurt.netherdungeons.entity.animation.TruncusAnimation;
import com.teamdurt.netherdungeons.entity.custom.Truncus;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class TruncusModel<T extends Truncus>
extends HierarchicalModel<T>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("netherdungeons", "truncus"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart head;

    public TruncusModel(ModelPart pRoot) {
        this.root = pRoot.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.right_leg = this.root.m_171324_("right_leg");
        this.left_leg = this.root.m_171324_("left_leg");
        this.left_arm = this.body.m_171324_("left_arm");
        this.right_arm = this.body.m_171324_("right_arm");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 21).m_171488_(-5.0f, -7.0f, -3.0f, 10.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition proboscis = head.m_171599_("proboscis", CubeListBuilder.m_171558_().m_171514_(32, 21).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-3.0f));
        PartDefinition luminophore = proboscis.m_171599_("luminophore", CubeListBuilder.m_171558_().m_171514_(16, 34).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)-6.0f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(7, 40).m_171488_(0.0f, -2.0f, -1.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-3.0f, (float)0.0f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(15, 39).m_171488_(-3.0f, -2.0f, -1.0f, 3.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-3.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(0.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)-6.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-3.0f, (float)-6.0f, (float)0.0f));
        PartDefinition inflated_belly = body.m_171599_("inflated_belly", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -11.0f, -5.0f, 12.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition small_belly = body.m_171599_("small_belly", CubeListBuilder.m_171558_().m_171514_(28, 30).m_171488_(-3.0f, -7.0f, -2.0f, 6.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)2.0f));
        PartDefinition right_leg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(8, 34).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-4.0f, (float)0.0f));
        PartDefinition left_leg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(26, 21).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-4.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(T truncus, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.animateHeadLookTarget(netHeadYaw, headPitch);
        this.m_267799_(((Truncus)((Object)truncus)).isFlyNavigating() ? TruncusAnimation.TRUNCUS_FLIGHT : TruncusAnimation.TRUNCUS_WALKING, limbSwing, limbSwingAmount, 8.0f, 100.0f);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingHookedAnimationState, TruncusAnimation.TRUNCUS_SUCKING_HOOKED, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingHookedInAnimationState, TruncusAnimation.TRUNCUS_SUCKING_HOOKED_IN, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingHookedOutAnimationState, TruncusAnimation.TRUNCUS_SUCKING_HOOKED_OUT, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingStuckAnimationState, TruncusAnimation.TRUNCUS_SUCKING_STUCK, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingStuckInAnimationState, TruncusAnimation.TRUNCUS_SUCKING_STUCK_IN, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingStuckOutAnimationState, TruncusAnimation.TRUNCUS_SUCKING_STUCK_OUT, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingStandingAnimationState, TruncusAnimation.TRUNCUS_SUCKING_STANDING, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingStandingInAnimationState, TruncusAnimation.TRUNCUS_SUCKING_STANDING_IN, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSuckingStandingOutAnimationState, TruncusAnimation.TRUNCUS_SUCKING_STANDING_OUT, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).flightOutAnimationState, TruncusAnimation.TRUNCUS_FLIGHT_OUT, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).flightInAnimationState, TruncusAnimation.TRUNCUS_FLIGHT_IN, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).soaringAnimationState, TruncusAnimation.TRUNCUS_SOARING, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).inflatingAnimationState, TruncusAnimation.TRUNCUS_INFLATING, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).deflatingAnimationState, TruncusAnimation.TRUNCUS_DEFLATION, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).idleAnimationState, TruncusAnimation.TRUNCUS_IDLE, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSleepingInAnimationState, TruncusAnimation.TRUNCUS_SLEEPING_IN, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSleepingAnimationState, TruncusAnimation.TRUNCUS_SLEEPING, ageInTicks);
        this.m_233381_(((Truncus)((Object)truncus)).truncusSleepingOutAnimationState, TruncusAnimation.TRUNCUS_SLEEPING_OUT, ageInTicks);
    }

    public void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

