/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.teamdurt.netherdungeons.entity.animation.PiglinThrowerAnimation;
import com.teamdurt.netherdungeons.entity.custom.PiglinThrower;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class PiglinThrowerModel<T extends PiglinThrower>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("netherdungeons", "piglin_thrower"), "main");
    public final ModelPart root;
    public final ModelPart body;
    public final ModelPart leftLeg;
    public final ModelPart rightLeg;
    public final ModelPart leftArm;
    public final ModelPart rightArm;
    public final ModelPart head;

    public PiglinThrowerModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.leftLeg = this.root.m_171324_("left_leg");
        this.rightLeg = this.root.m_171324_("right_leg");
        this.leftArm = this.body.m_171324_("left_arm");
        this.rightArm = this.body.m_171324_("right_arm");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_sleeve = left_arm.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_sleeve = right_arm.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(28, 3).m_171488_(-3.0f, -4.0f, -5.0f, 6.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(20, 42).m_171488_(1.0f, -1.0f, -5.01f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(2, 4).m_171488_(3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(2, 4).m_171488_(-4.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(38, 6).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition backpack = body.m_171599_("backpack", CubeListBuilder.m_171558_().m_171514_(20, 32).m_171488_(-4.0f, -1.0f, 0.0f, 8.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 40).m_171488_(-3.0f, 5.0f, 1.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 32).m_171488_(-4.0f, -1.0f, 7.0f, 8.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)2.0f));
        PartDefinition backpack_r1 = backpack.m_171599_("backpack_r1", CubeListBuilder.m_171558_().m_171514_(50, 8).m_171488_(-3.0f, -7.0f, 7.0f, 6.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(50, 0).m_171488_(-3.0f, -7.0f, 0.0f, 6.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)6.0f, (float)4.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        PartDefinition shroom = backpack.m_171599_("shroom", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)5.75f, (float)4.0f));
        PartDefinition bone = shroom.m_171599_("bone", CubeListBuilder.m_171558_().m_171514_(12, 61).m_171488_(0.0f, 2.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(-1.0f, -1.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-4.0f, (float)1.0f));
        PartDefinition bone2 = shroom.m_171599_("bone2", CubeListBuilder.m_171558_().m_171514_(12, 61).m_171488_(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(-2.0f, -3.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-2.0f, (float)-1.5f));
        PartDefinition bone3 = shroom.m_171599_("bone3", CubeListBuilder.m_171558_().m_171514_(12, 61).m_171488_(-0.5f, 1.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(-1.5f, -2.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-6.0f, (float)0.75f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition bone4 = shroom.m_171599_("bone4", CubeListBuilder.m_171558_().m_171514_(12, 61).m_171488_(-0.5f, 1.0f, 0.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 58).m_171488_(-1.5f, -2.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-5.75f, (float)-1.5f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition left_leg = root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.animateMeleeAttack();
        this.animateHeadLookTarget(netHeadYaw, headPitch);
        this.m_267799_(PiglinThrowerAnimation.PIGLIN_THROWER_WALKING, limbSwing, limbSwingAmount, 3.0f, 2.5f);
        this.m_233381_(((PiglinThrower)((Object)entity)).dancingAnimationState, PiglinThrowerAnimation.PIGLIN_THROWER_DANCE, ageInTicks);
        this.m_233381_(((PiglinThrower)((Object)entity)).rangeAttackFrontAnimationState, PiglinThrowerAnimation.PIGLIN_THROWER_FRONT_RANGE_ATTACK, ageInTicks);
        this.m_233381_(((PiglinThrower)((Object)entity)).rangeAttackBackAnimationState, PiglinThrowerAnimation.PIGLIN_THROWER_BACK_RANGE_ATTACK, ageInTicks);
        this.m_233381_(((PiglinThrower)((Object)entity)).meleeAttackAnimationState, PiglinThrowerAnimation.PIGLIN_THROWER_MELEE_ATTACK, ageInTicks);
        this.m_233381_(((PiglinThrower)((Object)entity)).idleAnimationState, PiglinThrowerAnimation.PIGLIN_THROWER_IDLE, ageInTicks);
        this.m_233381_(((PiglinThrower)((Object)entity)).basicAnimationState, PiglinThrowerAnimation.PIGLIN_THROWER_BASIC, ageInTicks);
    }

    public void setAllVisible(boolean allVisible) {
        this.head.f_104207_ = allVisible;
        this.root.f_104207_ = allVisible;
        this.body.f_104207_ = allVisible;
        this.rightArm.f_104207_ = allVisible;
        this.leftArm.f_104207_ = allVisible;
        this.rightLeg.f_104207_ = allVisible;
        this.leftLeg.f_104207_ = allVisible;
    }

    public void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        boolean flag = arm == HumanoidArm.RIGHT;
        ModelPart model_part = flag ? this.rightArm : this.leftArm;
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        model_part.m_104299_(poseStack);
    }

    public void animateMeleeAttack() {
        if (this.f_102608_ > 0.0f) {
            float f = this.f_102608_;
            this.body.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            this.body.f_104204_ *= -1.0f;
            this.rightArm.f_104202_ = Mth.m_14031_((float)this.body.f_104204_) * 5.0f;
            this.rightArm.f_104200_ = -Mth.m_14089_((float)this.body.f_104204_) * 5.0f;
            this.leftArm.f_104202_ = -Mth.m_14031_((float)this.body.f_104204_) * 5.0f;
            this.leftArm.f_104200_ = Mth.m_14089_((float)this.body.f_104204_) * 5.0f;
            this.rightArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104204_ += this.body.f_104204_;
            this.leftArm.f_104203_ += this.body.f_104204_;
            f = 1.0f - this.f_102608_;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.m_14031_((float)(f * (float)Math.PI));
            float f2 = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -(this.head.f_104203_ - 0.7f) * 0.75f;
            this.leftArm.f_104203_ -= f1 * 1.2f + f2;
            this.leftArm.f_104204_ += this.body.f_104204_ * 2.0f;
            this.leftArm.f_104205_ += Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI)) * -0.4f;
        }
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

