/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.model;

import com.teamdurt.netherdungeons.entity.animation.HoglinBruteAnimation;
import com.teamdurt.netherdungeons.entity.custom.HoglinBrute;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class HoglinBruteModel
extends HierarchicalModel<HoglinBrute>
implements HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("netherdungeons", "hoglin_brute"), "main");
    public final ModelPart root;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart leftEar;
    public final ModelPart rightEar;

    public HoglinBruteModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.body = this.root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.leftEar = this.head.m_171324_("left_ear");
        this.rightEar = this.head.m_171324_("right_ear");
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(@NotNull HoglinBrute hoglinBrute, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.animateHeadLookTarget(hoglinBrute, pLimbSwing, pLimbSwingAmount, pNetHeadYaw, pHeadPitch);
        this.m_267799_(HoglinBruteAnimation.HOGLIN_BRUTE_WALKING, pLimbSwing, pLimbSwingAmount, 8.0f, 5.0f);
        this.m_233381_(hoglinBrute.idleAnimationState, HoglinBruteAnimation.HOGLIN_BRUTE_IDLE, pAgeInTicks);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)-4.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-9.0f, -14.0f, -4.0f, 18.0f, 14.0f, 26.0f, new CubeDeformation(0.0f)).m_171514_(50, 50).m_171488_(-9.0f, -18.0f, -4.0f, 18.0f, 4.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(0.0f, -28.0f, -4.0f, 0.0f, 12.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(0.0f, -28.0f, -4.0f, 0.0f, 12.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(71, 41).m_171488_(-2.0f, -19.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171488_(-7.0f, -3.0f, -19.5f, 14.0f, 7.0f, 19.0f, new CubeDeformation(0.0f)).m_171514_(8, 40).m_171488_(6.0f, -9.0f, -15.5f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(55, 46).m_171488_(6.0f, -4.0f, -12.5f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 40).m_171488_(-8.0f, -9.0f, -15.5f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(47, 46).m_171488_(-8.0f, -4.0f, -12.5f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(-6, 53).m_171488_(3.0f, -2.0f, -22.5f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-14.0f, (float)-4.5f, (float)0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition right_ear = head.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)-3.0f));
        PartDefinition earring_r1 = right_ear.m_171599_("earring_r1", CubeListBuilder.m_171558_().m_171514_(12, 57).m_171488_(-8.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(47, 40).m_171488_(-7.0f, 0.0f, -2.0f, 7.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition left_ear = head.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)7.0f, (float)-2.0f, (float)-3.0f));
        PartDefinition right_ear_r1 = left_ear.m_171599_("right_ear_r1", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(0.0f, 0.0f, -3.0f, 7.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition front_left_leg = root.m_171599_("front_left_leg", CubeListBuilder.m_171558_().m_171514_(34, 70).m_171488_(-3.0f, -2.0f, -3.5f, 7.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)7.0f, (float)-2.0f, (float)3.5f));
        PartDefinition front_right_leg = root.m_171599_("front_right_leg", CubeListBuilder.m_171558_().m_171514_(62, 0).m_171488_(-4.0f, -2.0f, -3.5f, 7.0f, 13.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-7.0f, (float)-2.0f, (float)3.5f));
        PartDefinition back_left_leg = root.m_171599_("back_left_leg", CubeListBuilder.m_171558_().m_171514_(62, 70).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)17.0f));
        PartDefinition back_right_leg = root.m_171599_("back_right_leg", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -2.0f, -3.0f, 6.0f, 11.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)17.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void animateHeadLookTarget(@NotNull HoglinBrute hoglinBrute, float pLimbSwing, float pLimbSwingAmount, float netHeadYaw, float headPitch) {
        this.rightEar.f_104205_ = -0.6981317f - pLimbSwingAmount * Mth.m_14031_((float)pLimbSwing);
        this.leftEar.f_104205_ = 0.6981317f + pLimbSwingAmount * Mth.m_14031_((float)pLimbSwing);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        int i = hoglinBrute.m_7575_();
        float f = 1.0f - (float)Mth.m_14040_((int)(10 - 2 * i)) / 10.0f;
        this.head.f_104203_ = Mth.m_14179_((float)f, (float)0.87266463f, (float)-0.34906584f);
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.head;
    }
}

