/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.teamdurt.netherdungeons.entity.custom.PiglinThrower;
import com.teamdurt.netherdungeons.entity.model.PiglinThrowerArmorModel;
import com.teamdurt.netherdungeons.entity.model.PiglinThrowerModel;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.client.ForgeHooksClient;

public class PiglinThrowerArmorLayer<T extends PiglinThrower, M extends PiglinThrowerModel<T>, A extends PiglinThrowerArmorModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;
    private final TextureAtlas armorTrimAtlas;

    public PiglinThrowerArmorLayer(RenderLayerParent<T, M> renderLayerParent, A innerModel, A outerModel, ModelManager modelManager) {
        super(renderLayerParent);
        this.innerModel = innerModel;
        this.outerModel = outerModel;
        this.armorTrimAtlas = modelManager.m_119428_(Sheets.f_265912_);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T entity, float v, float v1, float v2, float v3, float v4, float v5) {
        this.renderArmorPiece(poseStack, multiBufferSource, entity, EquipmentSlot.CHEST, i, this.getArmorModel(EquipmentSlot.CHEST));
        this.renderArmorPiece(poseStack, multiBufferSource, entity, EquipmentSlot.LEGS, i, this.getArmorModel(EquipmentSlot.LEGS));
        this.renderArmorPiece(poseStack, multiBufferSource, entity, EquipmentSlot.FEET, i, this.getArmorModel(EquipmentSlot.FEET));
        this.renderArmorPiece(poseStack, multiBufferSource, entity, EquipmentSlot.HEAD, i, this.getArmorModel(EquipmentSlot.HEAD));
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, T entity, EquipmentSlot slot, int i1, A armorModel) {
        ArmorItem armoritem;
        ItemStack itemstack = entity.m_6844_(slot);
        Item $$9 = itemstack.m_41720_();
        if ($$9 instanceof ArmorItem && (armoritem = (ArmorItem)$$9).m_40402_() == slot) {
            ((PiglinThrowerModel)this.m_117386_()).m_102624_((EntityModel)armorModel);
            this.setPartVisibility(armorModel, slot);
            Model model = this.getArmorModelHook(entity, itemstack, slot, armorModel);
            boolean flag = this.usesInnerModel(slot);
            if (armoritem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(poseStack, multiBufferSource, i1, armoritem, model, flag, f, f1, f2, this.getArmorResource((Entity)entity, itemstack, slot, null));
                this.renderModel(poseStack, multiBufferSource, i1, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)entity, itemstack, slot, "overlay"));
            } else {
                this.renderModel(poseStack, multiBufferSource, i1, armoritem, model, flag, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)entity, itemstack, slot, null));
            }
            ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)itemstack).ifPresent(armorTrim -> this.renderTrim(armoritem.m_40401_(), poseStack, multiBufferSource, i1, (ArmorTrim)armorTrim, model, flag));
            if (itemstack.m_41790_()) {
                this.renderGlint(poseStack, multiBufferSource, i1, model);
            }
        }
    }

    protected void setPartVisibility(A armorModel, EquipmentSlot slot) {
        ((PiglinThrowerModel)((Object)armorModel)).setAllVisible(false);
        switch (slot) {
            case HEAD: {
                ((PiglinThrowerArmorModel)((Object)armorModel)).head.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((PiglinThrowerArmorModel)((Object)armorModel)).body.f_104207_ = true;
                ((PiglinThrowerArmorModel)((Object)armorModel)).rightArm.f_104207_ = true;
                ((PiglinThrowerArmorModel)((Object)armorModel)).leftArm.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((PiglinThrowerArmorModel)((Object)armorModel)).body.f_104207_ = true;
                ((PiglinThrowerArmorModel)((Object)armorModel)).rightLeg.f_104207_ = true;
                ((PiglinThrowerArmorModel)((Object)armorModel)).leftLeg.f_104207_ = true;
                break;
            }
            case FEET: {
                ((PiglinThrowerArmorModel)((Object)armorModel)).rightLeg.f_104207_ = true;
                ((PiglinThrowerArmorModel)((Object)armorModel)).leftLeg.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ArmorItem armorItem, A armorModel, boolean b, float v, float v1, float v2, @Nullable String s) {
        this.renderModel(poseStack, multiBufferSource, i, armorItem, (Model)armorModel, b, v, v1, v2, this.getArmorLocation(armorItem, b, s));
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ArmorItem armorItem, Model model, boolean b, float v, float v1, float v2, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        model.m_7695_(poseStack, vertexconsumer, i, OverlayTexture.f_118083_, v, v1, v2, 1.0f);
    }

    private void renderTrim(ArmorMaterial armorMaterial, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ArmorTrim armorTrim, A armorModel, boolean b) {
        this.renderTrim(armorMaterial, poseStack, multiBufferSource, i, armorTrim, armorModel, b);
    }

    private void renderTrim(ArmorMaterial armorMaterial, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, ArmorTrim armorTrim, Model model, boolean b) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(b ? armorTrim.m_267774_(armorMaterial) : armorTrim.m_267606_(armorMaterial));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(multiBufferSource.m_6299_(Sheets.m_266442_()));
        model.m_7695_(poseStack, vertexconsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderGlint(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, A armorModel) {
        this.renderGlint(poseStack, multiBufferSource, i, armorModel);
    }

    private void renderGlint(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, Model model) {
        model.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_110484_()), i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private A getArmorModel(EquipmentSlot equipmentSlot) {
        return this.usesInnerModel(equipmentSlot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS;
    }

    @Deprecated
    private ResourceLocation getArmorLocation(ArmorItem armorItem, boolean b, @Nullable String s1) {
        String s = "textures/models/armor/" + armorItem.m_40401_().m_6082_() + "_layer_" + (b ? 2 : 1) + (String)(s1 == null ? "" : "_" + s1) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent(s, ResourceLocation::new);
    }

    protected Model getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlot slot, A model) {
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

