/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.custom;

import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ZombifiedPiglinThrower
extends ZombifiedPiglin
implements NeutralMob {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState basicAnimationState = new AnimationState();

    public ZombifiedPiglinThrower(EntityType<? extends ZombifiedPiglinThrower> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.basicAnimationState.m_216982_(this.f_19797_);
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_(), this.f_19797_);
        }
    }

    protected void m_6878_() {
        this.f_21345_.m_25352_(2, (Goal)new ZombifiedPiglinThrowerAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ZombifiedPiglinThrower)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier setAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 5.0).m_22265_();
    }

    protected void m_213945_(@NotNull RandomSource pRandom, @NotNull DifficultyInstance pDifficulty) {
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42430_));
    }

    public boolean m_7243_(@NotNull ItemStack itemStack) {
        return super.m_7243_(itemStack) && (itemStack.m_41720_() instanceof SwordItem || itemStack.m_41720_() instanceof AxeItem);
    }

    @NotNull
    public ItemStack m_255207_(@NotNull ItemStack inpItemStack) {
        EquipmentSlot equipmentslot = ZombifiedPiglinThrower.m_147233_(inpItemStack);
        ItemStack itemstack = this.m_6844_(equipmentslot);
        boolean flag = this.m_7808_(inpItemStack, itemstack);
        if (equipmentslot.m_254934_() && !flag) {
            equipmentslot = EquipmentSlot.OFFHAND;
            itemstack = this.m_6844_(equipmentslot);
            flag = itemstack.m_41619_();
        }
        if (flag && this.m_7252_(inpItemStack)) {
            double d0 = this.m_21519_(equipmentslot);
            if (!itemstack.m_41619_() && (double)Math.max(this.f_19796_.m_188501_() - 0.1f, 0.0f) < d0) {
                this.m_19983_(itemstack);
            }
            if (equipmentslot.m_254934_() && inpItemStack.m_41613_() > 1) {
                ItemStack itemstack1 = inpItemStack.m_255036_(1);
                this.m_21468_(equipmentslot, itemstack1);
                return itemstack1;
            }
            this.m_21468_(equipmentslot, inpItemStack);
            return inpItemStack;
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static EquipmentSlot m_147233_(ItemStack itemStack) {
        EquipmentSlot slot = itemStack.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Equipable equipable = Equipable.m_269088_((ItemStack)itemStack);
        return equipable != null ? equipable.m_40402_() : EquipmentSlot.OFFHAND;
    }

    public boolean m_7327_(@NotNull Entity entity) {
        boolean bl;
        int i;
        ItemStack offhandItem = this.m_21206_();
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        Item item = offhandItem.m_41720_();
        if (item instanceof AxeItem) {
            AxeItem axeItem = (AxeItem)item;
            f += axeItem.m_41008_();
        } else {
            item = offhandItem.m_41720_();
            if (item instanceof SwordItem) {
                SwordItem swordItem = (SwordItem)item;
                f += swordItem.m_43299_();
            }
        }
        if (entity instanceof LivingEntity) {
            for (Map.Entry entry : offhandItem.getAllEnchantments().entrySet()) {
                f += ((Enchantment)entry.getKey()).getDamageBonus(((Integer)entry.getValue()).intValue(), ((LivingEntity)entity).m_6336_(), this.m_21206_());
            }
            f1 += 1.0f;
            f1 += (float)offhandItem.getEnchantmentLevel(Enchantments.f_44980_);
        }
        if ((i = offhandItem.getEnchantmentLevel(Enchantments.f_44981_)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (bl = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.m_21424_(player, this.m_21206_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        return bl;
    }

    private void m_21424_(Player player, ItemStack itemStack, ItemStack itemStack1) {
        if (!itemStack.m_41619_() && !itemStack1.m_41619_() && itemStack.m_41720_() instanceof AxeItem && itemStack1.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)itemStack.getEnchantmentLevel(Enchantments.f_44984_) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)player, (byte)30);
            }
        }
    }

    static class ZombifiedPiglinThrowerAttackGoal
    extends ZombieAttackGoal {
        public ZombifiedPiglinThrowerAttackGoal(ZombifiedPiglinThrower pZombie, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((Zombie)pZombie, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
        }

        protected void m_6739_(@NotNull LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (pDistToEnemySqr <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_6674_(InteractionHand.OFF_HAND);
                this.f_25540_.m_7327_((Entity)pEnemy);
            }
        }
    }
}

