/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.teamdurt.netherdungeons.entity.ai.TruncusAi;
import com.teamdurt.netherdungeons.entity.move_control.TruncusMoveControl;
import com.teamdurt.netherdungeons.entity.navigation.TruncusPathNavigation;
import com.teamdurt.netherdungeons.init.NDActivities;
import com.teamdurt.netherdungeons.init.NDEntityDataSerializers;
import com.teamdurt.netherdungeons.init.NDEntityTypes;
import com.teamdurt.netherdungeons.init.NDItems;
import com.teamdurt.netherdungeons.init.NDMemoryTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class Truncus
extends Animal {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState deflatingAnimationState = new AnimationState();
    public final AnimationState inflatingAnimationState = new AnimationState();
    public final AnimationState flightInAnimationState = new AnimationState();
    public final AnimationState flightOutAnimationState = new AnimationState();
    public final AnimationState soaringAnimationState = new AnimationState();
    public final AnimationState truncusSuckingHookedInAnimationState = new AnimationState();
    public final AnimationState truncusSuckingHookedAnimationState = new AnimationState();
    public final AnimationState truncusSuckingHookedOutAnimationState = new AnimationState();
    public final AnimationState truncusSuckingStuckInAnimationState = new AnimationState();
    public final AnimationState truncusSuckingStuckAnimationState = new AnimationState();
    public final AnimationState truncusSuckingStuckOutAnimationState = new AnimationState();
    public final AnimationState truncusSuckingStandingInAnimationState = new AnimationState();
    public final AnimationState truncusSuckingStandingAnimationState = new AnimationState();
    public final AnimationState truncusSuckingStandingOutAnimationState = new AnimationState();
    public final AnimationState truncusSleepingInAnimationState = new AnimationState();
    public final AnimationState truncusSleepingAnimationState = new AnimationState();
    public final AnimationState truncusSleepingOutAnimationState = new AnimationState();
    public static final EntityDataAccessor<Boolean> DATA_IS_FLY_NAVIGATING = SynchedEntityData.m_135353_(Truncus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_IS_FLYING = SynchedEntityData.m_135353_(Truncus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_IS_SLEEPING = SynchedEntityData.m_135353_(Truncus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_IS_SATIATED = SynchedEntityData.m_135353_(Truncus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<AnimationGroup> DATA_ANIMATION_GROUP = SynchedEntityData.m_135353_(Truncus.class, (EntityDataSerializer)((EntityDataSerializer)NDEntityDataSerializers.TRUNCUS_ANIMATION_GROUP.get()));
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Truncus>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148204_, (Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_SLEEP_POSITION.get()), (Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_IS_SLEEPING.get()), (Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_IS_SATIATED.get()), (Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get()));
    public static final int MAX_SATIATION = 5;
    public static final int MAX_STAY_AWAKE_TICKS_LEFT = 1500;
    public static final int SPAWN_SATIATION = 2;
    private static final String SATIATION_KEY = "Satiation";
    private static final String SATIATION_TICKS_KEY = "SatiationTicks";
    private static final String SLEEP_TICKS_LEFT_KEY = "SleepTicksLeft";
    private static final String STAY_AWAKE_TICKS_LEFT_KEY = "StayAwakeTicksLeft";
    private static final String LAST_SCAN_TIME_KEY = "LastScanTime";
    private static final int STARVE_FREQUENCY = 4000;
    private int satiationTicks = 0;
    private int satiation = 2;
    private int stayAwakeTicksLeft = 1500;
    private int sleepTicksLeft = 0;
    private long lastScanTime = 0L;

    public Truncus(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new TruncusMoveControl(this, 10);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 14.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22280_, (double)0.4f).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_FLY_NAVIGATING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_ANIMATION_GROUP, (Object)AnimationGroup.WALKING);
        this.f_19804_.m_135372_(DATA_IS_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_SATIATED, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_(SATIATION_KEY, this.getSatiation());
        pCompound.m_128405_(SATIATION_TICKS_KEY, this.getSatiationTicks());
        pCompound.m_128405_(SLEEP_TICKS_LEFT_KEY, this.getSleepTicksLeft());
        pCompound.m_128405_(STAY_AWAKE_TICKS_LEFT_KEY, this.getStayAwakeTicksLeft());
        pCompound.m_128356_(LAST_SCAN_TIME_KEY, this.getLastScanTime());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setSatiation(pCompound.m_128451_(SATIATION_KEY));
        this.setSatiationTicks(pCompound.m_128451_(SATIATION_TICKS_KEY));
        this.setSleepTicksLeft(pCompound.m_128451_(SLEEP_TICKS_LEFT_KEY));
        this.setStayAwakeTicksLeft(pCompound.m_128451_(STAY_AWAKE_TICKS_LEFT_KEY));
        this.setLastScanTime(pCompound.m_128454_(LAST_SCAN_TIME_KEY));
        if (this.m_5803_() && !this.isFlyNavigating() && this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60838_((BlockGetter)this.m_9236_(), this.m_20183_().m_7495_())) {
            this.m_6274_().m_21879_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SLEEP_POSITION.get(), (Object)this.m_20183_());
            this.m_6274_().m_21889_((Activity)NDActivities.SLEEP.get());
        } else {
            this.setSleepTicksLeft(0);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.decrementSatiationTicks(1);
        this.decrementStayAwakeTicksLeft(1);
        if (!this.m_9236_().f_46443_) {
            switch (this.getAnimationGroup()) {
                case SUCKING_HOOKED_OUT: 
                case SUCKING_STUCK_OUT: 
                case SUCKING_STANDING_OUT: 
                case SITTING_OUT: {
                    ((TruncusMoveControl)this.m_21566_()).setLocked(false);
                }
            }
            return;
        }
        this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && !this.truncusSuckingHookedAnimationState.m_216984_() && !this.truncusSuckingStuckAnimationState.m_216984_() && !this.truncusSuckingStandingAnimationState.m_216984_() && !this.m_5803_(), this.f_19797_);
        switch (this.getAnimationGroup()) {
            case WALKING: {
                this.truncusSleepingAnimationState.m_216973_();
                this.truncusSleepingInAnimationState.m_216973_();
                this.flightInAnimationState.m_216973_();
                this.inflatingAnimationState.m_216973_();
                this.soaringAnimationState.m_216973_();
                this.truncusSuckingHookedInAnimationState.m_216973_();
                this.truncusSuckingHookedAnimationState.m_216973_();
                this.truncusSuckingStandingInAnimationState.m_216973_();
                this.truncusSuckingStandingAnimationState.m_216973_();
                this.truncusSuckingStuckInAnimationState.m_216973_();
                this.truncusSuckingStuckAnimationState.m_216973_();
                break;
            }
            case FLYING_MOVE_TO: 
            case LANDING: {
                this.truncusSleepingAnimationState.m_216973_();
                this.truncusSleepingInAnimationState.m_216973_();
                this.deflatingAnimationState.m_216973_();
                this.soaringAnimationState.m_216973_();
                this.flightOutAnimationState.m_216973_();
                this.truncusSuckingHookedInAnimationState.m_216973_();
                this.truncusSuckingHookedAnimationState.m_216973_();
                this.truncusSuckingStandingInAnimationState.m_216973_();
                this.truncusSuckingStandingAnimationState.m_216973_();
                this.truncusSuckingStuckInAnimationState.m_216973_();
                this.truncusSuckingStuckAnimationState.m_216973_();
                this.flightInAnimationState.m_216982_(this.f_19797_);
                this.inflatingAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case FLYING_WAIT: {
                this.truncusSleepingAnimationState.m_216973_();
                this.truncusSleepingInAnimationState.m_216973_();
                this.deflatingAnimationState.m_216973_();
                this.flightInAnimationState.m_216973_();
                this.truncusSuckingHookedInAnimationState.m_216973_();
                this.truncusSuckingHookedAnimationState.m_216973_();
                this.truncusSuckingStandingInAnimationState.m_216973_();
                this.truncusSuckingStandingAnimationState.m_216973_();
                this.truncusSuckingStuckInAnimationState.m_216973_();
                this.truncusSuckingStuckAnimationState.m_216973_();
                this.soaringAnimationState.m_216982_(this.f_19797_);
                this.flightOutAnimationState.m_216982_(this.f_19797_);
                this.inflatingAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case STOP_LANDING: {
                this.truncusSleepingAnimationState.m_216973_();
                this.truncusSleepingInAnimationState.m_216973_();
                this.inflatingAnimationState.m_216973_();
                this.flightInAnimationState.m_216973_();
                this.soaringAnimationState.m_216973_();
                this.truncusSuckingHookedInAnimationState.m_216973_();
                this.truncusSuckingHookedAnimationState.m_216973_();
                this.truncusSuckingStandingInAnimationState.m_216973_();
                this.truncusSuckingStandingAnimationState.m_216973_();
                this.truncusSuckingStuckInAnimationState.m_216973_();
                this.truncusSuckingStuckAnimationState.m_216973_();
                this.flightOutAnimationState.m_216982_(this.f_19797_);
                this.deflatingAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case SUCKING_HOOKED: {
                this.truncusSleepingAnimationState.m_216973_();
                this.truncusSleepingInAnimationState.m_216973_();
                this.flightInAnimationState.m_216973_();
                this.inflatingAnimationState.m_216973_();
                this.soaringAnimationState.m_216973_();
                this.flightOutAnimationState.m_216982_(this.f_19797_);
                this.deflatingAnimationState.m_216982_(this.f_19797_);
                this.truncusSuckingHookedInAnimationState.m_216982_(this.f_19797_);
                this.truncusSuckingHookedAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case SUCKING_HOOKED_OUT: {
                this.truncusSuckingHookedInAnimationState.m_216973_();
                this.truncusSuckingHookedOutAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case SUCKING_STUCK: {
                this.truncusSleepingAnimationState.m_216973_();
                this.truncusSleepingInAnimationState.m_216973_();
                this.flightInAnimationState.m_216973_();
                this.deflatingAnimationState.m_216973_();
                this.soaringAnimationState.m_216973_();
                this.inflatingAnimationState.m_216982_(this.f_19797_);
                this.flightOutAnimationState.m_216982_(this.f_19797_);
                this.truncusSuckingStuckInAnimationState.m_216982_(this.f_19797_);
                this.truncusSuckingStuckAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case SUCKING_STUCK_OUT: {
                this.truncusSuckingStuckInAnimationState.m_216973_();
                this.truncusSuckingStuckOutAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case SUCKING_STANDING: {
                this.truncusSleepingAnimationState.m_216973_();
                this.truncusSleepingInAnimationState.m_216973_();
                this.flightInAnimationState.m_216973_();
                this.inflatingAnimationState.m_216973_();
                this.soaringAnimationState.m_216973_();
                this.deflatingAnimationState.m_216982_(this.f_19797_);
                this.flightOutAnimationState.m_216982_(this.f_19797_);
                this.truncusSuckingStandingInAnimationState.m_216982_(this.f_19797_);
                this.truncusSuckingStandingAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case SUCKING_STANDING_OUT: {
                this.truncusSuckingStandingInAnimationState.m_216973_();
                this.truncusSuckingStandingOutAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case SITTING: {
                this.flightInAnimationState.m_216973_();
                this.inflatingAnimationState.m_216973_();
                this.soaringAnimationState.m_216973_();
                this.flightOutAnimationState.m_216982_(this.f_19797_);
                this.deflatingAnimationState.m_216982_(this.f_19797_);
                this.truncusSleepingInAnimationState.m_216982_(this.f_19797_);
                this.truncusSleepingAnimationState.m_216982_(this.f_19797_);
                break;
            }
            case SITTING_OUT: {
                this.truncusSleepingInAnimationState.m_216973_();
                this.truncusSleepingOutAnimationState.m_216977_(this.f_19797_);
            }
        }
    }

    public void decrementSatiation(int i) {
        this.setSatiation(Math.max(0, this.getSatiation() - i));
    }

    public void incrementSatiation(int i) {
        this.setSatiation(this.getSatiation() + i);
    }

    public void setSatiation(int satiation) {
        this.satiation = satiation;
        this.setSatiated(satiation >= 5);
    }

    public int getSatiation() {
        return this.satiation;
    }

    public void decrementSatiationTicks(int ticks) {
        this.setSatiationTicks(this.getSatiationTicks() - ticks);
    }

    public int getSatiationTicks() {
        return this.satiationTicks;
    }

    public void setSatiationTicks(int ticks) {
        this.satiationTicks = ticks;
        if (this.satiationTicks <= 0) {
            this.decrementSatiation(1);
            this.satiationTicks = 4000;
        }
    }

    public long getLastScanTime() {
        return this.lastScanTime;
    }

    public void setLastScanTime(long ticks) {
        this.lastScanTime = ticks;
    }

    public void decrementSleepTicksLeft(int ticks) {
        this.setSleepTicksLeft(this.getSleepTicksLeft() - ticks);
    }

    public int getSleepTicksLeft() {
        return this.sleepTicksLeft;
    }

    public void setSleepTicksLeft(int ticks) {
        this.sleepTicksLeft = Math.max(ticks, 0);
        boolean sleeping = this.sleepTicksLeft > 0;
        this.setSleeping(sleeping);
        if (!sleeping) {
            this.m_6274_().m_21936_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SLEEP_POSITION.get());
        }
    }

    public void decrementStayAwakeTicksLeft(int ticks) {
        this.setStayAwakeTicksLeft(this.getStayAwakeTicksLeft() - ticks);
    }

    public int getStayAwakeTicksLeft() {
        return this.stayAwakeTicksLeft;
    }

    public void setStayAwakeTicksLeft(int ticks) {
        this.stayAwakeTicksLeft = Math.max(ticks, 0);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemStack = pPlayer.m_21120_(pHand);
        if (itemStack.m_41720_() == NDItems.TRUNCUS_SPAWN_EGG.get() || !this.m_6084_() || !this.isSatiated() || !this.m_5803_() || pPlayer.m_36341_()) {
            return super.m_6071_(pPlayer, pHand);
        }
        if (this.m_6162_() || this.m_9236_().f_46443_) {
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        boolean holdingBottle = itemStack.m_150930_(Items.f_42590_);
        if (holdingBottle && pHand == InteractionHand.MAIN_HAND) {
            this.decrementSatiation(3);
            ItemStack bottle = new ItemStack((ItemLike)NDItems.LUMINOPHORE_BOTTLE.get());
            if (pPlayer.m_21120_(pHand).m_41613_() == 1) {
                pPlayer.m_21008_(pHand, bottle);
            } else {
                itemStack.m_41774_(1);
                pPlayer.m_36356_(bottle);
            }
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)Items.f_42590_));
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public boolean m_5830_() {
        if (this.getAnimationGroup() == AnimationGroup.SUCKING_HOOKED || this.getAnimationGroup() == AnimationGroup.SUCKING_STANDING || this.getAnimationGroup() == AnimationGroup.SUCKING_STUCK) {
            return false;
        }
        return super.m_5830_();
    }

    protected Brain.Provider<Truncus> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> pDynamic) {
        return TruncusAi.makeBrain(this, (Brain<Truncus>)this.m_5490_().m_22073_(pDynamic));
    }

    public Brain<Truncus> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("truncusBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("truncusActivityUpdate");
        TruncusAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new TruncusPathNavigation((Mob)this, pLevel);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (this.isFlyNavigating()) {
            this.m_183634_();
            return false;
        }
        return super.m_142535_(pFallDistance, pMultiplier, pSource);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)NDEntityTypes.TRUNCUS.get()).m_20615_((Level)pLevel);
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return 0.875f;
    }

    public void setFlyNavigating(boolean isFlyNavigating) {
        this.f_19804_.m_135381_(DATA_IS_FLY_NAVIGATING, (Object)isFlyNavigating);
    }

    public boolean isFlyNavigating() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_FLY_NAVIGATING);
    }

    public void setFlying(boolean isFlying) {
        this.f_19804_.m_135381_(DATA_IS_FLYING, (Object)isFlying);
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_FLYING);
    }

    private void setSatiated(boolean satiated) {
        if (satiated) {
            this.m_6274_().m_21879_((MemoryModuleType)NDMemoryTypes.TRUNCUS_IS_SATIATED.get(), (Object)Unit.INSTANCE);
        } else {
            this.m_6274_().m_21936_((MemoryModuleType)NDMemoryTypes.TRUNCUS_IS_SATIATED.get());
        }
        this.f_19804_.m_135381_(DATA_IS_SATIATED, (Object)satiated);
    }

    public boolean isSatiated() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SATIATED);
    }

    private void setSleeping(boolean sleeping) {
        if (sleeping) {
            this.m_6274_().m_21879_((MemoryModuleType)NDMemoryTypes.TRUNCUS_IS_SLEEPING.get(), (Object)Unit.INSTANCE);
        } else {
            this.m_6274_().m_21936_((MemoryModuleType)NDMemoryTypes.TRUNCUS_IS_SLEEPING.get());
        }
        this.f_19804_.m_135381_(DATA_IS_SLEEPING, (Object)sleeping);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SLEEPING);
    }

    public void wakeUp() {
        this.setAnimationGroup(AnimationGroup.SITTING_OUT);
        this.setStayAwakeTicksLeft(1500);
        this.setSleepTicksLeft(0);
    }

    public AnimationGroup getAnimationGroup() {
        return (AnimationGroup)((Object)this.f_19804_.m_135370_(DATA_ANIMATION_GROUP));
    }

    public void setAnimationGroup(AnimationGroup animationGroup) {
        this.f_19804_.m_135381_(DATA_ANIMATION_GROUP, (Object)animationGroup);
    }

    public boolean shouldTryToSleep(ServerLevel level) {
        return this.getStayAwakeTicksLeft() == 0 && this.isSatiated();
    }

    public boolean shouldTryToSuck(ServerLevel level) {
        return this.getStayAwakeTicksLeft() < 1400 && this.getSatiation() < 5;
    }

    public static boolean checkTruncusSpawnRules(EntityType<Truncus> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        return levelAccessor.m_204166_(blockPos).m_203565_(Biomes.f_48201_) && !levelAccessor.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_50692_) && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)random) && random.m_188503_(5) == 0;
    }

    public static enum AnimationGroup {
        WALKING,
        FLYING_MOVE_TO,
        FLYING_WAIT,
        LANDING,
        STOP_LANDING,
        SUCKING_HOOKED,
        SUCKING_HOOKED_OUT,
        SUCKING_STUCK,
        SUCKING_STUCK_OUT,
        SUCKING_STANDING,
        SUCKING_STANDING_OUT,
        SITTING,
        SITTING_OUT;

    }
}

