/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.teamdurt.netherdungeons.entity.ai.PiglinThrowerAi;
import com.teamdurt.netherdungeons.entity.custom.ZombifiedPiglinThrower;
import com.teamdurt.netherdungeons.init.NDEntityTypes;
import com.teamdurt.netherdungeons.init.NDMemoryTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class PiglinThrower
extends AbstractPiglin {
    public final AnimationState basicAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState dancingAnimationState = new AnimationState();
    public final AnimationState rangeAttackFrontAnimationState = new AnimationState();
    public final AnimationState rangeAttackBackAnimationState = new AnimationState();
    public final AnimationState meleeAttackAnimationState = new AnimationState();
    public static final EntityDataAccessor<Boolean> DATA_IS_RANGE_ATTACKING = SynchedEntityData.m_135353_(PiglinThrower.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_IS_MELEE_ATTACKING = SynchedEntityData.m_135353_(PiglinThrower.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_IS_RANGE_ATTACK_BACK = SynchedEntityData.m_135353_(PiglinThrower.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final ImmutableList<SensorType<? extends Sensor<? super PiglinThrower>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26814_, (Object)SensorType.f_26819_);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26379_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26347_, (Object)MemoryModuleType.f_26346_, (Object)MemoryModuleType.f_26381_, (Object)MemoryModuleType.f_26382_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, MemoryModuleType.f_26374_, MemoryModuleType.f_26377_, MemoryModuleType.f_26334_, MemoryModuleType.f_26333_, MemoryModuleType.f_26345_, MemoryModuleType.f_26359_, (MemoryModuleType)NDMemoryTypes.PIGLIN_THROWER_ATTACK_COOLDOWN.get()});

    public PiglinThrower(EntityType<? extends AbstractPiglin> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22281_, 4.0).m_22265_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_RANGE_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_MELEE_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_RANGE_ATTACK_BACK, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        PiglinThrowerAi.initMemories(this);
        return super.m_6518_(levelAccessor, difficultyInstance, spawnType, spawnGroupData, tag);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.basicAnimationState.m_216982_(this.f_19797_);
            this.rangeAttackFrontAnimationState.m_246184_(this.isRangeAttacking() && !this.isRangeAttackBack(), this.f_19797_);
            this.rangeAttackBackAnimationState.m_246184_(this.isRangeAttacking() && this.isRangeAttackBack(), this.f_19797_);
            this.meleeAttackAnimationState.m_246184_(this.isMeleeAttacking(), this.f_19797_);
            this.idleAnimationState.m_246184_(!this.dancingAnimationState.m_216984_() && !this.f_267362_.m_267780_(), this.f_19797_);
        }
    }

    public boolean m_7243_(ItemStack itemStack) {
        return super.m_7243_(itemStack) && (itemStack.m_41720_() instanceof SwordItem || itemStack.m_41720_() instanceof AxeItem);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        boolean flag = super.m_6469_(damageSource, f);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (flag && damageSource.m_7639_() instanceof LivingEntity) {
            PiglinThrowerAi.wasHurtBy(this, (LivingEntity)damageSource.m_7639_());
        }
        return flag;
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        int i;
        ItemStack offhandItem = this.m_21206_();
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        Item item = offhandItem.m_41720_();
        if (item instanceof AxeItem) {
            AxeItem axeItem = (AxeItem)item;
            f += axeItem.m_41008_();
        } else {
            item = offhandItem.m_41720_();
            if (item instanceof SwordItem) {
                SwordItem swordItem = (SwordItem)item;
                f += swordItem.m_43299_();
            }
        }
        if (entity instanceof LivingEntity) {
            for (Map.Entry entry : offhandItem.getAllEnchantments().entrySet()) {
                f += ((Enchantment)entry.getKey()).getDamageBonus(((Integer)entry.getValue()).intValue(), ((LivingEntity)entity).m_6336_(), this.m_21206_());
            }
            f1 += this.isMeleeAttacking() ? 1.0f : 0.0f;
            f1 += (float)offhandItem.getEnchantmentLevel(Enchantments.f_44980_);
        }
        if ((i = offhandItem.getEnchantmentLevel(Enchantments.f_44981_)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (bl = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.m_21424_(player, this.m_21206_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        return bl;
    }

    private void m_21424_(Player player, ItemStack itemStack, ItemStack itemStack1) {
        if (!itemStack.m_41619_() && !itemStack1.m_41619_() && itemStack.m_41720_() instanceof AxeItem && itemStack1.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)itemStack.getEnchantmentLevel(Enchantments.f_44984_) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)player, (byte)30);
            }
        }
    }

    public boolean m_6785_(double p_34775_) {
        super.m_6785_(p_34775_);
        return !this.m_21532_();
    }

    protected boolean m_8028_() {
        return false;
    }

    protected boolean m_7121_() {
        return false;
    }

    protected Brain.Provider<PiglinThrower> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> p_35064_) {
        return PiglinThrowerAi.makeBrain(this, (Brain<PiglinThrower>)this.m_5490_().m_22073_(p_35064_));
    }

    public Brain<PiglinThrower> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        super.m_8024_();
        this.m_9236_().m_46473_().m_6180_("piglinThrowerBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        PiglinThrowerAi.updateActivity(this);
        PiglinThrowerAi.maybePlayActivitySound(this);
        super.m_8024_();
    }

    public PiglinArmPose m_6389_() {
        return PiglinArmPose.DEFAULT;
    }

    protected void m_7580_() {
        this.m_216990_(SoundEvents.f_12300_);
    }

    public void playAngrySound() {
        this.m_5496_(SoundEvents.f_12240_, 1.0f, this.m_6100_());
    }

    protected float m_6431_(Pose p_34740_, EntityDimensions p_34741_) {
        float f = super.m_6431_(p_34740_, p_34741_);
        return this.m_6162_() ? f - 0.82f : f;
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.92;
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12239_;
    }

    protected SoundEvent m_7975_(DamageSource p_34767_) {
        return SoundEvents.f_12244_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12242_;
    }

    public boolean isRangeAttacking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_RANGE_ATTACKING);
    }

    public void setRangeAttacking(boolean isAttacking) {
        this.f_19804_.m_135381_(DATA_IS_RANGE_ATTACKING, (Object)isAttacking);
    }

    public boolean isMeleeAttacking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_MELEE_ATTACKING);
    }

    public void setMeleeAttacking(boolean isAttacking) {
        this.f_19804_.m_135381_(DATA_IS_MELEE_ATTACKING, (Object)isAttacking);
    }

    public boolean isRangeAttackBack() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_RANGE_ATTACK_BACK);
    }

    public void setRangeAttackBack(boolean isAttackBack) {
        this.f_19804_.m_135381_(DATA_IS_RANGE_ATTACK_BACK, (Object)isAttackBack);
    }

    public ItemStack m_255207_(ItemStack inpItemStack) {
        EquipmentSlot equipmentslot = PiglinThrower.m_147233_(inpItemStack);
        ItemStack itemstack = this.m_6844_(equipmentslot);
        boolean flag = this.m_7808_(inpItemStack, itemstack);
        if (equipmentslot.m_254934_() && !flag) {
            equipmentslot = EquipmentSlot.OFFHAND;
            itemstack = this.m_6844_(equipmentslot);
            flag = itemstack.m_41619_();
        }
        if (flag && this.m_7252_(inpItemStack)) {
            double d0 = this.m_21519_(equipmentslot);
            if (!itemstack.m_41619_() && (double)Math.max(this.f_19796_.m_188501_() - 0.1f, 0.0f) < d0) {
                this.m_19983_(itemstack);
            }
            if (equipmentslot.m_254934_() && inpItemStack.m_41613_() > 1) {
                ItemStack itemstack1 = inpItemStack.m_255036_(1);
                this.m_21468_(equipmentslot, itemstack1);
                return itemstack1;
            }
            this.m_21468_(equipmentslot, inpItemStack);
            return inpItemStack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean checkPiglinSpawnRules(EntityType<PiglinThrower> entityType, LevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        return levelAccessor.m_204166_(blockPos).m_203565_(Biomes.f_48201_) && !levelAccessor.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_50692_) && Mob.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)random) && random.m_188503_(3) == 0;
    }

    public static EquipmentSlot m_147233_(ItemStack itemStack) {
        EquipmentSlot slot = itemStack.getEquipmentSlot();
        if (slot != null) {
            return slot;
        }
        Equipable equipable = Equipable.m_269088_((ItemStack)itemStack);
        return equipable != null ? equipable.m_40402_() : EquipmentSlot.OFFHAND;
    }

    protected void m_8063_(ServerLevel pServerLevel) {
        ZombifiedPiglinThrower zombifiedpiglin = (ZombifiedPiglinThrower)this.m_21406_((EntityType)NDEntityTypes.ZOMBIFIED_PIGLIN_THROWER.get(), true);
        if (zombifiedpiglin != null) {
            zombifiedpiglin.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)zombifiedpiglin);
        }
    }
}

