/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.custom;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.teamdurt.netherdungeons.entity.ai.HoglinBruteAi;
import com.teamdurt.netherdungeons.init.NDMemoryTypes;
import com.teamdurt.netherdungeons.init.NDSensorTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoglinBrute
extends Animal
implements Enemy,
HoglinBase {
    private static final EntityDataAccessor<Boolean> DATA_IMMUNE_TO_ZOMBIFICATION = SynchedEntityData.m_135353_(HoglinBrute.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int MAX_HEALTH = 40;
    private static final float MOVEMENT_SPEED_WHEN_FIGHTING = 0.3f;
    private static final int ATTACK_KNOCKBACK = 1;
    private static final float KNOCKBACK_RESISTANCE = 0.6f;
    private static final int ATTACK_DAMAGE = 6;
    private static final int CONVERSION_TIME = 300;
    private int attackAnimationRemainingTicks;
    private int timeInOverworld;
    private boolean cannotBeHunted;
    public final AnimationState idleAnimationState = new AnimationState();
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super HoglinBrute>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)((SensorType)NDSensorTypes.HOGLIN_BRUTE_SPECIFIC_SENSOR.get()));
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26383_, (Object)MemoryModuleType.f_26357_, (Object[])new MemoryModuleType[]{(MemoryModuleType)NDMemoryTypes.NEAREST_VISIBLE_BRUTE_HOGLINS.get()});

    public HoglinBrute(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_();
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, (double)0.6f).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22281_, 6.0).m_22265_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_(), this.f_19797_);
        }
    }

    public boolean m_7327_(Entity pEntity) {
        if (!(pEntity instanceof LivingEntity)) {
            return false;
        }
        this.attackAnimationRemainingTicks = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_11958_, 1.0f, this.m_6100_());
        HoglinBruteAi.onHitTarget(this, (LivingEntity)pEntity);
        return HoglinBase.m_34642_((LivingEntity)this, (LivingEntity)((LivingEntity)pEntity));
    }

    protected void m_6731_(LivingEntity pEntity) {
        HoglinBase.m_34645_((LivingEntity)this, (LivingEntity)pEntity);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        boolean flag = super.m_6469_(pSource, pAmount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (flag && pSource.m_7639_() instanceof LivingEntity) {
            HoglinBruteAi.wasHurtBy(this, (LivingEntity)pSource.m_7639_());
        }
        return flag;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<HoglinBrute> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> pDynamic) {
        return HoglinBruteAi.makeBrain((Brain<HoglinBrute>)this.m_5490_().m_22073_(pDynamic));
    }

    public Brain<HoglinBrute> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("hoglinBruteBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        HoglinBruteAi.updateActivity(this);
        if (this.isConverting()) {
            ++this.timeInOverworld;
            if (this.timeInOverworld > 300 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20500_, timer -> {
                this.timeInOverworld = timer;
            })) {
                this.playSoundEvent(SoundEvents.f_11959_);
                this.finishConversion((ServerLevel)this.m_9236_());
            }
        } else {
            this.timeInOverworld = 0;
        }
    }

    public void m_8107_() {
        if (this.attackAnimationRemainingTicks > 0) {
            --this.attackAnimationRemainingTicks;
        }
        super.m_8107_();
    }

    public static boolean checkHoglinBruteSpawnRules(EntityType<HoglinBrute> pHoglin, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return !pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50451_);
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return !this.m_21532_();
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return pLevel.m_8055_(pPos.m_7495_()).m_60713_(Blocks.f_50699_) ? 10.0f : 0.0f;
    }

    public double m_6048_() {
        return (double)this.m_20206_() - 0.15;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
        if (interactionresult.m_19077_()) {
            this.m_21530_();
        }
        return interactionresult;
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackAnimationRemainingTicks = 10;
            this.m_5496_(SoundEvents.f_11958_, 1.0f, this.m_6100_());
        } else {
            super.m_7822_(pId);
        }
    }

    public int m_7575_() {
        return this.attackAnimationRemainingTicks;
    }

    public boolean m_6149_() {
        return true;
    }

    public int m_213860_() {
        return this.f_21364_;
    }

    private void finishConversion(ServerLevel pServerLevel) {
        Zoglin zoglin = (Zoglin)this.m_21406_(EntityType.f_20500_, true);
        if (zoglin != null) {
            zoglin.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)zoglin);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IMMUNE_TO_ZOMBIFICATION, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.isImmuneToZombification()) {
            pCompound.m_128379_("IsImmuneToZombification", true);
        }
        pCompound.m_128405_("TimeInOverworld", this.timeInOverworld);
        if (this.cannotBeHunted) {
            pCompound.m_128379_("CannotBeHunted", true);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setImmuneToZombification(pCompound.m_128471_("IsImmuneToZombification"));
        this.timeInOverworld = pCompound.m_128451_("TimeInOverworld");
        this.setCannotBeHunted(pCompound.m_128471_("CannotBeHunted"));
    }

    public void setImmuneToZombification(boolean pImmuneToZombification) {
        this.m_20088_().m_135381_(DATA_IMMUNE_TO_ZOMBIFICATION, (Object)pImmuneToZombification);
    }

    private boolean isImmuneToZombification() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IMMUNE_TO_ZOMBIFICATION);
    }

    public boolean isConverting() {
        return !this.m_9236_().m_6042_().m_63960_() && !this.isImmuneToZombification() && !this.m_21525_();
    }

    private void setCannotBeHunted(boolean pCannotBeHunted) {
        this.cannotBeHunted = pCannotBeHunted;
    }

    public boolean canBeHunted() {
        return !this.cannotBeHunted;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        Hoglin hoglin = (Hoglin)EntityType.f_20456_.m_20615_((Level)pLevel);
        if (hoglin != null) {
            hoglin.m_21530_();
        }
        return hoglin;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected SoundEvent m_7515_() {
        return this.m_9236_().f_46443_ ? null : HoglinBruteAi.getSoundForCurrentActivity(this).orElse(null);
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11961_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11960_;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_12042_;
    }

    protected SoundEvent m_5509_() {
        return SoundEvents.f_12041_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11963_, 0.15f, 1.0f);
    }

    public void playSoundEvent(SoundEvent pSoundEvent) {
        this.m_5496_(pSoundEvent, this.m_6121_(), this.m_6100_());
    }

    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }
}

