/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.custom;

import com.teamdurt.netherdungeons.init.NDEffects;
import com.teamdurt.netherdungeons.init.NDItems;
import com.teamdurt.netherdungeons.init.NDSounds;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class BabyGhast
extends TamableAnimal {
    private static final EntityDataAccessor<Boolean> HOVERING = SynchedEntityData.m_135353_(BabyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public BabyGhast(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOVERING, (Object)false);
    }

    public static AttributeSupplier setAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22280_, (double)0.4f).m_22265_();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setHovering(tag.m_128471_("isHovering"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("isHovering", this.isHovering());
    }

    protected PathNavigation m_6037_(Level level) {
        return new FlyingPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BabyGhastHoverGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BabyGhastFollowOwnerGoal(this, 1.2, 10.0f, 5.0f));
        this.f_21345_.m_25352_(3, (Goal)new BabyGhastGiveVampirismEffectGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TranslateBabyGhastIntoGhastGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 20){

            protected Vec3 m_7037_() {
                RandomSource random = BabyGhast.this.m_217043_();
                double dir_x = BabyGhast.this.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_y = BabyGhast.this.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_z = BabyGhast.this.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 30.0f, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void setHovering(boolean hovering) {
        this.f_19804_.m_135381_(HOVERING, (Object)hovering);
    }

    public boolean isHovering() {
        return (Boolean)this.f_19804_.m_135370_(HOVERING);
    }

    public boolean m_6573_(Player p_21813_) {
        return true;
    }

    public void m_20242_(boolean noGravity) {
        super.m_20242_(true);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean m_7848_(Animal p_27569_) {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20242_(true);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6048_() {
        return super.m_6048_() + 1.0;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_((Item)NDItems.ARTICHOKE_FRUIT.get());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_150930_((Item)NDItems.ARTICHOKE_FRUIT.get()) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult interactionresult = super.m_6071_(player, hand);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                    this.setHovering(!this.isHovering());
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        } else if (itemstack.m_150930_((Item)NDItems.ARTICHOKE_FRUIT.get())) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(101) <= 24 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.setHovering(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float p_27568_) {
        this.setHovering(false);
        return super.m_6469_(source, p_27568_);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)NDSounds.BABY_GHAST_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)NDSounds.BABY_GHAST_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)NDSounds.BABY_GHAST_DEATH.get();
    }

    private static class BabyGhastHoverGoal
    extends Goal {
        private final BabyGhast babyGhast;

        public BabyGhastHoverGoal(BabyGhast babyGhast) {
            this.babyGhast = babyGhast;
        }

        public boolean m_8036_() {
            return this.babyGhast.isHovering();
        }

        public void m_8037_() {
            super.m_8037_();
            this.babyGhast.m_21573_().m_26573_();
        }
    }

    public static class BabyGhastFollowOwnerGoal
    extends Goal {
        public static final int TELEPORT_WHEN_DISTANCE_IS = 50;
        private final BabyGhast babyGhast;
        private LivingEntity owner;
        private final LevelReader level;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private final boolean canFly;

        public BabyGhastFollowOwnerGoal(BabyGhast babyGhast, double speedModifier, float startDistance, float stopDistance) {
            this.babyGhast = babyGhast;
            this.level = babyGhast.m_9236_();
            this.speedModifier = speedModifier;
            this.navigation = babyGhast.m_21573_();
            this.startDistance = startDistance;
            this.stopDistance = stopDistance;
            this.canFly = true;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(babyGhast.m_21573_() instanceof GroundPathNavigation) && !(babyGhast.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            LivingEntity $$0 = this.babyGhast.m_269323_();
            if ($$0 == null) {
                return false;
            }
            if ($$0.m_5833_()) {
                return false;
            }
            if (this.babyGhast.isHovering()) {
                return false;
            }
            if (this.babyGhast.m_20280_((Entity)$$0) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            this.owner = $$0;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.babyGhast.isHovering()) {
                return false;
            }
            return !(this.babyGhast.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.babyGhast.m_21439_(BlockPathTypes.WATER);
            this.babyGhast.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            this.owner = null;
            this.navigation.m_26573_();
            this.babyGhast.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            this.babyGhast.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.babyGhast.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (!this.babyGhast.m_21523_() && !this.babyGhast.m_20159_()) {
                    if (this.babyGhast.m_20280_((Entity)this.owner) >= 2500.0) {
                        this.teleportToOwner();
                    } else {
                        this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                    }
                }
            }
        }

        private void teleportToOwner() {
            BlockPos $$0 = this.owner.m_20183_();
            for (int $$1 = 0; $$1 < 10; ++$$1) {
                int $$2 = this.randomIntInclusive(-3, 3);
                int $$3 = this.randomIntInclusive(-1, 3);
                int $$4 = this.randomIntInclusive(-3, 3);
                boolean $$5 = this.maybeTeleportTo($$0.m_123341_() + $$2, $$0.m_123342_() + $$3, $$0.m_123343_() + $$4);
                if (!$$5) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int p_25304_, int p_25305_, int p_25306_) {
            if (Math.abs((double)p_25304_ - this.owner.m_20185_()) < 2.0 && Math.abs((double)p_25306_ - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(p_25304_, p_25305_, p_25306_))) {
                return false;
            }
            this.babyGhast.m_7678_((double)p_25304_ + 0.5, p_25305_, (double)p_25306_ + 0.5, this.babyGhast.m_146908_(), this.babyGhast.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean canTeleportTo(BlockPos pos) {
            if (!this.level.m_8055_(pos).m_60713_(Blocks.f_50016_)) {
                return false;
            }
            BlockState $$2 = this.level.m_8055_(pos.m_7495_());
            if (!this.canFly && $$2.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos $$3 = pos.m_121996_((Vec3i)this.babyGhast.m_20183_());
            return this.level.m_45756_((Entity)this.babyGhast, this.babyGhast.m_20191_().m_82338_($$3));
        }

        private int randomIntInclusive(int p_25301_, int p_25302_) {
            return this.babyGhast.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
        }
    }

    private static class BabyGhastGiveVampirismEffectGoal
    extends Goal {
        private final BabyGhast babyGhast;
        private LivingEntity owner;
        private int effectLevel;

        public BabyGhastGiveVampirismEffectGoal(BabyGhast babyGhast) {
            this.babyGhast = babyGhast;
        }

        public boolean m_8036_() {
            if (this.babyGhast.m_269323_() == null || this.babyGhast.isHovering() || this.babyGhast.m_20280_((Entity)this.babyGhast.m_269323_()) > 100.0) {
                return false;
            }
            this.owner = this.babyGhast.m_269323_();
            List nearByBabyGhasts = this.owner.m_9236_().m_6443_(BabyGhast.class, AABB.m_165882_((Vec3)new Vec3(this.owner.m_20185_(), this.owner.m_20186_(), this.owner.m_20189_()), (double)10.0, (double)10.0, (double)10.0), bg -> bg.m_21824_() && Objects.equals(bg.m_269323_(), this.owner) && !bg.isHovering());
            this.effectLevel = nearByBabyGhasts.size() > 3 ? 3 : nearByBabyGhasts.size() - 1;
            return nearByBabyGhasts.size() < 4;
        }

        public void m_8037_() {
            this.owner.m_7292_(new MobEffectInstance((MobEffect)NDEffects.VAMPIRISM.get(), 165, this.effectLevel));
        }
    }

    private static class TranslateBabyGhastIntoGhastGoal
    extends Goal {
        private final BabyGhast babyGhast;
        private int timer = 0;

        public TranslateBabyGhastIntoGhastGoal(BabyGhast babyGhast) {
            this.babyGhast = babyGhast;
        }

        public boolean m_8036_() {
            Player nearestPlayer = this.babyGhast.m_9236_().m_45930_((Entity)this.babyGhast, 64.0);
            return (nearestPlayer != null || this.timer > 0) && !this.babyGhast.m_21824_();
        }

        public void m_8037_() {
            ++this.timer;
            if (this.timer >= 2400) {
                Level level = this.babyGhast.m_9236_();
                Ghast ghast = new Ghast(EntityType.f_20453_, level);
                ghast.m_146884_(this.babyGhast.m_20182_());
                level.m_7967_((Entity)ghast);
                this.babyGhast.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }
}

