/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.behavior;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.teamdurt.netherdungeons.block.ShroomglightBlock;
import com.teamdurt.netherdungeons.entity.custom.Truncus;
import com.teamdurt.netherdungeons.entity.move_control.TruncusMoveControl;
import com.teamdurt.netherdungeons.init.NDBlocks;
import com.teamdurt.netherdungeons.init.NDMemoryTypes;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class TruncusSuckShroomlight
extends Behavior<Truncus> {
    private static final ImmutableMap<TruncusSuckPose, Vec2> poseOffsets = ImmutableMap.of((Object)((Object)TruncusSuckPose.STANDING), (Object)new Vec2(1.0f, 0.0f), (Object)((Object)TruncusSuckPose.HOOKED), (Object)new Vec2(0.69f, -0.19f), (Object)((Object)TruncusSuckPose.STUCK), (Object)new Vec2(1.0f, 0.0f), (Object)((Object)TruncusSuckPose.NONE), (Object)new Vec2(1.0f, 0.0f));
    private static final float START_SUCK_SQR_DISTANCE = 1.35f;
    private static final double SUCK_LERP_DELTA = 0.5;
    private TruncusSuckPose pose;
    private TruncusSuckState state;
    private Direction direction;
    private BlockPos shroomlightPosition;
    private Vec3 targetPosition;
    private static final int FLY_TIME = 200;
    private static final int SUCK_TIME = 100;
    private int suckTicks = 0;
    private long endTime;

    public TruncusSuckShroomlight() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_IS_SATIATED.get()), (Object)MemoryStatus.VALUE_ABSENT), 0);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Truncus truncus) {
        if (this.pose == TruncusSuckPose.NONE) {
            this.setSuckPose(pLevel, truncus);
        }
        if (this.pose == TruncusSuckPose.NONE) {
            truncus.m_6274_().m_21936_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get());
        }
        return this.pose != TruncusSuckPose.NONE;
    }

    protected void start(ServerLevel pLevel, Truncus truncus, long pGameTime) {
        truncus.setFlying(true);
        truncus.setFlyNavigating(true);
        this.endTime = pGameTime + 200L;
        ((TruncusMoveControl)truncus.m_21566_()).setLocked(false);
        this.setSuckPose(pLevel, truncus);
        Vec2 offset = (Vec2)poseOffsets.get((Object)this.pose);
        assert (this.pose != TruncusSuckPose.NONE && offset != null);
        this.shroomlightPosition = (BlockPos)truncus.m_6274_().m_21952_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get()).get();
        if (this.direction == null) {
            truncus.m_6274_().m_21936_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get());
            this.m_22562_(pLevel, (LivingEntity)truncus, pGameTime);
            return;
        }
        this.targetPosition = this.shroomlightPosition.m_252807_().m_231075_(this.direction, (double)offset.f_82470_).m_231075_(Direction.UP, (double)(offset.f_82471_ - 0.5f));
        this.state = TruncusSuckState.GOING_TO;
    }

    protected boolean m_7773_(long pGameTime) {
        return pGameTime > this.endTime;
    }

    protected void tick(ServerLevel pLevel, Truncus truncus, long pGameTime) {
        if (pLevel.f_46443_) {
            return;
        }
        truncus.setFlying(true);
        if (!pLevel.m_8055_(this.shroomlightPosition).m_60713_((Block)NDBlocks.SHROOMGLIGHT.get()) || (Integer)pLevel.m_8055_(this.shroomlightPosition).m_61143_((Property)ShroomglightBlock.LIGHT_STAGE) == 0) {
            ((TruncusMoveControl)truncus.m_21566_()).setLocked(false);
            this.m_22562_(pLevel, (LivingEntity)truncus, pGameTime);
            return;
        }
        switch (this.state) {
            case GOING_TO: {
                if (this.pose == null || this.direction == null) break;
                truncus.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPosition, 1.0f, 0));
                truncus.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.shroomlightPosition));
                if (!(truncus.m_20238_(this.targetPosition) <= (double)1.35f)) break;
                this.state = TruncusSuckState.SUCKING;
                this.endTime = pGameTime + 200L;
                break;
            }
            case SUCKING: {
                ++this.suckTicks;
                if (this.suckTicks % 100 == 0) {
                    this.onSuckStage(pLevel, truncus, pGameTime);
                }
                Vec3 vec = truncus.m_20184_();
                truncus.m_20334_(vec.f_82479_, 0.0, vec.f_82481_);
                ((TruncusMoveControl)truncus.m_21566_()).setLocked(true);
                switch (this.pose) {
                    case HOOKED: {
                        truncus.setAnimationGroup(Truncus.AnimationGroup.SUCKING_HOOKED);
                        break;
                    }
                    case STUCK: {
                        truncus.setAnimationGroup(Truncus.AnimationGroup.SUCKING_STUCK);
                        break;
                    }
                    case STANDING: {
                        truncus.setAnimationGroup(Truncus.AnimationGroup.SUCKING_STANDING);
                    }
                }
                truncus.m_6274_().m_21936_(MemoryModuleType.f_26371_);
                truncus.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                Vec3 lerpedPos = truncus.m_20182_().m_165921_(this.targetPosition, 0.5);
                truncus.m_146884_(lerpedPos);
                Vec3 lookVector = this.shroomlightPosition.m_252807_().m_82546_(truncus.m_20182_()).m_82541_();
                truncus.m_146922_((float)Math.toDegrees(Math.atan2(-lookVector.f_82479_, lookVector.f_82481_)));
                truncus.m_146926_((float)Math.toDegrees(Math.atan2(lookVector.f_82480_, Math.sqrt(lookVector.f_82479_ * lookVector.f_82479_ + lookVector.f_82481_ * lookVector.f_82481_))));
            }
        }
    }

    protected void stop(ServerLevel pLevel, Truncus truncus, long pGameTime) {
        truncus.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        truncus.m_6274_().m_21936_(MemoryModuleType.f_26371_);
        truncus.m_6274_().m_21936_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get());
        truncus.setFlying(false);
        this.suckTicks = 0;
        switch (this.pose) {
            case HOOKED: {
                truncus.m_147240_(0.15f, -Math.sin((double)truncus.m_146908_() * Math.PI / 180.0), Math.cos((double)truncus.m_146908_() * Math.PI / 180.0));
                truncus.setAnimationGroup(Truncus.AnimationGroup.SUCKING_HOOKED_OUT);
                break;
            }
            case STUCK: {
                truncus.m_147240_(0.15f, -Math.sin((double)truncus.m_146908_() * Math.PI / 180.0), Math.cos((double)truncus.m_146908_() * Math.PI / 180.0));
                truncus.setAnimationGroup(Truncus.AnimationGroup.SUCKING_STUCK_OUT);
                break;
            }
            case STANDING: {
                truncus.setAnimationGroup(Truncus.AnimationGroup.SUCKING_STANDING_OUT);
            }
        }
        this.pose = TruncusSuckPose.NONE;
        this.state = TruncusSuckState.NONE;
    }

    private void onSuckStage(ServerLevel pLevel, Truncus truncus, long pGameTime) {
        truncus.incrementSatiation(1);
        pLevel.m_7731_(this.shroomlightPosition, (BlockState)pLevel.m_8055_(this.shroomlightPosition).m_61124_((Property)ShroomglightBlock.LIGHT_STAGE, (Comparable)Integer.valueOf(Math.max(0, (Integer)pLevel.m_8055_(this.shroomlightPosition).m_61143_((Property)ShroomglightBlock.LIGHT_STAGE) - 1))), 3);
    }

    protected boolean canStillUse(ServerLevel pLevel, Truncus pEntity, long pGameTime) {
        return true;
    }

    private void setSuckPose(ServerLevel pLevel, Truncus truncus) {
        BlockPos shroomlightPos = (BlockPos)truncus.m_6274_().m_21952_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get()).get();
        this.pose = TruncusSuckPose.NONE;
        if (!(pLevel.m_8055_(shroomlightPos.m_122012_()).m_60795_() || pLevel.m_8055_(shroomlightPos.m_122029_()).m_60795_() || pLevel.m_8055_(shroomlightPos.m_122019_()).m_60795_() || pLevel.m_8055_(shroomlightPos.m_122024_()).m_60795_())) {
            return;
        }
        for (Direction direction : this.getCheckDirectionsSequence(shroomlightPos, truncus.m_20183_())) {
            if (!pLevel.m_8055_(shroomlightPos.m_121945_(direction)).m_60795_()) continue;
            this.direction = direction;
            if (pLevel.m_8055_(shroomlightPos.m_121945_(direction).m_7494_()).m_60795_() && pLevel.m_8055_(shroomlightPos.m_121945_(direction).m_7495_()).m_60804_((BlockGetter)pLevel, shroomlightPos.m_121945_(direction).m_7495_())) {
                this.pose = TruncusSuckPose.STANDING;
                break;
            }
            if (pLevel.m_8055_(shroomlightPos.m_121945_(direction).m_7495_()).m_60795_() && pLevel.m_8055_(shroomlightPos.m_7495_()).m_60795_()) {
                this.pose = TruncusSuckPose.HOOKED;
                break;
            }
            if (!pLevel.m_8055_(shroomlightPos.m_121945_(direction).m_7495_()).m_60795_() || !pLevel.m_8055_(shroomlightPos.m_7495_()).m_60804_((BlockGetter)pLevel, shroomlightPos.m_7495_())) continue;
            this.pose = TruncusSuckPose.STUCK;
            break;
        }
    }

    private ImmutableList<Direction> getCheckDirectionsSequence(BlockPos shroomlightPos, BlockPos truncusPos) {
        double northDistance = truncusPos.m_123331_((Vec3i)shroomlightPos.m_122019_());
        double southDistance = truncusPos.m_123331_((Vec3i)shroomlightPos.m_122012_());
        double westDistance = truncusPos.m_123331_((Vec3i)shroomlightPos.m_122029_());
        double eastDistance = truncusPos.m_123331_((Vec3i)shroomlightPos.m_122024_());
        ImmutableList pairs = ImmutableList.of((Object)Pair.of((Object)Direction.NORTH, (Object)northDistance), (Object)Pair.of((Object)Direction.WEST, (Object)westDistance), (Object)Pair.of((Object)Direction.SOUTH, (Object)southDistance), (Object)Pair.of((Object)Direction.EAST, (Object)eastDistance));
        return ((ImmutableList)pairs.stream().sorted(Comparator.comparing(Pair::getSecond)).map(Pair::getFirst).collect(ImmutableList.toImmutableList())).reverse();
    }

    public static enum TruncusSuckPose {
        STANDING,
        HOOKED,
        STUCK,
        NONE;

    }

    public static enum TruncusSuckState {
        GOING_TO,
        SUCKING,
        NONE;

    }
}

