/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.behavior;

import com.google.common.collect.ImmutableMap;
import com.teamdurt.netherdungeons.entity.custom.Truncus;
import com.teamdurt.netherdungeons.entity.move_control.TruncusMoveControl;
import com.teamdurt.netherdungeons.init.NDMemoryTypes;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;

public class TruncusSleep
extends Behavior<Truncus> {
    private long endTime = 0L;
    private static final int SLEEP_TIME = 3000;
    private TruncusSleepState state;
    private BlockPos sleepPosition;
    private Vec3 targetPosition;

    public TruncusSleep() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_SLEEP_POSITION.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_IS_SATIATED.get()), (Object)MemoryStatus.VALUE_PRESENT), 1);
    }

    protected void start(ServerLevel pLevel, Truncus truncus, long pGameTime) {
        Optional opt = truncus.m_6274_().m_21952_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SLEEP_POSITION.get());
        if (opt.isEmpty()) {
            this.m_22562_(pLevel, (LivingEntity)truncus, pGameTime);
            return;
        }
        this.sleepPosition = (BlockPos)opt.get();
        this.targetPosition = this.sleepPosition.m_252807_().m_82492_(0.0, 0.5, 0.0);
        this.state = TruncusSleepState.GOING_TO;
        this.endTime = pGameTime + 1000L;
    }

    protected void tick(ServerLevel pLevel, Truncus truncus, long pGameTime) {
        switch (this.state) {
            case GOING_TO: {
                truncus.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(this.targetPosition, 1.0f, 0));
                truncus.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.sleepPosition));
                if (!(truncus.m_20238_(this.targetPosition) <= 0.4)) break;
                truncus.setFlying(false);
                truncus.setFlyNavigating(false);
                this.state = TruncusSleepState.SLEEPING;
                this.endTime = pGameTime + 3000L;
                truncus.setSleepTicksLeft(3000);
                break;
            }
            case SLEEPING: {
                truncus.decrementSleepTicksLeft(1);
                truncus.setAnimationGroup(Truncus.AnimationGroup.SITTING);
                truncus.m_6274_().m_21936_(MemoryModuleType.f_26371_);
                truncus.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                Vec3 motion = truncus.m_20184_();
                if (3000 - truncus.getSleepTicksLeft() > 30) {
                    ((TruncusMoveControl)truncus.m_21566_()).setLocked(true);
                    if (Math.pow(motion.f_82479_, 2.0) + Math.pow(motion.f_82481_, 2.0) > 0.0) {
                        this.m_22562_(pLevel, (LivingEntity)truncus, pGameTime);
                    }
                } else {
                    truncus.setFlying(false);
                    truncus.setFlyNavigating(false);
                }
                if (truncus.getSleepTicksLeft() > 0) break;
                this.m_22562_(pLevel, (LivingEntity)truncus, pGameTime);
            }
        }
    }

    protected boolean m_7773_(long pGameTime) {
        return pGameTime > this.endTime;
    }

    protected void stop(ServerLevel pLevel, Truncus truncus, long pGameTime) {
        super.m_6732_(pLevel, (LivingEntity)truncus, pGameTime);
        truncus.wakeUp();
        ((TruncusMoveControl)truncus.m_21566_()).setLocked(false);
    }

    protected boolean canStillUse(ServerLevel pLevel, Truncus pEntity, long pGameTime) {
        return true;
    }

    public static enum TruncusSleepState {
        GOING_TO,
        SLEEPING,
        NONE;

    }
}

