/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.behavior;

import com.google.common.collect.ImmutableMap;
import com.teamdurt.netherdungeons.entity.custom.PiglinThrower;
import com.teamdurt.netherdungeons.entity.custom.ThrownSporeshroom;
import com.teamdurt.netherdungeons.init.NDItems;
import com.teamdurt.netherdungeons.init.NDSounds;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SporeshroomThrowingAttack
extends Behavior<PiglinThrower> {
    private static final int MAX_DISTANCE = 10;
    private static final int MIN_DISTANCE = 3;
    private static final int DURATION = 20;
    private static final int COOLDOWN = 40;
    private static final int TAKE_ITEM_AFTER_TICKS = 7;
    private static final int THROW_AFTER_TICKS_FRONT = 11;
    private static final int THROW_AFTER_TICKS_BACK = 16;
    private boolean isBack = false;
    private int useTicks = 0;
    private SporeshroomThrowingAttackState attackState = SporeshroomThrowingAttackState.WAIT_FOR_ITEM;

    public SporeshroomThrowingAttack() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT), 20);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PiglinThrower piglinThrower) {
        double distance = piglinThrower.m_20270_((Entity)piglinThrower.m_6274_().m_21952_(MemoryModuleType.f_26372_).get());
        return distance >= 3.0 && distance <= 10.0;
    }

    protected boolean canStillUse(ServerLevel level, PiglinThrower piglinThrower, long l) {
        return piglinThrower.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(level, piglinThrower);
    }

    protected void start(ServerLevel level, PiglinThrower piglinThrower, long l) {
        this.useTicks = 0;
        this.attackState = SporeshroomThrowingAttackState.WAIT_FOR_ITEM;
        this.isBack = SporeshroomThrowingAttack.checkAttackIsBack(piglinThrower, (LivingEntity)piglinThrower.m_6274_().m_21952_(MemoryModuleType.f_26372_).get());
        piglinThrower.setRangeAttackBack(this.isBack);
        piglinThrower.setRangeAttacking(true);
        piglinThrower.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, 20L);
    }

    protected void tick(ServerLevel level, PiglinThrower piglinThrower, long l) {
        ++this.useTicks;
        Brain<PiglinThrower> brain = piglinThrower.m_6274_();
        LivingEntity attackTarget = (LivingEntity)brain.m_21952_(MemoryModuleType.f_26372_).get();
        if (!this.isBack) {
            piglinThrower.m_21563_().m_148051_((Entity)attackTarget);
        }
        switch (this.attackState) {
            case WAIT_FOR_ITEM: {
                if (this.useTicks < 7) break;
                this.attackState = SporeshroomThrowingAttackState.TAKE_ITEM;
                break;
            }
            case TAKE_ITEM: {
                piglinThrower.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)NDItems.SPORESHROOM.get()));
                this.attackState = SporeshroomThrowingAttackState.WAIT_FOR_THROW;
                break;
            }
            case WAIT_FOR_THROW: {
                if (this.useTicks < (this.isBack ? 16 : 11)) break;
                this.attackState = SporeshroomThrowingAttackState.THROW;
                break;
            }
            case THROW: {
                piglinThrower.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                Vec3 deltaMovement = attackTarget.m_20184_();
                double d0 = attackTarget.m_20185_() + deltaMovement.f_82479_ + (this.isBack ? -deltaMovement.f_82481_ : deltaMovement.f_82481_) - piglinThrower.m_20185_();
                double d1 = attackTarget.m_20188_() - (double)1.1f - piglinThrower.m_20186_();
                double d2 = attackTarget.m_20189_() + deltaMovement.f_82481_ + (this.isBack ? deltaMovement.f_82479_ : -deltaMovement.f_82479_) - piglinThrower.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                ThrownSporeshroom thrownSporeshroom = new ThrownSporeshroom((Level)level, (LivingEntity)piglinThrower);
                thrownSporeshroom.m_6686_(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
                thrownSporeshroom.m_6034_(thrownSporeshroom.m_20185_() + (this.isBack ? thrownSporeshroom.m_20184_().f_82481_ : -thrownSporeshroom.m_20184_().f_82481_), thrownSporeshroom.m_20186_(), thrownSporeshroom.m_20189_() + (this.isBack ? -thrownSporeshroom.m_20184_().f_82479_ : thrownSporeshroom.m_20184_().f_82479_));
                level.m_7967_((Entity)thrownSporeshroom);
                piglinThrower.m_216990_((SoundEvent)NDSounds.THROWING_SPORESHROOM.get());
                this.attackState = SporeshroomThrowingAttackState.FINAL;
            }
        }
    }

    protected void stop(ServerLevel level, PiglinThrower piglinThrower, long l) {
        this.useTicks = 0;
        piglinThrower.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        piglinThrower.setRangeAttacking(false);
        SporeshroomThrowingAttack.setCooldown((LivingEntity)piglinThrower, 40);
    }

    public static boolean checkAttackIsBack(PiglinThrower piglinThrower, LivingEntity target) {
        double iz;
        double zRot;
        double rotDelta = Math.abs(piglinThrower.m_146908_() - target.m_146908_());
        if (rotDelta > 90.0 && rotDelta < 270.0) {
            return false;
        }
        double ix = piglinThrower.m_20185_() - target.m_20185_();
        double xRot = piglinThrower.m_20184_().f_82479_ * ix;
        double i = xRot + (zRot = piglinThrower.m_20184_().f_82481_ * (iz = piglinThrower.m_20189_() - target.m_20189_()));
        return i > 0.0;
    }

    public static void setCooldown(LivingEntity entity, int cooldown) {
        entity.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)cooldown);
    }

    public static enum SporeshroomThrowingAttackState {
        WAIT_FOR_ITEM,
        TAKE_ITEM,
        WAIT_FOR_THROW,
        THROW,
        FINAL;

    }
}

