/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;

public class SetWalkTargetFromAttackTargetToDistanceIfNotInRange<E extends Mob>
extends Behavior<E> {
    private final float speedModifier;
    private final double minDistance;
    private final double maxDistance;
    private final double targetDistance;

    public SetWalkTargetFromAttackTargetToDistanceIfNotInRange(float speedModifier, double minDistance, double maxDistance) {
        this(speedModifier, minDistance, maxDistance, (minDistance + maxDistance) / 2.0);
    }

    public SetWalkTargetFromAttackTargetToDistanceIfNotInRange(float speedModifier, double minDistance, double maxDistance, double targetDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), 1);
        this.speedModifier = speedModifier;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.targetDistance = targetDistance;
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, E mob) {
        float distance = ((LivingEntity)mob.m_6274_().m_21952_(MemoryModuleType.f_26372_).get()).m_20270_(mob);
        return (double)distance > this.maxDistance || (double)distance < this.minDistance;
    }

    protected boolean canStillUse(ServerLevel level, E mob, long l) {
        return mob.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(level, mob);
    }

    protected void start(ServerLevel level, E mob, long l) {
        LivingEntity targetEntity = (LivingEntity)mob.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        double d = Math.sqrt(Math.pow(mob.m_20185_() - targetEntity.m_20185_(), 2.0) + Math.pow(mob.m_20189_() - targetEntity.m_20189_(), 2.0));
        double targetX = targetEntity.m_20185_() + (mob.m_20185_() - targetEntity.m_20185_()) / d * this.targetDistance;
        double targetZ = targetEntity.m_20189_() + (mob.m_20189_() - targetEntity.m_20189_()) / d * this.targetDistance;
        mob.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)targetEntity, true));
        mob.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(new Vec3(targetX, targetEntity.m_20186_(), targetZ), this.speedModifier, 1));
    }
}

