/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.behavior;

import com.google.common.collect.ImmutableMap;
import com.teamdurt.netherdungeons.entity.custom.PiglinThrower;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PiglinThrowerMeleeAttack
extends Behavior<PiglinThrower> {
    private static final int DURATION = 20;
    private static final int COOLDOWN = 20;
    private static final int FIRST_HIT_TIME = 7;
    private static final int SECOND_HIT_TIME = 11;
    private static final int ATTACK_RADIUS = 3;
    private int useTicks = 0;
    private PiglinThrowerMeleeAttackState attackState = PiglinThrowerMeleeAttackState.WAIT_FOR_FIRST;

    public PiglinThrowerMeleeAttack() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT), 20);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, PiglinThrower piglinThrower) {
        LivingEntity attackTarget = (LivingEntity)piglinThrower.m_6274_().m_21952_(MemoryModuleType.f_26372_).get();
        return piglinThrower.m_216992_((Entity)attackTarget, 3.0, 2.0) && ((NearestVisibleLivingEntities)piglinThrower.m_6274_().m_21952_(MemoryModuleType.f_148205_).get()).m_186107_(attackTarget);
    }

    protected boolean canStillUse(ServerLevel level, PiglinThrower piglinThrower, long l) {
        return true;
    }

    protected void start(ServerLevel level, PiglinThrower piglinThrower, long l) {
        this.useTicks = 0;
        this.attackState = PiglinThrowerMeleeAttackState.WAIT_FOR_FIRST;
        piglinThrower.setMeleeAttacking(true);
        piglinThrower.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, 20L);
    }

    protected void tick(ServerLevel level, PiglinThrower piglinThrower, long l) {
        ++this.useTicks;
        Brain<PiglinThrower> brain = piglinThrower.m_6274_();
        switch (this.attackState) {
            case WAIT_FOR_FIRST: {
                if (this.useTicks < 7) break;
                this.attackState = PiglinThrowerMeleeAttackState.FIRST_HIT;
                break;
            }
            case FIRST_HIT: {
                List entitiesToHurt = level.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)piglinThrower.m_20182_(), (double)6.0, (double)2.0, (double)6.0), entity -> entity != piglinThrower);
                entitiesToHurt.forEach(piglinThrower::m_7327_);
                this.attackState = PiglinThrowerMeleeAttackState.WAIT_FOR_SECOND;
                break;
            }
            case WAIT_FOR_SECOND: {
                if (this.useTicks < 11) break;
                this.attackState = PiglinThrowerMeleeAttackState.SECOND_HIT;
                break;
            }
            case SECOND_HIT: {
                List entitiesToHurt = level.m_6443_(LivingEntity.class, AABB.m_165882_((Vec3)piglinThrower.m_20182_(), (double)6.0, (double)3.0, (double)6.0), entity -> entity != piglinThrower);
                entitiesToHurt.forEach(piglinThrower::m_7327_);
                this.attackState = PiglinThrowerMeleeAttackState.FINAL;
            }
        }
    }

    protected void stop(ServerLevel level, PiglinThrower piglinThrower, long l) {
        this.useTicks = 0;
        piglinThrower.setMeleeAttacking(false);
        PiglinThrowerMeleeAttack.setCooldown((LivingEntity)piglinThrower, 20);
    }

    public static void setCooldown(LivingEntity entity, int cooldown) {
        entity.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)cooldown);
    }

    public static enum PiglinThrowerMeleeAttackState {
        WAIT_FOR_FIRST,
        FIRST_HIT,
        WAIT_FOR_SECOND,
        SECOND_HIT,
        FINAL;

    }
}

