/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.teamdurt.netherdungeons.block.ShroomglightBlock;
import com.teamdurt.netherdungeons.entity.behavior.TruncusSleep;
import com.teamdurt.netherdungeons.entity.behavior.TruncusSuckShroomlight;
import com.teamdurt.netherdungeons.entity.custom.Truncus;
import com.teamdurt.netherdungeons.entity.move_control.TruncusMoveControl;
import com.teamdurt.netherdungeons.init.NDActivities;
import com.teamdurt.netherdungeons.init.NDBlocks;
import com.teamdurt.netherdungeons.init.NDMemoryTypes;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class TruncusAi {
    private static final long SCAN_FREQUENCY = 160L;
    private static final int HORIZONTAL_RANGE = 16;
    private static final int VERTICAL_RANGE = 16;

    public static Brain<?> makeBrain(Truncus truncus, Brain<Truncus> brain) {
        TruncusAi.initCoreActivity(truncus, brain);
        TruncusAi.initIdleActivity(truncus, brain);
        TruncusAi.initSuckActivity(truncus, brain);
        TruncusAi.initSleepActivity(truncus, brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Truncus truncus, Brain<Truncus> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Truncus truncus, Brain<Truncus> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of(TruncusAi.createIdleLookBehaviors(), TruncusAi.createIdleMovementBehaviors()));
    }

    private static void initSuckActivity(Truncus truncus, Brain<Truncus> brain) {
        brain.m_21903_((Activity)NDActivities.SUCK.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new TruncusSuckShroomlight()))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get()), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initSleepActivity(Truncus truncus, Brain<Truncus> brain) {
        brain.m_21903_((Activity)NDActivities.SLEEP.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new TruncusSleep()))), (Set)ImmutableSet.of((Object)Pair.of((Object)((MemoryModuleType)NDMemoryTypes.TRUNCUS_SLEEP_POSITION.get()), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static RunOne<Truncus> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<Truncus> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.6f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(Truncus truncus) {
        ServerLevel level = (ServerLevel)truncus.m_9236_();
        if (level.m_46467_() >= truncus.getLastScanTime() + 160L) {
            BlockPos sleepPos;
            truncus.setLastScanTime(level.m_46467_());
            if (truncus.shouldTryToSleep(level) && truncus.m_6274_().m_21876_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SLEEP_POSITION.get(), MemoryStatus.VALUE_ABSENT) && (sleepPos = TruncusAi.searchForSleepPos(truncus, level)) != null) {
                truncus.m_6274_().m_21879_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SLEEP_POSITION.get(), (Object)sleepPos);
            }
            if (truncus.shouldTryToSuck(level) && truncus.m_6274_().m_21876_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get(), MemoryStatus.VALUE_ABSENT)) {
                boolean flying = truncus.isFlying();
                boolean flyNavigating = truncus.isFlyNavigating();
                truncus.setFlying(true);
                truncus.setFlyNavigating(true);
                BlockPos suckPos = TruncusAi.searchForSuckPos(truncus, level);
                if (suckPos != null) {
                    truncus.m_6274_().m_21879_((MemoryModuleType)NDMemoryTypes.TRUNCUS_SHROOMLIGHT_POSITION.get(), (Object)suckPos);
                }
                truncus.setFlying(flying);
                truncus.setFlyNavigating(flyNavigating);
            }
        }
        truncus.m_6274_().m_21926_((List)ImmutableList.of((Object)((Activity)NDActivities.SLEEP.get()), (Object)((Activity)NDActivities.SUCK.get()), (Object)Activity.f_37979_));
    }

    private static BlockPos searchForSleepPos(Truncus truncus, ServerLevel pLevel) {
        BlockPos blockpos = truncus.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int k = 0;
        while (k <= 16) {
            for (int l = 0; l < 16; ++l) {
                int i = 0;
                while (i <= l) {
                    int j;
                    int n = j = i < l && i > -l ? l : 0;
                    while (j <= l) {
                        mutableBlockPos.m_122154_((Vec3i)blockpos, i, k, j);
                        if (Block.m_49863_((LevelReader)pLevel, (BlockPos)mutableBlockPos, (Direction)Direction.DOWN) && pLevel.m_8055_((BlockPos)mutableBlockPos).m_60838_((BlockGetter)pLevel, (BlockPos)mutableBlockPos) && pLevel.m_8055_(mutableBlockPos.m_7494_()).m_60795_() && ((TruncusMoveControl)truncus.m_21566_()).canReach(mutableBlockPos.m_7494_())) {
                            return mutableBlockPos.m_7494_();
                        }
                        j = j > 0 ? -j : 1 - j;
                    }
                    i = i > 0 ? -i : 1 - i;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return null;
    }

    private static BlockPos searchForSuckPos(Truncus truncus, ServerLevel pLevel) {
        BlockPos blockpos = truncus.m_20183_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122190_((Vec3i)blockpos);
        int length = 0;
        BlockPos block = TruncusAi.checkYSuckAbility(truncus, (Level)pLevel, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_(), mutableBlockPos.m_123342_());
        if (block != null) {
            return block;
        }
        while (mutableBlockPos.m_123341_() >= blockpos.m_123341_() - 8 && mutableBlockPos.m_123343_() <= blockpos.m_123343_() + 8) {
            int z;
            int x;
            ++length;
            for (x = 0; x <= length; ++x) {
                mutableBlockPos.m_122184_(1, 0, 0);
                block = TruncusAi.checkYSuckAbility(truncus, (Level)pLevel, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_(), mutableBlockPos.m_123342_());
                if (block == null) continue;
                return block;
            }
            for (z = 0; z <= length; ++z) {
                mutableBlockPos.m_122184_(0, 0, -1);
                block = TruncusAi.checkYSuckAbility(truncus, (Level)pLevel, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_(), mutableBlockPos.m_123342_());
                if (block == null) continue;
                return block;
            }
            ++length;
            for (x = 0; x <= length; ++x) {
                mutableBlockPos.m_122184_(-1, 0, 0);
                block = TruncusAi.checkYSuckAbility(truncus, (Level)pLevel, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_(), mutableBlockPos.m_123342_());
                if (block == null) continue;
                return block;
            }
            for (z = 0; z <= length; ++z) {
                mutableBlockPos.m_122184_(0, 0, 1);
                block = TruncusAi.checkYSuckAbility(truncus, (Level)pLevel, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_(), mutableBlockPos.m_123342_());
                if (block == null) continue;
                return block;
            }
        }
        return null;
    }

    @Nullable
    private static BlockPos checkYSuckAbility(Truncus truncus, Level level, int x, int z, int startHeight) {
        for (int yOffset = 0; yOffset < 8; ++yOffset) {
            BlockPos checkPos = new BlockPos(x, startHeight + yOffset, z);
            if (TruncusAi.checkPosSuckAbility(truncus, level, checkPos)) {
                return checkPos;
            }
            BlockPos reversedCheckPos = new BlockPos(x, startHeight - yOffset, z);
            if (!TruncusAi.checkPosSuckAbility(truncus, level, reversedCheckPos)) continue;
            return reversedCheckPos;
        }
        return null;
    }

    private static boolean checkPosSuckAbility(Truncus truncus, Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)NDBlocks.SHROOMGLIGHT.get()) && (Integer)level.m_8055_(pos).m_61143_((Property)ShroomglightBlock.LIGHT_STAGE) > 0 && ((TruncusMoveControl)truncus.m_21566_()).canReach(pos);
    }
}

