/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.teamdurt.netherdungeons.entity.behavior.PiglinThrowerMeleeAttack;
import com.teamdurt.netherdungeons.entity.behavior.SetWalkTargetFromAttackTargetToDistanceIfNotInRange;
import com.teamdurt.netherdungeons.entity.behavior.SporeshroomThrowingAttack;
import com.teamdurt.netherdungeons.entity.custom.PiglinThrower;
import com.teamdurt.netherdungeons.init.NDEntityTypes;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.StrollAroundPoi;
import net.minecraft.world.entity.ai.behavior.StrollToPoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.schedule.Activity;

public class PiglinThrowerAi {
    public static Brain<?> makeBrain(PiglinThrower piglinThrower, Brain<PiglinThrower> brain) {
        PiglinThrowerAi.initCoreActivity(piglinThrower, brain);
        PiglinThrowerAi.initIdleActivity(piglinThrower, brain);
        PiglinThrowerAi.initFightActivity(piglinThrower, brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void initMemories(PiglinThrower piglinThrower) {
        GlobalPos globalpos = GlobalPos.m_122643_((ResourceKey)piglinThrower.m_9236_().m_46472_(), (BlockPos)piglinThrower.m_20183_());
        piglinThrower.m_6274_().m_21879_(MemoryModuleType.f_26359_, (Object)globalpos);
    }

    private static void initCoreActivity(PiglinThrower piglinThrower, Brain<PiglinThrower> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)InteractWithDoor.m_257893_(), (Object)StopBeingAngryIfTargetDead.m_257993_()));
    }

    private static void initIdleActivity(PiglinThrower piglinThrower, Brain<PiglinThrower> brain) {
        brain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257710_(PiglinThrowerAi::findNearestValidAttackTarget), PiglinThrowerAi.createIdleLookBehaviors(), PiglinThrowerAi.createIdleMovementBehaviors(), (Object)SetLookAndInteract.m_257430_((EntityType)EntityType.f_20532_, (int)4)));
    }

    private static void initFightActivity(PiglinThrower piglinThrower, Brain<PiglinThrower> brain) {
        brain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257990_(p_35118_ -> !PiglinThrowerAi.isNearestValidAttackTarget(piglinThrower, p_35118_)), new SetWalkTargetFromAttackTargetToDistanceIfNotInRange(1.15f, 5.0, 9.0), (Object)((Object)new PiglinThrowerMeleeAttack()), (Object)((Object)new SporeshroomThrowingAttack())), MemoryModuleType.f_26372_);
    }

    private static RunOne<PiglinThrower> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20511_, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20512_, (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)NDEntityTypes.PIGLIN_THROWER.get()), (float)8.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.m_257660_((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<PiglinThrower> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.m_258079_((EntityType)EntityType.f_20511_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.m_258079_((EntityType)EntityType.f_20512_, (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)InteractWith.m_258079_((EntityType)((EntityType)NDEntityTypes.PIGLIN_THROWER.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)StrollToPoi.m_258086_((MemoryModuleType)MemoryModuleType.f_26359_, (float)0.6f, (int)2, (int)100), (Object)2), (Object)Pair.of((Object)StrollAroundPoi.m_257894_((MemoryModuleType)MemoryModuleType.f_26359_, (float)0.6f, (int)5), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(PiglinThrower piglinThrower) {
        Brain<PiglinThrower> brain = piglinThrower.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37979_));
        Activity activity1 = brain.m_21968_().orElse(null);
        if (activity != activity1) {
            PiglinThrowerAi.playActivitySound(piglinThrower);
        }
        piglinThrower.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }

    private static boolean isNearestValidAttackTarget(AbstractPiglin piglin, LivingEntity entity) {
        return PiglinThrowerAi.findNearestValidAttackTarget(piglin).filter(target -> target == entity).isPresent();
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(AbstractPiglin piglin) {
        Optional angryAt = BehaviorUtils.m_22610_((LivingEntity)piglin, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (angryAt.isPresent() && Sensor.m_182377_((LivingEntity)piglin, (LivingEntity)((LivingEntity)angryAt.get()))) {
            return angryAt;
        }
        Optional nearestVisibleNemesis = piglin.m_6274_().m_21952_(MemoryModuleType.f_26333_);
        if (nearestVisibleNemesis.isPresent()) {
            return nearestVisibleNemesis;
        }
        Optional<? extends LivingEntity> nearestTargetablePlayerNotWearingGold = PiglinThrowerAi.getTargetIfWithinRange(piglin, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.f_26345_, 20.0);
        return nearestTargetablePlayerNotWearingGold.isPresent() && Sensor.m_148312_((LivingEntity)piglin, (LivingEntity)nearestTargetablePlayerNotWearingGold.get()) ? nearestTargetablePlayerNotWearingGold : Optional.empty();
    }

    private static Optional<? extends LivingEntity> getTargetIfWithinRange(AbstractPiglin piglin, MemoryModuleType<? extends LivingEntity> memoryModuleType, double range) {
        return piglin.m_6274_().m_21952_(memoryModuleType).filter(p_35108_ -> p_35108_.m_19950_((Entity)piglin, range));
    }

    protected static void setAngerTarget(AbstractPiglin piglinThrower, LivingEntity entity) {
        piglinThrower.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        piglinThrower.m_6274_().m_21882_(MemoryModuleType.f_26334_, (Object)entity.m_20148_(), 600L);
    }

    public static void wasHurtBy(PiglinThrower piglinThrower, LivingEntity entity) {
        if (!(entity instanceof AbstractPiglin)) {
            PiglinThrowerAi.maybeRetaliate(piglinThrower, entity);
        }
    }

    protected static void maybeRetaliate(PiglinThrower piglin, LivingEntity livingEntity) {
        if (!piglin.m_6274_().m_21954_(Activity.f_37991_) && Sensor.m_182377_((LivingEntity)piglin, (LivingEntity)livingEntity) && !BehaviorUtils.m_22598_((LivingEntity)piglin, (LivingEntity)livingEntity, (double)4.0)) {
            PiglinThrowerAi.setAngerTarget(piglin, livingEntity);
            PiglinThrowerAi.broadcastAngerTarget(piglin, livingEntity);
        }
    }

    protected static void broadcastAngerTarget(AbstractPiglin piglin, LivingEntity entity) {
        PiglinThrowerAi.getAdultPiglins(piglin).forEach(p_289474_ -> {
            if (entity.m_6095_() != EntityType.f_20456_) {
                PiglinThrowerAi.setAngerTargetIfCloserThanCurrent(p_289474_, entity);
            }
        });
    }

    private static List<AbstractPiglin> getAdultPiglins(AbstractPiglin piglin) {
        return (List)piglin.m_6274_().m_21952_(MemoryModuleType.f_26346_).orElse(ImmutableList.of());
    }

    private static void setAngerTargetIfCloserThanCurrent(AbstractPiglin piglin, LivingEntity entity) {
        Optional<LivingEntity> optional = PiglinThrowerAi.getAngerTarget(piglin);
        LivingEntity livingentity = BehaviorUtils.m_22625_((LivingEntity)piglin, optional, (LivingEntity)entity);
        if (!optional.isPresent() || optional.get() != livingentity) {
            PiglinThrowerAi.setAngerTarget(piglin, livingentity);
        }
    }

    private static Optional<LivingEntity> getAngerTarget(AbstractPiglin piglin) {
        return BehaviorUtils.m_22610_((LivingEntity)piglin, (MemoryModuleType)MemoryModuleType.f_26334_);
    }

    public static void maybePlayActivitySound(PiglinThrower piglinThrower) {
        if ((double)piglinThrower.m_9236_().f_46441_.m_188501_() < 0.0125) {
            PiglinThrowerAi.playActivitySound(piglinThrower);
        }
    }

    private static void playActivitySound(PiglinThrower piglinThrower) {
        piglinThrower.m_6274_().m_21968_().ifPresent(p_35104_ -> {
            if (p_35104_ == Activity.f_37988_) {
                piglinThrower.playAngrySound();
            }
        });
    }
}

