/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.teamdurt.netherdungeons.entity.custom.HoglinBrute;
import com.teamdurt.netherdungeons.init.NDEntityTypes;
import com.teamdurt.netherdungeons.init.NDMemoryTypes;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.schedule.Activity;

public class HoglinBruteAi {
    private static final int ATTACK_DURATION = 200;
    private static final int ATTACK_INTERVAL = 40;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.4f;

    public static Brain<?> makeBrain(Brain<HoglinBrute> brain) {
        HoglinBruteAi.initCoreActivity(brain);
        HoglinBruteAi.initIdleActivity(brain);
        HoglinBruteAi.initFightActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    private static void initCoreActivity(Brain<HoglinBrute> pBrain) {
        pBrain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initIdleActivity(Brain<HoglinBrute> pBrain) {
        pBrain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)BecomePassiveIfMemoryPresent.m_257393_((MemoryModuleType)MemoryModuleType.f_26356_, (int)200), (Object)SetWalkTargetAwayFrom.m_257620_((MemoryModuleType)MemoryModuleType.f_26356_, (float)1.0f, (int)8, (boolean)true), (Object)StartAttacking.m_257710_(HoglinBruteAi::findNearestValidAttackTarget), (Object)SetEntityLookTargetSometimes.m_257458_((float)8.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), HoglinBruteAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<HoglinBrute> pBrain) {
        pBrain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)BecomePassiveIfMemoryPresent.m_257393_((MemoryModuleType)MemoryModuleType.f_26356_, (int)200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)MeleeAttack.m_257733_((int)40), (Object)StopAttackingIfTargetInvalid.m_257822_()), MemoryModuleType.f_26372_);
    }

    private static RunOne<HoglinBrute> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.4f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.4f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(HoglinBrute hoglinBrute) {
        Brain<HoglinBrute> brain = hoglinBrute.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)Activity.f_37988_, (Object)Activity.f_37991_, (Object)Activity.f_37979_));
        Activity activity1 = brain.m_21968_().orElse(null);
        if (activity != activity1) {
            HoglinBruteAi.getSoundForCurrentActivity(hoglinBrute).ifPresent(hoglinBrute::playSoundEvent);
        }
        hoglinBrute.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
    }

    public static void wasHurtBy(HoglinBrute hoglinBrute, LivingEntity pLivingEntity) {
        Brain<HoglinBrute> brain = hoglinBrute.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26357_);
        HoglinBruteAi.maybeRetaliate(hoglinBrute, pLivingEntity);
    }

    private static void maybeRetaliate(HoglinBrute hoglinBrute, LivingEntity pLivingEntity) {
        if (pLivingEntity.m_6095_() != EntityType.f_20456_ && pLivingEntity.m_6095_() != NDEntityTypes.HOGLIN_BRUTE.get() && !BehaviorUtils.m_22598_((LivingEntity)hoglinBrute, (LivingEntity)pLivingEntity, (double)4.0) && Sensor.m_148312_((LivingEntity)hoglinBrute, (LivingEntity)pLivingEntity)) {
            HoglinBruteAi.setAttackTarget(hoglinBrute, pLivingEntity);
            HoglinBruteAi.broadcastAttackTarget(hoglinBrute, pLivingEntity);
        }
    }

    private static void setAttackTarget(HoglinBrute hoglinBrute, LivingEntity pTarget) {
        Brain<HoglinBrute> brain = hoglinBrute.m_6274_();
        brain.m_21936_(MemoryModuleType.f_26326_);
        brain.m_21882_(MemoryModuleType.f_26372_, (Object)pTarget, 200L);
    }

    private static void broadcastAttackTarget(HoglinBrute hoglinBrute, LivingEntity pTarget) {
        HoglinBruteAi.getVisibleBruteHoglins(hoglinBrute).forEach(p_34574_ -> HoglinBruteAi.setAttackTargetIfCloserThanCurrent(p_34574_, pTarget));
    }

    private static void setAttackTargetIfCloserThanCurrent(HoglinBrute hoglinBrute, LivingEntity pTarget) {
        if (!HoglinBruteAi.isPacified(hoglinBrute)) {
            Optional optional = hoglinBrute.m_6274_().m_21952_(MemoryModuleType.f_26372_);
            LivingEntity livingentity = BehaviorUtils.m_22625_((LivingEntity)hoglinBrute, (Optional)optional, (LivingEntity)pTarget);
            HoglinBruteAi.setAttackTarget(hoglinBrute, livingentity);
        }
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(HoglinBrute hoglinBrute) {
        return !HoglinBruteAi.isPacified(hoglinBrute) ? hoglinBrute.m_6274_().m_21952_(MemoryModuleType.f_148206_) : Optional.empty();
    }

    protected static boolean isPacified(HoglinBrute pHoglin) {
        return pHoglin.m_6274_().m_21874_(MemoryModuleType.f_26357_);
    }

    private static List<HoglinBrute> getVisibleBruteHoglins(HoglinBrute hoglinBrute) {
        return (List)hoglinBrute.m_6274_().m_21952_((MemoryModuleType)NDMemoryTypes.NEAREST_VISIBLE_BRUTE_HOGLINS.get()).orElse(ImmutableList.of());
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(HoglinBrute hoglinBrute) {
        return hoglinBrute.m_6274_().m_21968_().map(activity -> HoglinBruteAi.getSoundForActivity(hoglinBrute, activity));
    }

    private static SoundEvent getSoundForActivity(HoglinBrute hoglinBrute, Activity pActivity) {
        if (!hoglinBrute.isConverting()) {
            if (pActivity == Activity.f_37988_) {
                return SoundEvents.f_11957_;
            }
            return SoundEvents.f_11956_;
        }
        return SoundEvents.f_11962_;
    }

    public static void onHitTarget(HoglinBrute pHoglin, LivingEntity pTarget) {
        HoglinBruteAi.broadcastAttackTarget(pHoglin, pTarget);
    }
}

