/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.block;

import com.teamdurt.netherdungeons.init.NDBlockTags;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagmaNetherBricksBlock
extends Block {
    public static final BooleanProperty DESTROYED = BooleanProperty.m_61465_((String)"destroyed");

    public MagmaNetherBricksBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DESTROYED, (Comparable)Boolean.valueOf(false)));
    }

    private boolean isDestroyed(LevelAccessor level, BlockPos blockPos) {
        BlockState aboveState = level.m_8055_(blockPos.m_7494_());
        return !aboveState.m_204336_(NDBlockTags.MAGMA_NETHER_BRICKS) || !Block.m_49863_((LevelReader)level, (BlockPos)blockPos.m_7494_(), (Direction)Direction.DOWN);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DESTROYED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean destroyed = this.isDestroyed((LevelAccessor)context.m_43725_(), context.m_8083_());
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)DESTROYED, (Comparable)Boolean.valueOf(destroyed));
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pPos, @NotNull BlockPos pNeighborPos) {
        BlockState targetState = super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
        if (pDirection != Direction.UP) {
            return targetState;
        }
        boolean destroyed = this.isDestroyed(pLevel, pPos);
        return (BlockState)targetState.m_61124_((Property)DESTROYED, (Comparable)Boolean.valueOf(destroyed));
    }
}

