/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.block;

import com.google.common.collect.ImmutableMap;
import com.teamdurt.netherdungeons.init.NDBlockTags;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class MagmaNetherBrickWallBlock
extends WallBlock {
    public static final BooleanProperty DESTROYED = BooleanProperty.m_61465_((String)"destroyed");
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;

    public MagmaNetherBrickWallBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)DESTROYED, (Comparable)Boolean.valueOf(true)));
        this.shapeByIndex = this.m_57965_(4.0f, 3.0f, 16.0f, 0.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.m_57965_(4.0f, 3.0f, 24.0f, 0.0f, 24.0f, 24.0f);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DESTROYED});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeByIndex.get(pState);
    }

    @NotNull
    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.collisionShapeByIndex.get(pState);
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        BlockState targetState = super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        if (pFacing != Direction.UP) {
            return targetState;
        }
        boolean destroyed = this.isDestroyed(pLevel, pCurrentPos);
        return (BlockState)targetState.m_61124_((Property)DESTROYED, (Comparable)Boolean.valueOf(destroyed));
    }

    private Map<BlockState, VoxelShape> m_57965_(float pWidth, float pDepth, float pWallPostHeight, float pWallMinY, float pWallLowHeight, float pWallTallHeight) {
        float f = 8.0f - pWidth;
        float f1 = 8.0f + pWidth;
        float f2 = 8.0f - pDepth;
        float f3 = 8.0f + pDepth;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)pWallPostHeight, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)pWallMinY, (double)0.0, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)pWallMinY, (double)f2, (double)f3, (double)pWallLowHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)pWallMinY, (double)f2, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)pWallMinY, (double)f2, (double)16.0, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape5 = Block.m_49796_((double)f2, (double)pWallMinY, (double)0.0, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape6 = Block.m_49796_((double)f2, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)pWallMinY, (double)f2, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape8 = Block.m_49796_((double)f2, (double)pWallMinY, (double)f2, (double)16.0, (double)pWallTallHeight, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean destroyed : DESTROYED.m_6908_()) {
            for (Boolean obool : f_57949_.m_6908_()) {
                for (WallSide wallside : f_57950_.m_6908_()) {
                    for (WallSide wallside1 : f_57951_.m_6908_()) {
                        for (WallSide wallside2 : f_57953_.m_6908_()) {
                            for (WallSide wallside3 : f_57952_.m_6908_()) {
                                VoxelShape voxelshape9 = Shapes.m_83040_();
                                voxelshape9 = MagmaNetherBrickWallBlock.m_58033_(voxelshape9, wallside, voxelshape4, voxelshape8);
                                voxelshape9 = MagmaNetherBrickWallBlock.m_58033_(voxelshape9, wallside2, voxelshape3, voxelshape7);
                                voxelshape9 = MagmaNetherBrickWallBlock.m_58033_(voxelshape9, wallside1, voxelshape1, voxelshape5);
                                voxelshape9 = MagmaNetherBrickWallBlock.m_58033_(voxelshape9, wallside3, voxelshape2, voxelshape6);
                                if (obool.booleanValue()) {
                                    voxelshape9 = Shapes.m_83110_((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                                }
                                BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_57949_, (Comparable)obool)).m_61124_((Property)f_57950_, (Comparable)wallside)).m_61124_((Property)f_57953_, (Comparable)wallside2)).m_61124_((Property)f_57951_, (Comparable)wallside1)).m_61124_((Property)f_57952_, (Comparable)wallside3)).m_61124_((Property)DESTROYED, (Comparable)destroyed);
                                builder.put((Object)((BlockState)blockstate.m_61124_((Property)f_57954_, (Comparable)Boolean.FALSE)), (Object)voxelshape9);
                                builder.put((Object)((BlockState)blockstate.m_61124_((Property)f_57954_, (Comparable)Boolean.TRUE)), (Object)voxelshape9);
                            }
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    private static VoxelShape m_58033_(VoxelShape pBaseShape, WallSide pHeight, VoxelShape pLowShape, VoxelShape pTallShape) {
        if (pHeight == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)pBaseShape, (VoxelShape)pTallShape);
        }
        return pHeight == WallSide.LOW ? Shapes.m_83110_((VoxelShape)pBaseShape, (VoxelShape)pLowShape) : pBaseShape;
    }

    private boolean isDestroyed(LevelAccessor level, BlockPos blockPos) {
        BlockState aboveState = level.m_8055_(blockPos.m_7494_());
        return !aboveState.m_204336_(NDBlockTags.MAGMA_NETHER_BRICKS) || !Block.m_49863_((LevelReader)level, (BlockPos)blockPos.m_7494_(), (Direction)Direction.DOWN);
    }
}

