/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.block;

import com.teamdurt.netherdungeons.init.NDBlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LuminophoreLanternBlock
extends Block {
    private static final VoxelShape ONE_LAMP_AABB = Block.m_49796_((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape TWO_LAMPS_AABB = Block.m_49796_((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape THREE_LAMPS_AABB = Block.m_49796_((double)2.0, (double)5.0, (double)4.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{ONE_LAMP_AABB, TWO_LAMPS_AABB, THREE_LAMPS_AABB};
    public static final IntegerProperty LAMPS = IntegerProperty.m_61631_((String)"lamps", (int)1, (int)3);

    public LuminophoreLanternBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAMPS, (Comparable)Integer.valueOf(1)));
    }

    public void m_6240_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pTe, @NotNull ItemStack pStack) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pTe, pStack);
        this.decreaseLamps(pLevel, pPos, pState);
    }

    public boolean m_6864_(@NotNull BlockState pState, BlockPlaceContext pUseContext) {
        return !pUseContext.m_7078_() && pUseContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)pState.m_61143_((Property)LAMPS) < 3 || super.m_6864_(pState, pUseContext);
    }

    private void decreaseLamps(Level pLevel, BlockPos pPos, BlockState pState) {
        int i = (Integer)pState.m_61143_((Property)LAMPS);
        if (i <= 1) {
            pLevel.m_46961_(pPos, false);
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)LAMPS, (Comparable)Integer.valueOf(i - 1)), 2);
            pLevel.m_220407_(GameEvent.f_157794_, pPos, GameEvent.Context.m_223722_((BlockState)pState));
            pLevel.m_46796_(2001, pPos, Block.m_49956_((BlockState)pState));
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)LAMPS, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)LAMPS) + 1))) : super.m_5573_(pContext);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPES[(Integer)pState.m_61143_((Property)LAMPS) - 1];
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LAMPS});
    }

    public boolean m_7898_(@NotNull BlockState pBlockState, @NotNull LevelReader pLevelRenderer, BlockPos pBlockPos) {
        return Block.m_49863_((LevelReader)pLevelRenderer, (BlockPos)pBlockPos.m_7494_(), (Direction)Direction.DOWN) && !pLevelRenderer.m_46801_(pBlockPos) && !pLevelRenderer.m_8055_(pBlockPos.m_7494_()).m_60713_((Block)this);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        boolean flag;
        boolean bl = flag = pDirection == Direction.UP && !this.m_7898_(pState, (LevelReader)pLevel, pPos);
        if (flag && !pLevel.m_5776_()) {
            for (int i = 1; i < (Integer)pState.m_61143_((Property)LAMPS); ++i) {
                LuminophoreLanternBlock.m_49840_((Level)((Level)pLevel), (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)NDBlocks.LUMINOPHORE_LANTERN.get()));
            }
        }
        return flag ? Blocks.f_50016_.m_49966_() : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }
}

