/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons;

import com.mojang.logging.LogUtils;
import com.teamdurt.netherdungeons.init.NDActivities;
import com.teamdurt.netherdungeons.init.NDBlockEntities;
import com.teamdurt.netherdungeons.init.NDBlocks;
import com.teamdurt.netherdungeons.init.NDCreativeModeTab;
import com.teamdurt.netherdungeons.init.NDEffects;
import com.teamdurt.netherdungeons.init.NDEnchantments;
import com.teamdurt.netherdungeons.init.NDEntityDataSerializers;
import com.teamdurt.netherdungeons.init.NDEntityTypes;
import com.teamdurt.netherdungeons.init.NDFeatures;
import com.teamdurt.netherdungeons.init.NDItemProperties;
import com.teamdurt.netherdungeons.init.NDItems;
import com.teamdurt.netherdungeons.init.NDLootModifiers;
import com.teamdurt.netherdungeons.init.NDMemoryTypes;
import com.teamdurt.netherdungeons.init.NDParticles;
import com.teamdurt.netherdungeons.init.NDSensorTypes;
import com.teamdurt.netherdungeons.init.NDSounds;
import com.teamdurt.netherdungeons.init.NDWoodTypes;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="netherdungeons")
public class NetherDungeons {
    public static final String MOD_ID = "netherdungeons";
    public static final Logger LOGGER = LogUtils.getLogger();

    public NetherDungeons() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        NDItems.register(modEventBus);
        NDBlocks.register(modEventBus);
        NDEntityTypes.register(modEventBus);
        NDActivities.register(modEventBus);
        NDBlockEntities.register(modEventBus);
        NDSounds.register(modEventBus);
        NDEffects.register(modEventBus);
        NDLootModifiers.register(modEventBus);
        NDFeatures.register(modEventBus);
        NDCreativeModeTab.register(modEventBus);
        NDParticles.register(modEventBus);
        NDEnchantments.register(modEventBus);
        NDMemoryTypes.register(modEventBus);
        NDSensorTypes.register(modEventBus);
        NDEntityDataSerializers.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::addCreative);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOGGER.info("Nether Dungeons mod init finished.");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ((FlowerPotBlock)Blocks.f_50276_).addPlant(NDBlocks.NEOFOLIA_SPROUT.getId(), NDBlocks.POTTED_NEOFOLIA_SPROUT));
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.m_246326_((ItemLike)NDItems.BABY_GHAST_SPAWN_EGG.get());
            event.m_246326_((ItemLike)NDItems.PIGLIN_THROWER_SPAWN_EGG.get());
            event.m_246326_((ItemLike)NDItems.ZOMBIFIED_PIGLIN_THROWER_SPAWN_EGG.get());
            event.m_246326_((ItemLike)NDItems.TRUNCUS_SPAWN_EGG.get());
            event.m_246326_((ItemLike)NDItems.HOGLIN_BRUTE_SPAWN_EGG.get());
        } else if (event.getTabKey() == CreativeModeTabs.f_256869_) {
            event.accept(NDItems.MUSIC_DISC_A_LONG_WAY);
        } else if (event.getTabKey() == CreativeModeTabs.f_256788_) {
            event.accept(NDBlocks.SHROOMGLIGHT);
            event.accept(NDBlocks.TEARY_FUNGUS);
            event.accept(NDBlocks.LUMINOPHORE_LANTERN);
            event.accept(NDBlocks.POLISHED_NETHERRACK);
            event.accept(NDBlocks.POLISHED_NETHERRACK_STAIRS);
            event.accept(NDBlocks.POLISHED_NETHERRACK_SLAB);
            event.accept(NDBlocks.CRACKED_POLISHED_NETHERRACK);
            event.accept(NDBlocks.CHISELED_POLISHED_NETHERRACK);
            event.accept(NDBlocks.NETHERRACK_PILLAR);
        } else if (event.getTabKey() == CreativeModeTabs.f_256839_) {
            event.accept(NDItems.HOGLIN_LEG);
            event.accept(NDItems.COOKED_HOGLIN_LEG);
        }
    }

    @Mod.EventBusSubscriber(modid="netherdungeons", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModeEvents {
        @SubscribeEvent
        public static void OnClientSetup(FMLClientSetupEvent event) {
            NDItemProperties.addCustomItemProperties();
            Sheets.addWoodType((WoodType)NDWoodTypes.GINGER);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)NDBlockEntities.GINGER_SIGN_BLOCK_ENTITY.get()), SignRenderer::new);
            BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)NDBlockEntities.GINGER_HANGING_SIGN_BLOCK_ENTITY.get()), HangingSignRenderer::new);
        }
    }
}

