/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.damagenumbers.client;

import dev.foxgirl.damagenumbers.DamageNumbers;
import dev.foxgirl.damagenumbers.client.Color;
import dev.foxgirl.damagenumbers.client.Config;
import dev.foxgirl.damagenumbers.client.ConfigScreenFactory;
import dev.foxgirl.damagenumbers.client.DamageNumbersHandler;
import dev.foxgirl.damagenumbers.client.TextParticle;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public final class DamageNumbersImpl
implements DamageNumbersHandler,
Config.PathProvider {
    @NotNull
    public final Config config = new Config();
    @NotNull
    public final Config configDefault = new Config();
    @NotNull
    public final Path configDirPath;
    private final Deque<TextParticle> particles = new ArrayDeque<TextParticle>();

    @Override
    @NotNull
    public Path getConfigFilePath() {
        return this.configDirPath.resolve("damagenumbers.json");
    }

    @Override
    @NotNull
    public Path getConfigTempPath() {
        return this.configDirPath.resolve("damagenumbers.json.tmp");
    }

    public DamageNumbersImpl(@NotNull Path configDir) {
        this.configDirPath = configDir;
        this.config.readConfig(this);
    }

    @Override
    @NotNull
    public Screen createConfigScreen(@NotNull Screen parent) {
        try {
            ConfigScreenFactory factory = (ConfigScreenFactory)Class.forName("dev.foxgirl.damagenumbers.client.ConfigScreenFactoryImpl").getConstructor(Config.class, Config.class, Config.PathProvider.class).newInstance(this.config, this.configDefault, this);
            return factory.createConfigScreen(parent);
        }
        catch (NoClassDefFoundError cause) {
            DamageNumbers.LOGGER.error("Failed to create config screen due to missing class", (Throwable)cause);
        }
        catch (ReflectiveOperationException cause) {
            DamageNumbers.LOGGER.error("Failed to create config screen due to reflection error", (Throwable)cause);
        }
        return new AlertScreen(() -> Minecraft.m_91087_().m_91152_(parent), Component.m_130674_((String)"Config screen unavailable"), Component.m_130674_((String)"YACL3 (Yet Another Config Library 3) may not be installed.\nPlease install a supported version to use the Damage Numbers config screen."));
    }

    @Override
    public void onEntityHealthChange(@NotNull LivingEntity entity, float oldHealth, float newHealth) {
        int particleLimit;
        if (!this.config.isEnabled) {
            return;
        }
        float damage = oldHealth - newHealth;
        if (damage <= 0.0f) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (entity == client.f_91074_ && !this.config.isPlayerDamageShown) {
            return;
        }
        ClientLevel world = client.f_91073_;
        if (world == null || world != entity.m_9236_()) {
            return;
        }
        if (entity.m_20280_((Entity)client.f_91074_) > 2304.0) {
            return;
        }
        switch ((ParticleStatus)client.f_91066_.m_231929_().m_231551_()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALL: {
                int n = 256;
                break;
            }
            case DECREASED: {
                int n = 64;
                break;
            }
            case MINIMAL: {
                int n = particleLimit = 16;
            }
        }
        while (this.particles.size() >= particleLimit) {
            TextParticle particle = this.particles.poll();
            if (particle == null) continue;
            particle.m_107274_();
        }
        Vec3 particlePos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() + 0.25, 0.0);
        Vec3 particleVelocity = entity.m_20184_();
        Vec3 particleVelocityForward = entity.m_20182_();
        particleVelocityForward = particleVelocityForward.m_82546_(client.f_91063_.m_109153_().m_90583_()).m_82541_();
        particleVelocityForward = particleVelocityForward.m_82490_((double)entity.m_20205_() * 10.0);
        particleVelocity = particleVelocity.m_82492_(particleVelocityForward.f_82479_, -20.0, particleVelocityForward.f_82481_);
        TextParticle particle = new TextParticle(world, particlePos, particleVelocity);
        String text = String.format("%.1f", Float.valueOf(damage));
        if (text.endsWith(".0")) {
            text = text.substring(0, text.length() - 2);
        }
        particle.setText(text);
        if (damage >= 16.0f) {
            particle.setColor(this.config.colorLg);
        } else if (damage >= 8.0f) {
            particle.setColor(Color.lerp(this.config.colorMd, this.config.colorLg, (damage - 8.0f) / 8.0f));
        } else if (damage >= 2.0f) {
            particle.setColor(Color.lerp(this.config.colorSm, this.config.colorMd, (damage - 2.0f) / 6.0f));
        } else {
            particle.setColor(this.config.colorSm);
        }
        this.particles.add(particle);
        client.f_91061_.m_107344_((Particle)particle);
    }
}

