/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.damagenumbers.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.foxgirl.damagenumbers.DamageNumbers;
import dev.foxgirl.damagenumbers.client.Color;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.jetbrains.annotations.NotNull;

public final class Config {
    public boolean isEnabled = true;
    public boolean isPlayerDamageShown = false;
    public Color colorSm = Color.valueOf("#FFAA00");
    public Color colorMd = Color.valueOf("#FF0000");
    public Color colorLg = Color.valueOf("#AA0000");
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().setLenient().create();

    public boolean optionGetEnabled() {
        return this.isEnabled;
    }

    public void optionSetEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean optionGetPlayerDamageShown() {
        return this.isPlayerDamageShown;
    }

    public void optionSetPlayerDamageShown(boolean shown) {
        this.isPlayerDamageShown = shown;
    }

    @NotNull
    public java.awt.Color optionGetColorSm() {
        return this.colorSm.toNativeColor();
    }

    public void optionSetColorSm(@NotNull java.awt.Color color) {
        this.colorSm = new Color(color);
    }

    @NotNull
    public java.awt.Color optionGetColorMd() {
        return this.colorMd.toNativeColor();
    }

    public void optionSetColorMd(@NotNull java.awt.Color color) {
        this.colorMd = new Color(color);
    }

    @NotNull
    public java.awt.Color optionGetColorLg() {
        return this.colorLg.toNativeColor();
    }

    public void optionSetColorLg(@NotNull java.awt.Color color) {
        this.colorLg = new Color(color);
    }

    @NotNull
    public String toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("isEnabled", Boolean.valueOf(this.isEnabled));
        json.addProperty("isPlayerDamageShown", Boolean.valueOf(this.isPlayerDamageShown));
        json.addProperty("colorSm", this.colorSm.toString());
        json.addProperty("colorMd", this.colorMd.toString());
        json.addProperty("colorLg", this.colorLg.toString());
        return GSON.toJson((JsonElement)json);
    }

    public void fromJson(@NotNull JsonObject json) {
        json.entrySet().forEach(entry -> {
            switch ((String)entry.getKey()) {
                case "isEnabled": {
                    this.isEnabled = ((JsonElement)entry.getValue()).getAsBoolean();
                    break;
                }
                case "isPlayerDamageShown": {
                    this.isPlayerDamageShown = ((JsonElement)entry.getValue()).getAsBoolean();
                    break;
                }
                case "colorSm": {
                    this.colorSm = Color.valueOf(((JsonElement)entry.getValue()).getAsString());
                    break;
                }
                case "colorMd": {
                    this.colorMd = Color.valueOf(((JsonElement)entry.getValue()).getAsString());
                    break;
                }
                case "colorLg": {
                    this.colorLg = Color.valueOf(((JsonElement)entry.getValue()).getAsString());
                }
            }
        });
    }

    public void readConfig(@NotNull PathProvider paths) {
        try {
            this.fromJson((JsonObject)GSON.fromJson((Reader)Files.newBufferedReader(paths.getConfigFilePath()), JsonObject.class));
        }
        catch (NoSuchFileException cause) {
            DamageNumbers.LOGGER.error("Failed to read config, file not found, creating config");
            this.writeConfig(paths);
        }
        catch (IOException cause) {
            DamageNumbers.LOGGER.error("Failed to read config, IO error", (Throwable)cause);
        }
        catch (JsonParseException cause) {
            DamageNumbers.LOGGER.error("Failed to read config, JSON error", (Throwable)cause);
        }
        catch (Exception cause) {
            DamageNumbers.LOGGER.error("Failed to read config", (Throwable)cause);
        }
    }

    public void writeConfig(@NotNull PathProvider paths) {
        try {
            Path pathFile = paths.getConfigFilePath();
            Path pathTemp = paths.getConfigTempPath();
            Files.writeString(pathTemp, (CharSequence)this.toJson(), new OpenOption[0]);
            Files.move(pathTemp, pathFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException cause) {
            DamageNumbers.LOGGER.error("Failed to write new config, IO error", (Throwable)cause);
        }
        catch (Exception cause) {
            DamageNumbers.LOGGER.error("Failed to write new config", (Throwable)cause);
        }
    }

    public static interface PathProvider {
        @NotNull
        public Path getConfigFilePath();

        @NotNull
        public Path getConfigTempPath();
    }
}

