/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.tradecycling;

import de.maxhenkel.tradecycling.TradeCyclingMod;
import de.maxhenkel.tradecycling.config.TradeCyclingClientConfig;
import de.maxhenkel.tradecycling.gui.CycleTradesButton;
import de.maxhenkel.tradecycling.mixin.AbstractContainerScreenAccessor;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.inventory.MerchantMenu;

public abstract class TradeCyclingClientMod {
    public static TradeCyclingClientConfig CONFIG;
    public static final KeyMapping CYCLE_TRADES_KEY;

    public TradeCyclingClientMod() {
        CONFIG = this.createClientConfig();
    }

    public void clientInit() {
        this.registerKeyBindings();
    }

    public static void sendCycleTradesPacket() {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            connection.m_104955_((Packet)new ServerboundCustomPayloadPacket(TradeCyclingMod.CYCLE_TRADES_PACKET, buffer));
        }
    }

    public abstract TradeCyclingClientConfig createClientConfig();

    public void registerKeyBindings() {
    }

    public <T extends GuiEventListener & Renderable> void onOpenScreen(Screen screen, Consumer<T> eventConsumer) {
        if (!(screen instanceof MerchantScreen)) {
            return;
        }
        MerchantScreen merchantScreen = (MerchantScreen)screen;
        if (!(screen instanceof AbstractContainerScreenAccessor)) {
            return;
        }
        AbstractContainerScreenAccessor s = (AbstractContainerScreenAccessor)screen;
        TradeCyclingClientConfig.CycleTradesButtonLocation loc = CONFIG.getCycleTradesButtonLocation();
        if (loc.equals((Object)TradeCyclingClientConfig.CycleTradesButtonLocation.NONE)) {
            return;
        }
        eventConsumer.accept(new CycleTradesButton(switch (loc) {
            default -> s.getLeftPos() + 107;
            case TradeCyclingClientConfig.CycleTradesButtonLocation.TOP_RIGHT -> s.getLeftPos() + 250;
        }, s.getTopPos() + 8, b -> TradeCyclingClientMod.sendCycleTradesPacket(), merchantScreen));
    }

    public void onCycleKeyPressed(int key, int scanCode, int action) {
        if (!CYCLE_TRADES_KEY.m_90832_(key, scanCode) || action != 1) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Screen currentScreen = mc.f_91080_;
        if (!(currentScreen instanceof MerchantScreen)) {
            return;
        }
        MerchantScreen screen = (MerchantScreen)currentScreen;
        if (!((MerchantMenu)screen.m_6262_()).m_40076_() || ((MerchantMenu)screen.m_6262_()).m_40065_() > 0) {
            return;
        }
        TradeCyclingClientMod.sendCycleTradesPacket();
        mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    static {
        CYCLE_TRADES_KEY = new KeyMapping("key.trade_cycling.cycle_trades", 67, "key.categories.inventory");
    }
}

