/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import java.util.Comparator;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalState;
import qouteall.q_misc_util.Helper;

public class TeleportationUtil {
    public static PortalPointVelocity getPortalPointVelocity(PortalState lastTickState, PortalState thisTickState, double localX, double localY) {
        Vec3 lastThisSidePos = lastTickState.getPointOnSurface(localX, localY);
        Vec3 currentThisSidePos = thisTickState.getPointOnSurface(localX, localY);
        Vec3 thisSideVelocity = currentThisSidePos.m_82546_(lastThisSidePos);
        Vec3 lastOtherSidePos = lastTickState.transformPoint(lastThisSidePos);
        Vec3 currentOtherSidePos = thisTickState.transformPoint(currentThisSidePos);
        Vec3 otherSideVelocity = currentOtherSidePos.m_82546_(lastOtherSidePos);
        return new PortalPointVelocity(thisSideVelocity, otherSideVelocity);
    }

    public static void transformEntityVelocity(Portal portal, Entity entity, PortalPointVelocity portalPointVelocity) {
        Vec3 oldVelocityRelativeToPortal = McHelper.getWorldVelocity(entity).m_82546_(portalPointVelocity.thisSidePointVelocity());
        Vec3 transformedVelocityRelativeToPortal = portal.transformVelocityRelativeToPortal(oldVelocityRelativeToPortal, entity);
        Vec3 newVelocity = transformedVelocityRelativeToPortal.m_82549_(portalPointVelocity.otherSidePointVelocity());
        McHelper.setWorldVelocity(entity, newVelocity);
    }

    @Nullable
    public static Teleportation checkStaticTeleportation(Portal portal, Vec3 lastPos, Vec3 currentPos, Vec3 lastTickEyePos, Vec3 thisTickEyePos) {
        Vec3 currentLocalPos;
        Vec3 lastLocalPos = portal.transformFromWorldToPortalLocal(lastPos);
        CollisionInfo collisionInfo = TeleportationUtil.checkTeleportationByPortalLocalPos(portal, lastLocalPos, currentLocalPos = portal.transformFromWorldToPortalLocal(currentPos));
        if (collisionInfo == null) {
            return null;
        }
        Vec3 newLastTickEyePos = portal.transformPoint(lastTickEyePos);
        Vec3 newThisTickEyePos = portal.transformPoint(thisTickEyePos);
        PortalState portalState = portal.getPortalState();
        return new Teleportation(false, portal, lastPos, currentPos, collisionInfo.portalLocalX, collisionInfo.portalLocalY, collisionInfo.tOfCollision, collisionInfo.collisionPos, portalState, portalState, portalState, portalState, portalState, PortalPointVelocity.zero, portal.transformPoint(collisionInfo.collisionPos), newLastTickEyePos, newThisTickEyePos);
    }

    @Nullable
    public static Teleportation checkDynamicTeleportation(Portal portal, PortalState lastFrameState, PortalState currentFrameState, Vec3 lastFrameEyePos, Vec3 currentFrameEyePos, PortalState lastTickState, PortalState thisTickState, Vec3 lastTickEyePos, Vec3 thisTickEyePos, float partialTicks) {
        Vec3 offset1;
        Vec3 currentLocalPos;
        Vec3 lastLocalPos = lastFrameState.worldPosToPortalLocalPos(lastFrameEyePos);
        CollisionInfo collisionInfo = TeleportationUtil.checkTeleportationByPortalLocalPos(portal, lastLocalPos, currentLocalPos = currentFrameState.worldPosToPortalLocalPos(currentFrameEyePos));
        if (collisionInfo == null) {
            return null;
        }
        double collisionLocalX = collisionInfo.portalLocalX;
        double collisionLocalY = collisionInfo.portalLocalY;
        PortalPointVelocity portalPointVelocity = TeleportationUtil.getPortalPointVelocity(lastTickState, thisTickState, collisionLocalX, collisionLocalY);
        PortalState collisionPortalState = PortalState.interpolate(lastFrameState, currentFrameState, collisionInfo.tOfCollision, false);
        Vec3 collisionPointMappedToThisFrame = thisTickState.getLocalPosTransformed(collisionLocalX, collisionLocalY);
        Vec3 collisionPointMappedToLastFrame = lastFrameState.getLocalPosTransformed(collisionLocalX, collisionLocalY);
        Vec3 newOtherSideLastTickPos = lastTickState.transformPoint(lastTickEyePos);
        Vec3 newOtherSideThisTickPos = thisTickState.transformPoint(thisTickEyePos);
        Vec3 newImmediateCameraPos = newOtherSideLastTickPos.m_165921_(newOtherSideThisTickPos, (double)partialTicks);
        Vec3 correctImmediateCameraPos = collisionPortalState.transformPoint(currentFrameEyePos);
        Vec3 deltaVelocity = portalPointVelocity.otherSidePointVelocity().m_82546_(collisionPortalState.transformVec(portalPointVelocity.thisSidePointVelocity()));
        Vec3 offset = correctImmediateCameraPos.m_82546_(newImmediateCameraPos);
        newOtherSideLastTickPos = newOtherSideLastTickPos.m_82549_(offset);
        double dot = (newOtherSideThisTickPos = newOtherSideThisTickPos.m_82549_(offset)).m_82546_(thisTickState.toPos).m_82526_(thisTickState.getContentDirection());
        if (dot < 1.0E-5) {
            Helper.log((Object)"Teleported to behind the end-tick portal destination. Corrected.");
            offset1 = thisTickState.getContentDirection().m_82490_(Math.max(-dot, 0.0) + 1.0E-5);
            newOtherSideThisTickPos = newOtherSideThisTickPos.m_82549_(offset1);
            newOtherSideLastTickPos = newOtherSideLastTickPos.m_82549_(offset1);
        }
        if ((dot = (newImmediateCameraPos = newOtherSideLastTickPos.m_165921_(newOtherSideThisTickPos, (double)partialTicks)).m_82546_(currentFrameState.toPos).m_82526_(currentFrameState.getContentDirection())) < 1.0E-5) {
            Helper.log((Object)"Teleported to behind the end-frame portal destination. Corrected.");
            offset1 = currentFrameState.getContentDirection().m_82490_(Math.max(-dot, 0.0) + 1.0E-5);
            newOtherSideThisTickPos = newOtherSideThisTickPos.m_82549_(offset1);
            newOtherSideLastTickPos = newOtherSideLastTickPos.m_82549_(offset1);
        }
        if ((dot = (newImmediateCameraPos = newOtherSideLastTickPos.m_165921_(newOtherSideThisTickPos, (double)partialTicks)).m_82546_(lastFrameState.toPos).m_82526_(lastFrameState.getContentDirection())) < 1.0E-5) {
            Helper.log((Object)"Teleported to behind the last-frame portal destination. Corrected.");
            offset1 = lastFrameState.getContentDirection().m_82490_(Math.max(-dot, 0.0) + 0.001);
            newOtherSideThisTickPos = newOtherSideThisTickPos.m_82549_(offset1);
            newOtherSideLastTickPos = newOtherSideLastTickPos.m_82549_(offset1);
        }
        Vec3 teleportationCheckpoint = newOtherSideLastTickPos.m_165921_(newOtherSideThisTickPos, (double)partialTicks);
        return new Teleportation(true, portal, lastFrameEyePos, currentFrameEyePos, collisionLocalX, collisionLocalY, collisionInfo.tOfCollision, collisionInfo.collisionPos, collisionPortalState, lastFrameState, currentFrameState, lastTickState, thisTickState, portalPointVelocity, teleportationCheckpoint, newOtherSideLastTickPos, newOtherSideThisTickPos);
    }

    @Nullable
    private static CollisionInfo checkTeleportationByPortalLocalPos(Portal portal, Vec3 lastLocalPos, Vec3 currentLocalPos) {
        boolean movedThrough;
        boolean bl = movedThrough = lastLocalPos.f_82481_ > 0.0 && currentLocalPos.f_82481_ < 0.0;
        if (!movedThrough) {
            return null;
        }
        Vec3 lineOrigin = lastLocalPos;
        Vec3 lineDirection = currentLocalPos.m_82546_(lastLocalPos);
        double t = Helper.getCollidingT((Vec3)Vec3.f_82478_, (Vec3)new Vec3(0.0, 0.0, 1.0), (Vec3)lineOrigin, (Vec3)lineDirection);
        Validate.isTrue((t < 1.00001 && t > -1.0E-5 ? 1 : 0) != 0);
        Vec3 collidingPoint = lineOrigin.m_82549_(lineDirection.m_82490_(t));
        boolean inProjection = portal.isLocalXYOnPortal(collidingPoint.f_82479_, collidingPoint.f_82480_);
        if (inProjection) {
            return new CollisionInfo(collidingPoint.f_82479_, collidingPoint.f_82480_, t, portal.transformFromPortalLocalToWorld(collidingPoint));
        }
        return null;
    }

    @Deprecated
    private static PortalPointVelocity getConservativePortalPointVelocity(PortalState lastTickState, PortalState thisTickState, Vec3 lastTickPos, Vec3 thisTickPos) {
        List<Vec3> localPoses = List.of(lastTickState.worldPosToPortalLocalPos(lastTickPos), lastTickState.worldPosToPortalLocalPos(thisTickPos), thisTickState.worldPosToPortalLocalPos(lastTickPos), thisTickState.worldPosToPortalLocalPos(thisTickPos));
        List<PortalPointVelocity> portalPointVelocities = localPoses.stream().map(localPos -> TeleportationUtil.getPortalPointVelocity(lastTickState, thisTickState, localPos.f_82479_, localPos.f_82480_)).toList();
        return new PortalPointVelocity(portalPointVelocities.stream().map(v -> v.thisSidePointVelocity).max(Comparator.comparingDouble(p -> p.m_82526_(lastTickState.getNormal()))).orElseThrow(), portalPointVelocities.stream().map(v -> v.otherSidePointVelocity).max(Comparator.comparingDouble(p -> p.m_82526_(thisTickState.getContentDirection()))).orElseThrow());
    }

    public record PortalPointVelocity(Vec3 thisSidePointVelocity, Vec3 otherSidePointVelocity) {
        public static final PortalPointVelocity zero = new PortalPointVelocity(Vec3.f_82478_, Vec3.f_82478_);
    }

    private record CollisionInfo(double portalLocalX, double portalLocalY, double tOfCollision, Vec3 collisionPos) {
    }

    public record Teleportation(boolean isDynamic, Portal portal, Vec3 lastFrameEyePos, Vec3 thisFrameEyePos, double collidingPosPortalLocalX, double collidingPosPortalLocalY, double tOfCollision, Vec3 collidingPos, PortalState collidingPortalState, PortalState lastFrameState, PortalState thisFrameState, PortalState lastTickState, PortalState thisTickState, PortalPointVelocity portalPointVelocity, Vec3 teleportationCheckpoint, Vec3 newLastTickEyePos, Vec3 newThisTickEyePos) {
    }

    public record PortalPointOffset(Vec3 thisSideOffset, Vec3 otherSideOffse) {
    }
}

