/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEGameRenderer;
import qouteall.imm_ptl.core.miscellaneous.ClientPerformanceMonitor;
import qouteall.imm_ptl.core.mixin.client.particle.IEParticle;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.MyRenderHelper;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.context_management.FogRendererContext;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;

public class RenderStates {
    public static int frameIndex = 0;
    public static ResourceKey<Level> originalPlayerDimension;
    public static Vec3 originalPlayerPos;
    public static Vec3 originalPlayerLastTickPos;
    public static GameType originalGameMode;
    public static AABB originalPlayerBoundingBox;
    private static float partialTick;
    public static Set<ResourceKey<Level>> renderedDimensions;
    public static List<List<WeakReference<PortalLike>>> lastPortalRenderInfos;
    public static List<List<WeakReference<PortalLike>>> portalRenderInfos;
    public static int portalsRenderedThisFrame;
    public static Vec3 lastCameraPos;
    public static Vec3 cameraPosDelta;
    public static boolean shouldForceDisableCull;
    public static long renderStartNanoTime;
    public static double viewBobFactor;
    public static Matrix4f basicProjectionMatrix;
    public static Camera originalCamera;
    public static String debugText;
    public static boolean isLaggy;
    public static boolean isRenderingEntities;
    public static boolean renderedScalingPortal;
    public static boolean isRenderingPortalWeather;

    public static void updatePreRenderInfo(float tickDelta_) {
        ClientWorldLoader.initializeIfNeeded();
        Entity cameraEntity = MyRenderHelper.client.f_91075_;
        if (cameraEntity == null) {
            return;
        }
        originalPlayerDimension = cameraEntity.m_9236_().m_46472_();
        originalPlayerPos = cameraEntity.m_20182_();
        originalPlayerLastTickPos = McHelper.lastTickPosOf(cameraEntity);
        PlayerInfo entry = CHelper.getClientPlayerListEntry();
        originalGameMode = entry != null ? entry.m_105325_() : GameType.CREATIVE;
        partialTick = tickDelta_;
        renderedDimensions.clear();
        lastPortalRenderInfos = portalRenderInfos;
        portalRenderInfos = new ArrayList<List<WeakReference<PortalLike>>>();
        portalsRenderedThisFrame = 0;
        FogRendererContext.update();
        renderStartNanoTime = System.nanoTime();
        RenderStates.updateViewBobbingFactor(cameraEntity);
        basicProjectionMatrix = null;
        originalCamera = MyRenderHelper.client.f_91063_.m_109153_();
        RenderStates.updateIsLaggy();
        debugText = "";
        QueryManager.queryStallCounter = 0;
        Vec3 velocity = McHelper.getWorldVelocity(cameraEntity);
        originalPlayerBoundingBox = cameraEntity.m_20191_().m_82363_(-velocity.f_82479_, -velocity.f_82480_, -velocity.f_82481_);
    }

    private static void updateIsLaggy() {
        if (!IPGlobal.lagAttackProof) {
            isLaggy = false;
            return;
        }
        if (isLaggy) {
            if (ClientPerformanceMonitor.getMinimumFps() > 15) {
                isLaggy = false;
            }
        } else if (lastPortalRenderInfos.size() > 10 && (ClientPerformanceMonitor.getAverageFps() < 8 || ClientPerformanceMonitor.getMinimumFps() < 6)) {
            MyRenderHelper.client.f_91065_.m_93063_((Component)Component.m_237115_((String)"imm_ptl.laggy"), false);
            isLaggy = true;
        }
    }

    private static void updateViewBobbingFactor(Entity cameraEntity) {
        Vec3 cameraPosVec = cameraEntity.m_20299_(RenderStates.getPartialTick());
        double minPortalDistance = CHelper.getClientNearbyPortals(16.0).map(portal -> portal.getDistanceToNearestPointInPortal(cameraPosVec)).min(Double::compareTo).orElse(100.0);
        if (minPortalDistance < 2.0) {
            if (minPortalDistance < 1.0) {
                RenderStates.setViewBobFactor(0.0);
            } else {
                RenderStates.setViewBobFactor(minPortalDistance - 1.0);
            }
        } else {
            RenderStates.setViewBobFactor(1.0);
        }
    }

    public static double getViewBobbingOffsetMultiplier() {
        if (!IPGlobal.viewBobbingReduce) {
            return 1.0;
        }
        if (!WorldRenderInfo.isViewBobbingEnabled()) {
            return 0.0;
        }
        double allScaling = PortalRendering.getExtraModelViewScaling();
        return viewBobFactor * allScaling;
    }

    private static void setViewBobFactor(double arg) {
        viewBobFactor = arg < viewBobFactor ? arg : Mth.m_14139_((double)0.1, (double)viewBobFactor, (double)arg);
    }

    public static void onTotalRenderEnd() {
        Minecraft client = Minecraft.m_91087_();
        IEGameRenderer gameRenderer = (IEGameRenderer)Minecraft.m_91087_().f_91063_;
        gameRenderer.setLightmapTextureManager(ClientWorldLoader.getDimensionRenderHelper((ResourceKey<Level>)client.f_91073_.m_46472_()).lightmapTexture);
        Vec3 currCameraPos = client.f_91063_.m_109153_().m_90583_();
        cameraPosDelta = currCameraPos.m_82546_(lastCameraPos);
        if (cameraPosDelta.m_82556_() > 1.0) {
            cameraPosDelta = Vec3.f_82478_;
        }
        lastCameraPos = currCameraPos;
    }

    public static int getRenderedPortalNum() {
        return portalRenderInfos.size();
    }

    public static boolean isDimensionRendered(ResourceKey<Level> dimensionType) {
        if (dimensionType == originalPlayerDimension) {
            return true;
        }
        return renderedDimensions.contains(dimensionType);
    }

    public static boolean shouldRenderParticle(Particle particle) {
        if (((IEParticle)particle).portal_getWorld() != Minecraft.m_91087_().f_91073_) {
            return false;
        }
        if (PortalRendering.isRendering()) {
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            Vec3 particlePos = particle.m_107277_().m_82399_();
            return renderingPortal.isOnDestinationSide(particlePos, 0.5);
        }
        return true;
    }

    public static void setPartialTick(float partialTick_) {
        partialTick = partialTick_;
    }

    public static float getPartialTick() {
        return partialTick;
    }

    static {
        originalPlayerPos = Vec3.f_82478_;
        originalPlayerLastTickPos = Vec3.f_82478_;
        partialTick = 0.0f;
        renderedDimensions = new HashSet<ResourceKey<Level>>();
        lastPortalRenderInfos = new ArrayList<List<WeakReference<PortalLike>>>();
        portalRenderInfos = new ArrayList<List<WeakReference<PortalLike>>>();
        portalsRenderedThisFrame = 0;
        lastCameraPos = Vec3.f_82478_;
        cameraPosDelta = Vec3.f_82478_;
        shouldForceDisableCull = false;
        isLaggy = false;
        isRenderingEntities = false;
        renderedScalingPortal = false;
        isRenderingPortalWeather = false;
    }
}

