/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.q_misc_util.my_util.Plane;

@Environment(value=EnvType.CLIENT)
public class PortalRendering {
    private static final Stack<PortalLike> portalLayers = new Stack();
    private static boolean isRenderingCache = false;
    private static boolean isRenderingOddNumberOfMirrorsCache = false;

    public static void pushPortalLayer(PortalLike portal) {
        portalLayers.push(portal);
        PortalRendering.updateCache();
    }

    public static void popPortalLayer() {
        portalLayers.pop();
        PortalRendering.updateCache();
    }

    private static void updateCache() {
        isRenderingCache = PortalRendering.getPortalLayer() != 0;
        int mirrorNum = 0;
        for (PortalLike portal : portalLayers) {
            if (!(portal instanceof Mirror)) continue;
            ++mirrorNum;
        }
        isRenderingOddNumberOfMirrorsCache = mirrorNum % 2 == 1;
    }

    public static int getPortalLayer() {
        return portalLayers.size();
    }

    public static boolean isRendering() {
        return isRenderingCache;
    }

    public static boolean isRenderingOddNumberOfMirrors() {
        return isRenderingOddNumberOfMirrorsCache;
    }

    public static int getMaxPortalLayer() {
        if (RenderStates.isLaggy) {
            return 1;
        }
        return IPGlobal.maxPortalLayer;
    }

    public static PortalLike getRenderingPortal() {
        return portalLayers.peek();
    }

    public static void onBeginPortalWorldRendering() {
        List currRenderInfo = portalLayers.stream().map(WeakReference::new).collect(Collectors.toList());
        RenderStates.portalRenderInfos.add(currRenderInfo);
        ++RenderStates.portalsRenderedThisFrame;
        if (portalLayers.stream().anyMatch(PortalLike::hasScaling)) {
            RenderStates.renderedScalingPortal = true;
        }
        CHelper.checkGlError();
    }

    public static void onEndPortalWorldRendering() {
        RenderStates.renderedDimensions.add(portalLayers.peek().getDestDim());
    }

    public static Vec3 getRenderingCameraPos() {
        Vec3 pos = RenderStates.originalCamera.m_90583_();
        for (PortalLike portal : portalLayers) {
            pos = portal.transformPoint(pos);
        }
        return pos;
    }

    public static double getExtraModelViewScaling() {
        double scale = 1.0;
        for (PortalLike portal : portalLayers) {
            if (PortalRenderer.shouldApplyScaleToModelView(portal)) continue;
            scale *= portal.getScale();
        }
        return scale;
    }

    @Nullable
    public static BlockPos getCaveCullingStartingPoint() {
        Validate.isTrue((boolean)PortalRendering.isRendering());
        PortalLike renderingPortal = PortalRendering.getRenderingPortal();
        if (!(renderingPortal instanceof Portal)) {
            return null;
        }
        Portal portal = (Portal)renderingPortal;
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        Vec3 outerCameraPos = portal.inverseTransformPoint(cameraPos);
        Vec3 nearestPoint = portal.getNearestPointInPortal(outerCameraPos);
        nearestPoint = nearestPoint.m_82549_(portal.getNormal().m_82490_(1.0E-5));
        Vec3 result = portal.transformPoint(nearestPoint);
        return BlockPos.m_274446_((Position)result);
    }

    public static boolean shouldEnableSodiumCaveCulling() {
        if (PortalRendering.isRendering()) {
            Vec3 currentCameraPos;
            Vec3 originalCameraPos;
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            double distance = renderingPortal.getDistanceToNearestPointInPortal(originalCameraPos = renderingPortal.inverseTransformPoint(currentCameraPos = CHelper.getCurrentCameraPos()));
            return distance < 5.0;
        }
        return false;
    }

    public static boolean shouldRenderHitResult() {
        if (PortalRendering.isRendering()) {
            HitResult hitResult = Minecraft.m_91087_().f_91077_;
            if (hitResult == null) {
                return false;
            }
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            if (renderingPortal instanceof Mirror) {
                return false;
            }
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                    BlockPos blockPos = blockHitResult.m_82425_();
                    Plane innerClipping = renderingPortal.getInnerClipping();
                    if (innerClipping != null) {
                        boolean roughlyInside = innerClipping.move(-0.1).isPointOnPositiveSide(Vec3.m_82512_((Vec3i)blockPos));
                        return roughlyInside;
                    }
                }
            }
        }
        return true;
    }

    @Nullable
    public static Plane getActiveClippingPlane() {
        PortalLike renderingPortal = PortalRendering.getRenderingPortal();
        Plane plane = renderingPortal.getInnerClipping();
        if (plane == null && portalLayers.size() >= 2) {
            for (int i = portalLayers.size() - 2; i >= 0; --i) {
                PortalLike portal = (PortalLike)portalLayers.get(i);
                Plane outerPlane = portal.getInnerClipping();
                if (outerPlane == null) continue;
                for (int j = i + 1; j < portalLayers.size(); ++j) {
                    PortalLike portal1 = (PortalLike)portalLayers.get(j);
                    outerPlane = new Plane(portal1.transformPoint(outerPlane.pos()), portal1.transformLocalVecNonScale(outerPlane.normal()));
                }
                return outerPlane;
            }
        }
        return plane;
    }
}

