/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.QueryManager;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

public class RendererDebug
extends PortalRenderer {
    @Override
    public void onBeforeTranslucentRendering(PoseStack matrixStack) {
        this.renderPortals(matrixStack);
    }

    @Override
    public void onAfterTranslucentRendering(PoseStack matrixStack) {
    }

    @Override
    public void onHandRenderingEnded(PoseStack matrixStack) {
    }

    @Override
    public void prepareRendering() {
    }

    @Override
    public void finishRendering() {
    }

    @Override
    public void renderPortalInEntityRenderer(Portal portal) {
    }

    @Override
    public boolean replaceFrameBufferClearing() {
        return false;
    }

    protected void doRenderPortal(PortalRenderable portal, PoseStack matrixStack) {
        if (RenderStates.getRenderedPortalNum() != 0) {
            return;
        }
        if (!this.testShouldRenderPortal(portal, matrixStack)) {
            return;
        }
        PortalRendering.pushPortalLayer(portal.getPortalLike());
        GlStateManager._clearColor((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GlStateManager._clearDepth((double)1.0);
        GlStateManager._clear((int)16640, (boolean)Minecraft.f_91002_);
        GL11.glDisable((int)2960);
        this.renderPortalContent(portal);
        PortalRendering.popPortalLayer();
    }

    private boolean testShouldRenderPortal(PortalRenderable portal, PoseStack matrixStack) {
        return QueryManager.renderAndGetDoesAnySamplePass(() -> ViewAreaRenderer.renderPortalArea(portal, Vec3.f_82478_, matrixStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), true, true, true, true));
    }

    protected void renderPortals(PoseStack matrixStack) {
        List<PortalRenderable> portalsToRender = this.getPortalsToRender(matrixStack);
        for (PortalRenderable portal : portalsToRender) {
            this.doRenderPortal(portal, matrixStack);
        }
    }
}

