/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.PortalRenderInfo;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.LimitedLogger;
import qouteall.q_misc_util.my_util.Plane;

@Environment(value=EnvType.CLIENT)
public class PortalGroup
implements PortalLike {
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);
    public final Portal.TransformationDesc transformationDesc;
    public final List<Portal> portals = new ArrayList<Portal>();
    private AABB exactBoundingBox;
    private Vec3 origin;
    private Vec3 dest;
    @Nullable
    private AABB destAreaBoxCache = null;
    @Nullable
    private Boolean isEnclosedCache = null;
    private final UUID uuid = Mth.m_14002_();

    public PortalGroup(Portal.TransformationDesc transformationDesc) {
        this.transformationDesc = transformationDesc;
    }

    public void addPortal(Portal portal) {
        Validate.isTrue((boolean)portal.m_9236_().m_5776_());
        Validate.isTrue((!portal.getIsGlobal() ? 1 : 0) != 0);
        if (this.portals.contains(portal)) {
            limitedLogger.err("Adding duplicate portal into group " + portal);
            return;
        }
        this.portals.add(portal);
        this.updateCache();
    }

    public void removePortal(Portal portal) {
        this.portals.remove(portal);
        this.updateCache();
    }

    public void updateCache() {
        this.exactBoundingBox = null;
        this.origin = null;
        this.dest = null;
        this.destAreaBoxCache = null;
        this.isEnclosedCache = null;
    }

    public AABB getDestAreaBox() {
        if (this.destAreaBoxCache == null) {
            this.destAreaBoxCache = Helper.transformBox((AABB)this.getExactAreaBox(), pos -> this.getFirstPortal().transformPoint((Vec3)pos));
        }
        return this.destAreaBoxCache;
    }

    @Override
    public boolean isConventionalPortal() {
        return false;
    }

    @Override
    public AABB getExactAreaBox() {
        if (this.exactBoundingBox == null) {
            this.exactBoundingBox = this.portals.stream().map(Portal::getExactBoundingBox).reduce(AABB::m_82367_).get();
        }
        return this.exactBoundingBox;
    }

    @Override
    public Vec3 transformPoint(Vec3 pos) {
        return this.getFirstPortal().transformPoint(pos);
    }

    @Override
    public Vec3 transformLocalVec(Vec3 localVec) {
        return this.getFirstPortal().transformLocalVec(localVec);
    }

    @Override
    public Vec3 transformLocalVecNonScale(Vec3 localVec) {
        return this.getFirstPortal().transformLocalVecNonScale(localVec);
    }

    @Override
    public Vec3 inverseTransformLocalVec(Vec3 localVec) {
        return this.getFirstPortal().inverseTransformLocalVec(localVec);
    }

    @Override
    public Vec3 inverseTransformPoint(Vec3 point) {
        return this.getFirstPortal().inverseTransformPoint(point);
    }

    @Override
    public double getDistanceToNearestPointInPortal(Vec3 point) {
        return Helper.getDistanceToBox((AABB)this.getExactAreaBox(), (Vec3)point);
    }

    @Override
    public double getDestAreaRadiusEstimation() {
        double maxDimension = this.getSizeEstimation();
        return maxDimension * this.transformationDesc.scaling();
    }

    @Override
    public Vec3 getOriginPos() {
        if (this.origin == null) {
            this.origin = this.getExactAreaBox().m_82399_();
        }
        return this.origin;
    }

    @Override
    public Vec3 getDestPos() {
        if (this.dest == null) {
            this.dest = this.transformPoint(this.getOriginPos());
        }
        return this.dest;
    }

    @Override
    public Level getOriginWorld() {
        return this.getFirstPortal().m_9236_();
    }

    @Override
    public Level getDestWorld() {
        return this.getFirstPortal().getDestWorld();
    }

    @Override
    public ResourceKey<Level> getDestDim() {
        return this.getFirstPortal().getDestDim();
    }

    @Override
    public boolean isRoughlyVisibleTo(Vec3 cameraPos) {
        return true;
    }

    @Override
    @Nullable
    public Plane getInnerClipping() {
        return null;
    }

    @Override
    public boolean isOnDestinationSide(Vec3 entityPos, double valve) {
        if (this.isEnclosed()) {
            return this.getDestAreaBox().m_82390_(entityPos);
        }
        return true;
    }

    @Override
    @Nullable
    public DQuaternion getRotation() {
        return this.transformationDesc.rotation();
    }

    @Override
    public double getScale() {
        return this.transformationDesc.scaling();
    }

    @Override
    public boolean getIsGlobal() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    @Nullable
    public Vec3[] getOuterFrustumCullingVertices() {
        return null;
    }

    @Override
    @Nullable
    public Matrix4f getAdditionalCameraTransformation() {
        return this.getFirstPortal().getAdditionalCameraTransformation();
    }

    @Override
    @Nullable
    public UUID getDiscriminator() {
        return this.uuid;
    }

    public void purge() {
        this.portals.removeIf(portal -> portal.m_213877_());
    }

    @Override
    public boolean cannotRenderInMe(Portal portal) {
        if (this.isEnclosed() && !this.getDestAreaBox().m_82381_(portal.getExactAreaBox())) {
            return true;
        }
        return this.portals.stream().anyMatch(p -> p.cannotRenderInMe(portal));
    }

    @Override
    public boolean isFuseView() {
        return this.getFirstPortal().isFuseView();
    }

    @Override
    public boolean getDoRenderPlayer() {
        return this.getFirstPortal().getDoRenderPlayer();
    }

    @Override
    public boolean getHasCrossPortalCollision() {
        return this.getFirstPortal().getHasCrossPortalCollision();
    }

    public String toString() {
        return String.format("PortalRenderingGroup(%s)(first:%s)", this.portals.size(), this.getFirstPortal());
    }

    public boolean isEnclosed() {
        if (this.isEnclosedCache == null) {
            this.isEnclosedCache = this.portals.stream().allMatch(p -> p.getOriginPos().m_82546_(this.getOriginPos()).m_82526_(p.getNormal()) > 0.3);
        }
        return this.isEnclosedCache;
    }

    public Portal getFirstPortal() {
        return this.portals.get(0);
    }

    public static PortalLike getPortalUnit(Portal portal) {
        PortalGroup group = PortalRenderInfo.getGroupOf(portal);
        if (group != null) {
            return group;
        }
        return portal;
    }
}

