/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.PortalRenderable;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.core.render.context_management.WorldRenderInfo;
import qouteall.q_misc_util.my_util.SignalBiArged;

public class MyRenderHelper {
    public static final Minecraft client = Minecraft.m_91087_();
    public static final SignalBiArged<ResourceProvider, Consumer<ShaderInstance>> loadShaderSignal = new SignalBiArged();
    public static DrawFbInAreaShader drawFbInAreaShader;
    public static ShaderInstance portalAreaShader;
    public static ShaderInstance blitScreenNoBlendShader;
    private static boolean debugEnabled;

    public static void init() {
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                DrawFbInAreaShader shader = new DrawFbInAreaShader(MyRenderHelper.getResourceFactory(resourceManager), "portal_draw_fb_in_area", DefaultVertexFormat.f_85815_);
                resultConsumer.accept(shader);
                drawFbInAreaShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                ShaderInstance shader = new ShaderInstance(MyRenderHelper.getResourceFactory(resourceManager), "portal_area", DefaultVertexFormat.f_85815_);
                resultConsumer.accept(shader);
                portalAreaShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        loadShaderSignal.connect((resourceManager, resultConsumer) -> {
            try {
                ShaderInstance shader = new ShaderInstance(MyRenderHelper.getResourceFactory(resourceManager), "blit_screen_noblend", DefaultVertexFormat.f_85819_);
                resultConsumer.accept(shader);
                blitScreenNoBlendShader = shader;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static ResourceProvider getResourceFactory(final ResourceProvider resourceManager) {
        ResourceProvider resourceFactory = new ResourceProvider(){

            public Optional<Resource> m_213713_(ResourceLocation resourceLocation) {
                ResourceLocation corrected = new ResourceLocation("immersive_portals", resourceLocation.m_135815_());
                return resourceManager.m_213713_(corrected);
            }
        };
        return resourceFactory;
    }

    public static void drawPortalAreaWithFramebuffer(PortalRenderable portal, RenderTarget textureProvider, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager._enableDepthTest();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._viewport((int)0, (int)0, (int)textureProvider.f_83915_, (int)textureProvider.f_83916_);
        DrawFbInAreaShader shader = drawFbInAreaShader;
        shader.m_173350_("DiffuseSampler", textureProvider.m_83975_());
        shader.loadWidthHeight(textureProvider.f_83915_, textureProvider.f_83916_);
        if (shader.f_173308_ != null) {
            shader.f_173308_.m_5679_(modelViewMatrix);
        }
        if (shader.f_173309_ != null) {
            shader.f_173309_.m_5679_(projectionMatrix);
        }
        shader.m_173363_();
        ViewAreaRenderer.buildPortalViewAreaTrianglesBuffer(Vec3.f_82478_, portal, CHelper.getCurrentCameraPos(), RenderStates.getPartialTick());
        shader.m_173362_();
    }

    public static void renderScreenTriangle() {
        MyRenderHelper.renderScreenTriangle(255, 255, 255, 255);
    }

    public static void renderScreenTriangle(Vec3 color) {
        MyRenderHelper.renderScreenTriangle((int)(color.f_82479_ * 255.0), (int)(color.f_82480_ * 255.0), (int)(color.f_82481_ * 255.0), 255);
    }

    public static void testOneTriangle(int r, int g, int b, int a) {
        ShaderInstance shader = GameRenderer.m_172811_();
        Validate.notNull((Object)shader);
        Matrix4f identityMatrix = new Matrix4f();
        identityMatrix.identity();
        shader.f_173308_.m_5679_(identityMatrix);
        shader.f_173309_.m_5679_(identityMatrix);
        shader.m_173363_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(-1.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(-1.0, -1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(1.0, -1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(1.0, 0.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(0.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(-1.0, 0.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        shader.m_173362_();
    }

    @IPVanillaCopy
    public static void renderScreenTriangle(int r, int g, int b, int a) {
        ShaderInstance shader = GameRenderer.m_172811_();
        Validate.notNull((Object)shader);
        Matrix4f identityMatrix = new Matrix4f();
        identityMatrix.identity();
        shader.f_173308_.m_5679_(identityMatrix);
        shader.f_173309_.m_5679_(identityMatrix);
        shader.m_173363_();
        Tesselator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_(1.0, -1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(1.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(-1.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(-1.0, 1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(-1.0, -1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        bufferBuilder.m_5483_(1.0, -1.0, 0.0).m_6122_(r, g, b, a).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        shader.m_173362_();
    }

    public static void drawScreenFrameBuffer(RenderTarget textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha) {
        float right = textureProvider.f_83917_;
        float up = textureProvider.f_83918_;
        float left = 0.0f;
        float bottom = 0.0f;
        int viewportWidth = textureProvider.f_83917_;
        int viewportHeight = textureProvider.f_83918_;
        MyRenderHelper.drawFramebufferWithViewport(textureProvider, doUseAlphaBlend, doEnableModifyAlpha, left, right, bottom, up, viewportWidth, viewportHeight);
    }

    public static void drawFramebuffer(RenderTarget textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, float xMin, double xMax, float yMin, double yMax) {
        MyRenderHelper.drawFramebufferWithViewport(textureProvider, doUseAlphaBlend, doEnableModifyAlpha, xMin, xMax, yMin, yMax, client.m_91268_().m_85441_(), client.m_91268_().m_85442_());
    }

    @IPVanillaCopy
    public static void drawFramebufferWithViewport(RenderTarget textureProvider, boolean doUseAlphaBlend, boolean doEnableModifyAlpha, float left, double right, float bottom, double up, int viewportWidth, int viewportHeight) {
        CHelper.checkGlError();
        GlStateManager._disableDepthTest();
        GlStateManager._depthMask((boolean)false);
        GlStateManager._viewport((int)0, (int)0, (int)viewportWidth, (int)viewportHeight);
        if (doUseAlphaBlend) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        } else {
            RenderSystem.disableBlend();
        }
        if (doEnableModifyAlpha) {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        } else {
            GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        ShaderInstance shader = doUseAlphaBlend ? MyRenderHelper.client.f_91063_.f_172635_ : blitScreenNoBlendShader;
        shader.m_173350_("DiffuseSampler", (Object)textureProvider.m_83975_());
        Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)viewportWidth, (float)viewportHeight, 0.0f, 1000.0f, 3000.0f);
        shader.f_173308_.m_5679_(new Matrix4f().translation(0.0f, 0.0f, -2000.0f));
        shader.f_173309_.m_5679_(projectionMatrix);
        shader.m_173363_();
        float textureXScale = (float)viewportWidth / (float)textureProvider.f_83915_;
        float textureYScale = (float)viewportHeight / (float)textureProvider.f_83916_;
        Tesselator tessellator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        bufferBuilder.m_5483_((double)left, up, 0.0).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_(right, up, 0.0).m_7421_(textureXScale, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_(right, (double)bottom, 0.0).m_7421_(textureXScale, textureYScale).m_6122_(255, 255, 255, 255).m_5752_();
        bufferBuilder.m_5483_((double)left, (double)bottom, 0.0).m_7421_(0.0f, textureYScale).m_6122_(255, 255, 255, 255).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        shader.m_173362_();
        GlStateManager._depthMask((boolean)true);
        GlStateManager._colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        CHelper.checkGlError();
    }

    public static void lateUpdateLight() {
        if (!ClientWorldLoader.getIsInitialized()) {
            return;
        }
        ClientWorldLoader.getClientWorlds().forEach(world -> {
            if (!RenderStates.isDimensionRendered((ResourceKey<Level>)world.m_46472_())) {
                world.m_7726_().m_7827_().m_9323_();
            }
        });
    }

    public static void earlyRemoteUpload() {
        if (!ClientWorldLoader.getIsInitialized()) {
            return;
        }
        ClientWorldLoader.worldRendererMap.forEach((dim, worldRenderer) -> {
            if (MyRenderHelper.client.f_91073_.m_46472_() != dim) {
                worldRenderer.m_173015_().m_194417_();
            }
        });
    }

    public static void applyMirrorFaceCulling() {
        GL11.glCullFace((int)1028);
    }

    public static void recoverFaceCulling() {
        GL11.glCullFace((int)1029);
    }

    public static void clearAlphaTo1(RenderTarget mcFrameBuffer) {
        mcFrameBuffer.m_83947_(true);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)true);
        RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.clear((int)16384, (boolean)true);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
    }

    public static void restoreViewPort() {
        Minecraft client = Minecraft.m_91087_();
        GlStateManager._viewport((int)0, (int)0, (int)client.m_91268_().m_85441_(), (int)client.m_91268_().m_85442_());
    }

    public static float transformFogDistance(float value) {
        PortalLike renderingPortal;
        if (!WorldRenderInfo.isFogEnabled()) {
            return value * 23333.0f;
        }
        if (PortalRendering.isRendering() && (renderingPortal = PortalRendering.getRenderingPortal()).isFuseView()) {
            return value * 23333.0f;
        }
        return value;
    }

    public static void debugFramebufferDepth() {
        if (!debugEnabled) {
            return;
        }
        debugEnabled = false;
        int width = MyRenderHelper.client.m_91385_().f_83915_;
        int height = MyRenderHelper.client.m_91385_().f_83916_;
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = directBuffer.asFloatBuffer();
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6402, (int)5126, (FloatBuffer)floatBuffer);
        float[] data = new float[width * height];
        floatBuffer.rewind();
        floatBuffer.get(data);
        float maxValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).max().getAsDouble();
        float minValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).min().getAsDouble();
        byte[] grayData = new byte[width * height];
        for (int i2 = 0; i2 < data.length; ++i2) {
            float datum = data[i2];
            datum = (datum - minValue) / (maxValue - minValue);
            grayData[i2] = (byte)(datum * 255.0f);
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 10);
        bufferedImage.setData(Raster.createRaster(bufferedImage.getSampleModel(), new DataBufferByte(grayData, grayData.length), new Point()));
        System.out.println("oops");
    }

    public static void debugFramebufferColorRed() {
        if (!debugEnabled) {
            return;
        }
        debugEnabled = false;
        int width = MyRenderHelper.client.m_91385_().f_83915_;
        int height = MyRenderHelper.client.m_91385_().f_83916_;
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.LITTLE_ENDIAN);
        FloatBuffer floatBuffer = directBuffer.asFloatBuffer();
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6403, (int)5126, (FloatBuffer)floatBuffer);
        float[] data = new float[width * height];
        floatBuffer.rewind();
        floatBuffer.get(data);
        float maxValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).max().getAsDouble();
        float minValue = (float)IntStream.range(0, data.length).mapToDouble(i -> data[i]).min().getAsDouble();
        byte[] grayData = new byte[width * height];
        for (int i2 = 0; i2 < data.length; ++i2) {
            float datum = data[i2];
            datum = (datum - minValue) / (maxValue - minValue);
            grayData[i2] = (byte)(datum * 255.0f);
        }
        BufferedImage bufferedImage = new BufferedImage(width, height, 10);
        bufferedImage.setData(Raster.createRaster(bufferedImage.getSampleModel(), new DataBufferByte(grayData, grayData.length), new Point()));
        System.out.println("oops");
    }

    static {
        debugEnabled = false;
    }

    public static class DrawFbInAreaShader
    extends ShaderInstance {
        public final Uniform uniformW = this.m_173348_("w");
        public final Uniform uniformH = this.m_173348_("h");

        public DrawFbInAreaShader(ResourceProvider factory, String name, VertexFormat format) throws IOException {
            super(factory, name, format);
        }

        void loadWidthHeight(int w, int h) {
            this.uniformW.m_5985_((float)w);
            this.uniformH.m_5985_((float)h);
        }
    }
}

