/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.nether_portal;

import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import qouteall.q_misc_util.my_util.IntBox;

public class BlockTraverse {
    public static <T> T searchFromTo(int from, int to, IntFunc<T> func) {
        if (from > to) {
            for (int i = from; i >= to; --i) {
                T obj = func.eval(i);
                if (obj == null) continue;
                return obj;
            }
        } else {
            for (int i = from; i <= to; ++i) {
                T obj = func.eval(i);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public static <T> T searchOnPlane(int centerX, int centerZ, int range, BiIntFunc<T> func) {
        T centerResult = func.eval(centerX, centerZ);
        if (centerResult != null) {
            return centerResult;
        }
        for (int layer = 1; layer < range; ++layer) {
            T obj;
            int w;
            for (w = 0; w < layer * 2; ++w) {
                obj = func.eval(layer + centerX, w + 1 - layer + centerZ);
                if (obj == null) continue;
                return obj;
            }
            for (w = 0; w < layer * 2; ++w) {
                obj = func.eval(-w + layer - 1 + centerX, layer + centerZ);
                if (obj == null) continue;
                return obj;
            }
            for (w = 0; w < layer * 2; ++w) {
                obj = func.eval(-layer + centerX, -w + layer - 1 + centerZ);
                if (obj == null) continue;
                return obj;
            }
            for (w = 0; w < layer * 2; ++w) {
                obj = func.eval(w + 1 - layer + centerX, -layer + centerZ);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public static <T> T searchColumnedRaw(int centerX, int centerZ, int range, int startY, int endY, TriIntFunc<T> func) {
        return (T)BlockTraverse.searchOnPlane(centerX, centerZ, range, (x, z) -> BlockTraverse.searchFromTo(startY, endY, y -> func.eval(x, y, z)));
    }

    public static <T> T searchColumned(int centerX, int centerZ, int range, int startY, int endY, Function<BlockPos, T> func) {
        BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
        return (T)BlockTraverse.searchColumnedRaw(centerX, centerZ, range, startY, endY, (x, y, z) -> {
            temp.m_122178_(x, y, z);
            return func.apply((BlockPos)temp);
        });
    }

    public static <T> T searchInBox(IntBox box, TriIntFunc<T> func) {
        for (int x = box.l.m_123341_(); x <= box.h.m_123341_(); ++x) {
            for (int y = box.l.m_123342_(); y <= box.h.m_123342_(); ++y) {
                for (int z = box.l.m_123343_(); z <= box.h.m_123343_(); ++z) {
                    T obj = func.eval(x, y, z);
                    if (obj == null) continue;
                    return obj;
                }
            }
        }
        return null;
    }

    public static <T> T searchInBox(IntBox box, Function<BlockPos, T> func) {
        BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
        return (T)BlockTraverse.searchInBox(box, (int x, int y, int z) -> {
            temp.m_122178_(x, y, z);
            return func.apply((BlockPos)temp);
        });
    }

    public static boolean boxAllMatch(IntBox box, Predicate<BlockPos> predicate) {
        Boolean result = BlockTraverse.searchInBox(box, (BlockPos mutable) -> {
            if (predicate.test((BlockPos)mutable)) {
                return true;
            }
            return null;
        });
        return result != null;
    }

    public static interface IntFunc<T> {
        public T eval(int var1);
    }

    public static interface BiIntFunc<T> {
        public T eval(int var1, int var2);
    }

    public static interface TriIntFunc<T> {
        public T eval(int var1, int var2, int var3);
    }
}

