/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.global_portals;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.network.IPNetworking;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;

public class GlobalPortalStorage
extends SavedData {
    public List<Portal> data;
    public final WeakReference<ServerLevel> world;
    private int version = 1;
    private boolean shouldReSync = false;
    @Nullable
    public BlockState bedrockReplacement;

    public static void init() {
        IPGlobal.postServerTickSignal.connect(() -> MiscHelper.getServer().m_129785_().forEach(world1 -> {
            GlobalPortalStorage gps = GlobalPortalStorage.get(world1);
            gps.tick();
        }));
        IPGlobal.serverCleanupSignal.connect(() -> {
            for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
                GlobalPortalStorage.get(world).onServerClose();
            }
        });
        DimensionAPI.serverDimensionDynamicUpdateEvent.register(dims -> {
            for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
                GlobalPortalStorage gps = GlobalPortalStorage.get(world);
                gps.clearAbnormalPortals();
                gps.syncToAllPlayers();
            }
        });
        if (!O_O.isDedicatedServer()) {
            GlobalPortalStorage.initClient();
        }
    }

    public static GlobalPortalStorage get(ServerLevel world) {
        return (GlobalPortalStorage)world.m_8895_().m_164861_(nbt -> {
            GlobalPortalStorage globalPortalStorage = new GlobalPortalStorage(world);
            globalPortalStorage.fromNbt((CompoundTag)nbt);
            return globalPortalStorage;
        }, () -> {
            Helper.log((Object)("Global portal storage initialized " + world.m_46472_().m_135782_()));
            return new GlobalPortalStorage(world);
        }, "global_portal");
    }

    public GlobalPortalStorage(ServerLevel world_) {
        this.world = new WeakReference<ServerLevel>(world_);
        this.data = new ArrayList<Portal>();
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        MiscHelper.getServer().m_129785_().forEach(world -> {
            GlobalPortalStorage storage = GlobalPortalStorage.get(world);
            if (!storage.data.isEmpty()) {
                player.f_8906_.m_9829_(IPNetworking.createGlobalPortalUpdate(storage));
            }
        });
    }

    public void onDataChanged() {
        this.m_77760_(true);
        this.shouldReSync = true;
    }

    public void removePortal(Portal portal) {
        this.data.remove(portal);
        portal.m_142687_(Entity.RemovalReason.KILLED);
        this.onDataChanged();
    }

    public void addPortal(Portal portal) {
        Validate.isTrue((!this.data.contains(portal) ? 1 : 0) != 0);
        Validate.isTrue((boolean)portal.isPortalValid());
        portal.isGlobalPortal = true;
        portal.myUnsetRemoved();
        this.data.add(portal);
        this.onDataChanged();
    }

    public void removePortals(Predicate<Portal> predicate) {
        this.data.removeIf(portal -> {
            boolean shouldRemove = predicate.test((Portal)portal);
            if (shouldRemove) {
                portal.m_142687_(Entity.RemovalReason.KILLED);
            }
            return shouldRemove;
        });
        this.onDataChanged();
    }

    private void syncToAllPlayers() {
        Packet packet = IPNetworking.createGlobalPortalUpdate(this);
        McHelper.getCopiedPlayerList().forEach(player -> player.f_8906_.m_9829_(packet));
    }

    public void fromNbt(CompoundTag tag) {
        ServerLevel currWorld = (ServerLevel)this.world.get();
        Validate.notNull((Object)currWorld);
        List<Portal> newData = GlobalPortalStorage.getPortalsFromTag(tag, (Level)currWorld);
        this.data = newData;
        if (tag.m_128441_("version")) {
            this.version = tag.m_128451_("version");
        }
        this.bedrockReplacement = tag.m_128441_("bedrockReplacement") ? NbtUtils.m_247651_((HolderGetter)currWorld.m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("bedrockReplacement")) : null;
        this.clearAbnormalPortals();
    }

    private static List<Portal> getPortalsFromTag(CompoundTag tag, Level currWorld) {
        ListTag listTag = tag.m_128437_("data", 10);
        ArrayList<Portal> newData = new ArrayList<Portal>();
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            Portal e = GlobalPortalStorage.readPortalFromTag(currWorld, compoundTag);
            if (e != null) {
                newData.add(e);
                continue;
            }
            Helper.err((Object)("error reading portal" + compoundTag));
        }
        return newData;
    }

    private static Portal readPortalFromTag(Level currWorld, CompoundTag compoundTag) {
        ResourceLocation entityId = new ResourceLocation(compoundTag.m_128461_("entity_type"));
        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityId);
        Entity e = entityType.m_20615_(currWorld);
        e.m_20258_(compoundTag);
        ((Portal)e).isGlobalPortal = true;
        ((Portal)e).updateCache();
        return (Portal)e;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        if (this.data == null) {
            return tag;
        }
        ListTag listTag = new ListTag();
        ServerLevel currWorld = (ServerLevel)this.world.get();
        Validate.notNull((Object)currWorld);
        for (Portal portal : this.data) {
            Validate.isTrue((portal.m_9236_() == currWorld ? 1 : 0) != 0);
            CompoundTag portalTag = new CompoundTag();
            portal.m_20240_(portalTag);
            portalTag.m_128359_("entity_type", EntityType.m_20613_((EntityType)portal.m_6095_()).toString());
            listTag.add((Object)portalTag);
        }
        tag.m_128365_("data", (Tag)listTag);
        tag.m_128405_("version", this.version);
        if (this.bedrockReplacement != null) {
            tag.m_128365_("bedrockReplacement", (Tag)NbtUtils.m_129202_((BlockState)this.bedrockReplacement));
        }
        return tag;
    }

    public void tick() {
        if (this.shouldReSync) {
            this.syncToAllPlayers();
            this.shouldReSync = false;
        }
        if (this.version <= 1) {
            GlobalPortalStorage.upgradeData((ServerLevel)this.world.get());
            this.version = 2;
            this.m_77760_(true);
        }
    }

    public void clearAbnormalPortals() {
        this.data.removeIf(e -> {
            ResourceKey<Level> dimensionTo = e.dimensionTo;
            if (MiscHelper.getServer().m_129880_(dimensionTo) == null) {
                Helper.err((Object)("Missing Dimension for global portal " + dimensionTo.m_135782_()));
                return true;
            }
            return false;
        });
    }

    private static void upgradeData(ServerLevel world) {
    }

    public static void convertNormalPortalIntoGlobalPortal(Portal portal) {
        Validate.isTrue((!portal.getIsGlobal() ? 1 : 0) != 0);
        Validate.isTrue((!portal.m_9236_().m_5776_() ? 1 : 0) != 0);
        portal.specialShape = null;
        portal.m_142687_(Entity.RemovalReason.KILLED);
        Portal newPortal = McHelper.copyEntity(portal);
        GlobalPortalStorage.get((ServerLevel)portal.m_9236_()).addPortal(newPortal);
    }

    public static void convertGlobalPortalIntoNormalPortal(Portal portal) {
        Validate.isTrue((boolean)portal.getIsGlobal());
        Validate.isTrue((!portal.m_9236_().m_5776_() ? 1 : 0) != 0);
        GlobalPortalStorage.get((ServerLevel)portal.m_9236_()).removePortal(portal);
        Portal newPortal = McHelper.copyEntity(portal);
        McHelper.spawnServerEntity(newPortal);
    }

    private void onServerClose() {
        for (Portal portal : this.data) {
            portal.m_142687_(Entity.RemovalReason.UNLOADED_TO_CHUNK);
        }
    }

    @NotNull
    public static List<Portal> getGlobalPortals(Level world) {
        List<Portal> result = world.m_5776_() ? CHelper.getClientGlobalPortal(world) : (world instanceof ServerLevel ? GlobalPortalStorage.get((ServerLevel)((ServerLevel)world)).data : null);
        return result != null ? result : Collections.emptyList();
    }
}

