/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.custom_portal_gen.CustomPortalGeneration;
import qouteall.imm_ptl.core.portal.custom_portal_gen.SimpleBlockPredicate;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.GeneralBreakablePortal;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;

public class OneWayForm
extends PortalGenForm {
    public static final Codec<OneWayForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)SimpleBlockPredicate.codec.fieldOf("frame_block").forGetter(o -> o.frameBlock), (App)SimpleBlockPredicate.codec.fieldOf("area_block").forGetter(o -> o.areaBlock), (App)Codec.BOOL.fieldOf("bi_faced").forGetter(o -> o.biFaced), (App)Codec.BOOL.optionalFieldOf("breakable", (Object)true).forGetter(o -> o.breakable)).apply((Applicative)instance, instance.stable(OneWayForm::new)));
    public final SimpleBlockPredicate frameBlock;
    public final SimpleBlockPredicate areaBlock;
    public final boolean biFaced;
    public final boolean breakable;

    public OneWayForm(SimpleBlockPredicate frameBlock, SimpleBlockPredicate areaBlock, boolean biFaced, boolean breakable) {
        this.frameBlock = frameBlock;
        this.areaBlock = areaBlock;
        this.biFaced = biFaced;
        this.breakable = breakable;
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return this;
    }

    @Override
    public boolean perform(CustomPortalGeneration cpg, ServerLevel fromWorld, BlockPos startingPos, ServerLevel toWorld, @Nullable Entity triggeringEntity) {
        if (!NetherPortalGeneration.checkPortalGeneration(fromWorld, startingPos)) {
            return false;
        }
        BlockPortalShape fromShape = NetherPortalGeneration.findFrameShape(fromWorld, startingPos, this.areaBlock, this.frameBlock);
        if (fromShape == null) {
            return false;
        }
        for (BlockPos areaPos : fromShape.area) {
            fromWorld.m_46597_(areaPos, Blocks.f_50016_.m_49966_());
        }
        if (this.breakable) {
            NetherPortalGeneration.fillInPlaceHolderBlocks(fromWorld, fromShape);
        }
        GeneralBreakablePortal portal = (GeneralBreakablePortal)GeneralBreakablePortal.entityType.m_20615_((Level)fromWorld);
        Validate.notNull((Object)portal);
        fromShape.initPortalPosAxisShape(portal, Direction.AxisDirection.POSITIVE);
        if (triggeringEntity == null) {
            portal.setDestination(portal.getOriginPos().m_82520_(0.0, 10.0, 0.0));
            portal.setDestinationDimension((ResourceKey<Level>)fromWorld.m_46472_());
        } else {
            portal.setDestination(triggeringEntity.m_20299_(1.0f));
            portal.setDestinationDimension((ResourceKey<Level>)triggeringEntity.m_9236_().m_46472_());
        }
        portal.blockPortalShape = fromShape;
        portal.markOneWay();
        McHelper.spawnServerEntity(portal);
        Portal[] resultPortals = null;
        if (this.biFaced) {
            GeneralBreakablePortal flippedPortal = PortalAPI.createFlippedPortal(portal);
            flippedPortal.blockPortalShape = fromShape;
            flippedPortal.markOneWay();
            McHelper.spawnServerEntity(flippedPortal);
            resultPortals = new GeneralBreakablePortal[]{portal, flippedPortal};
        } else {
            resultPortals = new GeneralBreakablePortal[]{portal};
        }
        if (!this.breakable) {
            for (Portal p : resultPortals) {
                ((GeneralBreakablePortal)p).unbreakable = true;
            }
        }
        cpg.onPortalsGenerated(resultPortals);
        return true;
    }
}

