/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen.form;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.SimpleBlockPredicate;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.FlippingFloorSquareForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.HeterogeneousForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalGeneration;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntBox;

public class FlippingFloorSquareNewForm
extends HeterogeneousForm {
    public static final Codec<FlippingFloorSquareNewForm> codec = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("generate_frame_if_not_found").forGetter(o -> o.generateFrameIfNotFound), (App)SimpleBlockPredicate.codec.fieldOf("area_block").forGetter(o -> o.areaBlock), (App)SimpleBlockPredicate.codec.fieldOf("frame_block").forGetter(o -> o.frameBlock)).apply((Applicative)instance, FlippingFloorSquareNewForm::new));

    public FlippingFloorSquareNewForm(boolean generateFrameIfNotFound, SimpleBlockPredicate areaBlock, SimpleBlockPredicate frameBlock) {
        super(generateFrameIfNotFound, areaBlock, frameBlock);
    }

    public BreakablePortalEntity[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        ServerLevel fromWorld = McHelper.getServerWorld(info.from);
        ServerLevel toWorld = McHelper.getServerWorld(info.to);
        NetherPortalGeneration.fillInPlaceHolderBlocks(fromWorld, info.fromShape);
        NetherPortalGeneration.fillInPlaceHolderBlocks(toWorld, info.toShape);
        return FlippingFloorSquareForm.createPortals(fromWorld, toWorld, info.fromShape, info.toShape);
    }

    @Override
    public boolean testThisSideShape(ServerLevel fromWorld, BlockPortalShape fromShape) {
        if (fromShape.axis != Direction.Axis.Y) {
            return false;
        }
        IntBox box = fromShape.innerAreaBox;
        BlockPos boxSize = box.getSize();
        return boxSize.m_123341_() == boxSize.m_123343_() && boxSize.m_123341_() * boxSize.m_123343_() == fromShape.area.size();
    }

    @Override
    public PortalGenInfo getNewPortalPlacement(ServerLevel toWorld, BlockPos toPos, ServerLevel fromWorld, BlockPortalShape fromShape, @Nullable Entity triggeringEntity) {
        IntBox portalPlacement = FlippingFloorSquareForm.findPortalPlacement(toWorld, fromShape.totalAreaBox.getSize(), toPos);
        BlockPortalShape placedShape = fromShape.getShapeWithMovedTotalAreaBox(portalPlacement);
        return new PortalGenInfo((ResourceKey<Level>)fromWorld.m_46472_(), (ResourceKey<Level>)toWorld.m_46472_(), fromShape, placedShape, DQuaternion.rotationByDegrees((Vec3)new Vec3(1.0, 0.0, 0.0), (double)180.0), 1.0);
    }

    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        return codec;
    }

    @Override
    public PortalGenForm getReverse() {
        return new FlippingFloorSquareNewForm(this.generateFrameIfNotFound, this.areaBlock, this.frameBlock);
    }
}

